/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a version 2 API in Amazon API Gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsApiGatewayV2ApiDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsApiGatewayV2ApiDetails.Builder, AwsApiGatewayV2ApiDetails> {
    private static final SdkField<String> API_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiEndpoint").getter(getter(AwsApiGatewayV2ApiDetails::apiEndpoint))
            .setter(setter(Builder::apiEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiEndpoint").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(AwsApiGatewayV2ApiDetails::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiId").build()).build();

    private static final SdkField<String> API_KEY_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiKeySelectionExpression").getter(getter(AwsApiGatewayV2ApiDetails::apiKeySelectionExpression))
            .setter(setter(Builder::apiKeySelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeySelectionExpression").build())
            .build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(AwsApiGatewayV2ApiDetails::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsApiGatewayV2ApiDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(AwsApiGatewayV2ApiDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsApiGatewayV2ApiDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtocolType").getter(getter(AwsApiGatewayV2ApiDetails::protocolType))
            .setter(setter(Builder::protocolType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolType").build()).build();

    private static final SdkField<String> ROUTE_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteSelectionExpression").getter(getter(AwsApiGatewayV2ApiDetails::routeSelectionExpression))
            .setter(setter(Builder::routeSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSelectionExpression").build())
            .build();

    private static final SdkField<AwsCorsConfiguration> CORS_CONFIGURATION_FIELD = SdkField
            .<AwsCorsConfiguration> builder(MarshallingType.SDK_POJO).memberName("CorsConfiguration")
            .getter(getter(AwsApiGatewayV2ApiDetails::corsConfiguration)).setter(setter(Builder::corsConfiguration))
            .constructor(AwsCorsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CorsConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ENDPOINT_FIELD,
            API_ID_FIELD, API_KEY_SELECTION_EXPRESSION_FIELD, CREATED_DATE_FIELD, DESCRIPTION_FIELD, VERSION_FIELD, NAME_FIELD,
            PROTOCOL_TYPE_FIELD, ROUTE_SELECTION_EXPRESSION_FIELD, CORS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiEndpoint;

    private final String apiId;

    private final String apiKeySelectionExpression;

    private final String createdDate;

    private final String description;

    private final String version;

    private final String name;

    private final String protocolType;

    private final String routeSelectionExpression;

    private final AwsCorsConfiguration corsConfiguration;

    private AwsApiGatewayV2ApiDetails(BuilderImpl builder) {
        this.apiEndpoint = builder.apiEndpoint;
        this.apiId = builder.apiId;
        this.apiKeySelectionExpression = builder.apiKeySelectionExpression;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.version = builder.version;
        this.name = builder.name;
        this.protocolType = builder.protocolType;
        this.routeSelectionExpression = builder.routeSelectionExpression;
        this.corsConfiguration = builder.corsConfiguration;
    }

    /**
     * <p>
     * The URI of the API.
     * </p>
     * <p>
     * Uses the format <code> <i>&lt;api-id&gt;</i>.execute-api.<i>&lt;region&gt;</i>.amazonaws.com</code>
     * </p>
     * <p>
     * The stage name is typically appended to the URI to form a complete path to a deployed API stage.
     * </p>
     * 
     * @return The URI of the API. </p>
     *         <p>
     *         Uses the format <code> <i>&lt;api-id&gt;</i>.execute-api.<i>&lt;region&gt;</i>.amazonaws.com</code>
     *         </p>
     *         <p>
     *         The stage name is typically appended to the URI to form a complete path to a deployed API stage.
     */
    public final String apiEndpoint() {
        return apiEndpoint;
    }

    /**
     * <p>
     * The identifier of the API.
     * </p>
     * 
     * @return The identifier of the API.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * An API key selection expression. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return An API key selection expression. Supported only for WebSocket APIs.
     */
    public final String apiKeySelectionExpression() {
        return apiKeySelectionExpression;
    }

    /**
     * <p>
     * Indicates when the API was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the API was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * A description of the API.
     * </p>
     * 
     * @return A description of the API.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version identifier for the API.
     * </p>
     * 
     * @return The version identifier for the API.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The name of the API.
     * </p>
     * 
     * @return The name of the API.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The API protocol for the API.
     * </p>
     * <p>
     * Valid values: <code>WEBSOCKET</code> | <code>HTTP</code>
     * </p>
     * 
     * @return The API protocol for the API.</p>
     *         <p>
     *         Valid values: <code>WEBSOCKET</code> | <code>HTTP</code>
     */
    public final String protocolType() {
        return protocolType;
    }

    /**
     * <p>
     * The route selection expression for the API.
     * </p>
     * <p>
     * For HTTP APIs, must be <code>${request.method} ${request.path}</code>. This is the default value for HTTP APIs.
     * </p>
     * <p>
     * For WebSocket APIs, there is no default value.
     * </p>
     * 
     * @return The route selection expression for the API.</p>
     *         <p>
     *         For HTTP APIs, must be <code>${request.method} ${request.path}</code>. This is the default value for HTTP
     *         APIs.
     *         </p>
     *         <p>
     *         For WebSocket APIs, there is no default value.
     */
    public final String routeSelectionExpression() {
        return routeSelectionExpression;
    }

    /**
     * <p>
     * A cross-origin resource sharing (CORS) configuration. Supported only for HTTP APIs.
     * </p>
     * 
     * @return A cross-origin resource sharing (CORS) configuration. Supported only for HTTP APIs.
     */
    public final AwsCorsConfiguration corsConfiguration() {
        return corsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeySelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protocolType());
        hashCode = 31 * hashCode + Objects.hashCode(routeSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(corsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayV2ApiDetails)) {
            return false;
        }
        AwsApiGatewayV2ApiDetails other = (AwsApiGatewayV2ApiDetails) obj;
        return Objects.equals(apiEndpoint(), other.apiEndpoint()) && Objects.equals(apiId(), other.apiId())
                && Objects.equals(apiKeySelectionExpression(), other.apiKeySelectionExpression())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(description(), other.description())
                && Objects.equals(version(), other.version()) && Objects.equals(name(), other.name())
                && Objects.equals(protocolType(), other.protocolType())
                && Objects.equals(routeSelectionExpression(), other.routeSelectionExpression())
                && Objects.equals(corsConfiguration(), other.corsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsApiGatewayV2ApiDetails").add("ApiEndpoint", apiEndpoint()).add("ApiId", apiId())
                .add("ApiKeySelectionExpression", apiKeySelectionExpression()).add("CreatedDate", createdDate())
                .add("Description", description()).add("Version", version()).add("Name", name())
                .add("ProtocolType", protocolType()).add("RouteSelectionExpression", routeSelectionExpression())
                .add("CorsConfiguration", corsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiEndpoint":
            return Optional.ofNullable(clazz.cast(apiEndpoint()));
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "ApiKeySelectionExpression":
            return Optional.ofNullable(clazz.cast(apiKeySelectionExpression()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProtocolType":
            return Optional.ofNullable(clazz.cast(protocolType()));
        case "RouteSelectionExpression":
            return Optional.ofNullable(clazz.cast(routeSelectionExpression()));
        case "CorsConfiguration":
            return Optional.ofNullable(clazz.cast(corsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayV2ApiDetails, T> g) {
        return obj -> g.apply((AwsApiGatewayV2ApiDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsApiGatewayV2ApiDetails> {
        /**
         * <p>
         * The URI of the API.
         * </p>
         * <p>
         * Uses the format <code> <i>&lt;api-id&gt;</i>.execute-api.<i>&lt;region&gt;</i>.amazonaws.com</code>
         * </p>
         * <p>
         * The stage name is typically appended to the URI to form a complete path to a deployed API stage.
         * </p>
         * 
         * @param apiEndpoint
         *        The URI of the API. </p>
         *        <p>
         *        Uses the format <code> <i>&lt;api-id&gt;</i>.execute-api.<i>&lt;region&gt;</i>.amazonaws.com</code>
         *        </p>
         *        <p>
         *        The stage name is typically appended to the URI to form a complete path to a deployed API stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiEndpoint(String apiEndpoint);

        /**
         * <p>
         * The identifier of the API.
         * </p>
         * 
         * @param apiId
         *        The identifier of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * An API key selection expression. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param apiKeySelectionExpression
         *        An API key selection expression. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeySelectionExpression(String apiKeySelectionExpression);

        /**
         * <p>
         * Indicates when the API was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createdDate
         *        Indicates when the API was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);

        /**
         * <p>
         * A description of the API.
         * </p>
         * 
         * @param description
         *        A description of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version identifier for the API.
         * </p>
         * 
         * @param version
         *        The version identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The name of the API.
         * </p>
         * 
         * @param name
         *        The name of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The API protocol for the API.
         * </p>
         * <p>
         * Valid values: <code>WEBSOCKET</code> | <code>HTTP</code>
         * </p>
         * 
         * @param protocolType
         *        The API protocol for the API.</p>
         *        <p>
         *        Valid values: <code>WEBSOCKET</code> | <code>HTTP</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolType(String protocolType);

        /**
         * <p>
         * The route selection expression for the API.
         * </p>
         * <p>
         * For HTTP APIs, must be <code>${request.method} ${request.path}</code>. This is the default value for HTTP
         * APIs.
         * </p>
         * <p>
         * For WebSocket APIs, there is no default value.
         * </p>
         * 
         * @param routeSelectionExpression
         *        The route selection expression for the API.</p>
         *        <p>
         *        For HTTP APIs, must be <code>${request.method} ${request.path}</code>. This is the default value for
         *        HTTP APIs.
         *        </p>
         *        <p>
         *        For WebSocket APIs, there is no default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSelectionExpression(String routeSelectionExpression);

        /**
         * <p>
         * A cross-origin resource sharing (CORS) configuration. Supported only for HTTP APIs.
         * </p>
         * 
         * @param corsConfiguration
         *        A cross-origin resource sharing (CORS) configuration. Supported only for HTTP APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsConfiguration(AwsCorsConfiguration corsConfiguration);

        /**
         * <p>
         * A cross-origin resource sharing (CORS) configuration. Supported only for HTTP APIs.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCorsConfiguration.Builder} avoiding
         * the need to create one manually via {@link AwsCorsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCorsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #corsConfiguration(AwsCorsConfiguration)}.
         * 
         * @param corsConfiguration
         *        a consumer that will call methods on {@link AwsCorsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #corsConfiguration(AwsCorsConfiguration)
         */
        default Builder corsConfiguration(Consumer<AwsCorsConfiguration.Builder> corsConfiguration) {
            return corsConfiguration(AwsCorsConfiguration.builder().applyMutation(corsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String apiEndpoint;

        private String apiId;

        private String apiKeySelectionExpression;

        private String createdDate;

        private String description;

        private String version;

        private String name;

        private String protocolType;

        private String routeSelectionExpression;

        private AwsCorsConfiguration corsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayV2ApiDetails model) {
            apiEndpoint(model.apiEndpoint);
            apiId(model.apiId);
            apiKeySelectionExpression(model.apiKeySelectionExpression);
            createdDate(model.createdDate);
            description(model.description);
            version(model.version);
            name(model.name);
            protocolType(model.protocolType);
            routeSelectionExpression(model.routeSelectionExpression);
            corsConfiguration(model.corsConfiguration);
        }

        public final String getApiEndpoint() {
            return apiEndpoint;
        }

        public final void setApiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
        }

        @Override
        public final Builder apiEndpoint(String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getApiKeySelectionExpression() {
            return apiKeySelectionExpression;
        }

        public final void setApiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
        }

        @Override
        public final Builder apiKeySelectionExpression(String apiKeySelectionExpression) {
            this.apiKeySelectionExpression = apiKeySelectionExpression;
            return this;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtocolType() {
            return protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public final String getRouteSelectionExpression() {
            return routeSelectionExpression;
        }

        public final void setRouteSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
        }

        @Override
        public final Builder routeSelectionExpression(String routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        public final AwsCorsConfiguration.Builder getCorsConfiguration() {
            return corsConfiguration != null ? corsConfiguration.toBuilder() : null;
        }

        public final void setCorsConfiguration(AwsCorsConfiguration.BuilderImpl corsConfiguration) {
            this.corsConfiguration = corsConfiguration != null ? corsConfiguration.build() : null;
        }

        @Override
        public final Builder corsConfiguration(AwsCorsConfiguration corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        @Override
        public AwsApiGatewayV2ApiDetails build() {
            return new AwsApiGatewayV2ApiDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
