/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an enabled security standard in which a security control is enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedStandard implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociatedStandard.Builder, AssociatedStandard> {
    private static final SdkField<String> STANDARDS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardsId").getter(getter(AssociatedStandard::standardsId)).setter(setter(Builder::standardsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String standardsId;

    private AssociatedStandard(BuilderImpl builder) {
        this.standardsId = builder.standardsId;
    }

    /**
     * <p>
     * The unique identifier of a standard in which a control is enabled. This field consists of the resource portion of
     * the Amazon Resource Name (ARN) returned for a standard in the <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a>
     * API response.
     * </p>
     * 
     * @return The unique identifier of a standard in which a control is enabled. This field consists of the resource
     *         portion of the Amazon Resource Name (ARN) returned for a standard in the <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"
     *         >DescribeStandards</a> API response.
     */
    public final String standardsId() {
        return standardsId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardsId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedStandard)) {
            return false;
        }
        AssociatedStandard other = (AssociatedStandard) obj;
        return Objects.equals(standardsId(), other.standardsId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedStandard").add("StandardsId", standardsId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsId":
            return Optional.ofNullable(clazz.cast(standardsId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedStandard, T> g) {
        return obj -> g.apply((AssociatedStandard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedStandard> {
        /**
         * <p>
         * The unique identifier of a standard in which a control is enabled. This field consists of the resource
         * portion of the Amazon Resource Name (ARN) returned for a standard in the <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"
         * >DescribeStandards</a> API response.
         * </p>
         * 
         * @param standardsId
         *        The unique identifier of a standard in which a control is enabled. This field consists of the resource
         *        portion of the Amazon Resource Name (ARN) returned for a standard in the <a
         *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html"
         *        >DescribeStandards</a> API response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsId(String standardsId);
    }

    static final class BuilderImpl implements Builder {
        private String standardsId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedStandard model) {
            standardsId(model.standardsId);
        }

        public final String getStandardsId() {
            return standardsId;
        }

        public final void setStandardsId(String standardsId) {
            this.standardsId = standardsId;
        }

        @Override
        public final Builder standardsId(String standardsId) {
            this.standardsId = standardsId;
            return this;
        }

        @Override
        public AssociatedStandard build() {
            return new AssociatedStandard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
