/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how WAF should handle CAPTCHA evaluations for rules that don't have their own <code>CaptchaConfig</code>
 * settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2WebAclCaptchaConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2WebAclCaptchaConfigDetails.Builder, AwsWafv2WebAclCaptchaConfigDetails> {
    private static final SdkField<AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails> IMMUNITY_TIME_PROPERTY_FIELD = SdkField
            .<AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ImmunityTimeProperty").getter(getter(AwsWafv2WebAclCaptchaConfigDetails::immunityTimeProperty))
            .setter(setter(Builder::immunityTimeProperty))
            .constructor(AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImmunityTimeProperty").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMMUNITY_TIME_PROPERTY_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails immunityTimeProperty;

    private AwsWafv2WebAclCaptchaConfigDetails(BuilderImpl builder) {
        this.immunityTimeProperty = builder.immunityTimeProperty;
    }

    /**
     * <p>
     * Determines how long a CAPTCHA timestamp in the token remains valid after the client successfully solves a CAPTCHA
     * puzzle.
     * </p>
     * 
     * @return Determines how long a CAPTCHA timestamp in the token remains valid after the client successfully solves a
     *         CAPTCHA puzzle.
     */
    public final AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails immunityTimeProperty() {
        return immunityTimeProperty;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(immunityTimeProperty());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2WebAclCaptchaConfigDetails)) {
            return false;
        }
        AwsWafv2WebAclCaptchaConfigDetails other = (AwsWafv2WebAclCaptchaConfigDetails) obj;
        return Objects.equals(immunityTimeProperty(), other.immunityTimeProperty());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2WebAclCaptchaConfigDetails").add("ImmunityTimeProperty", immunityTimeProperty()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImmunityTimeProperty":
            return Optional.ofNullable(clazz.cast(immunityTimeProperty()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2WebAclCaptchaConfigDetails, T> g) {
        return obj -> g.apply((AwsWafv2WebAclCaptchaConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2WebAclCaptchaConfigDetails> {
        /**
         * <p>
         * Determines how long a CAPTCHA timestamp in the token remains valid after the client successfully solves a
         * CAPTCHA puzzle.
         * </p>
         * 
         * @param immunityTimeProperty
         *        Determines how long a CAPTCHA timestamp in the token remains valid after the client successfully
         *        solves a CAPTCHA puzzle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder immunityTimeProperty(AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails immunityTimeProperty);

        /**
         * <p>
         * Determines how long a CAPTCHA timestamp in the token remains valid after the client successfully solves a
         * CAPTCHA puzzle.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.Builder} avoiding the need to create one
         * manually via {@link AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #immunityTimeProperty(AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails)}.
         * 
         * @param immunityTimeProperty
         *        a consumer that will call methods on
         *        {@link AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #immunityTimeProperty(AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails)
         */
        default Builder immunityTimeProperty(
                Consumer<AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.Builder> immunityTimeProperty) {
            return immunityTimeProperty(AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.builder()
                    .applyMutation(immunityTimeProperty).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails immunityTimeProperty;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2WebAclCaptchaConfigDetails model) {
            immunityTimeProperty(model.immunityTimeProperty);
        }

        public final AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.Builder getImmunityTimeProperty() {
            return immunityTimeProperty != null ? immunityTimeProperty.toBuilder() : null;
        }

        public final void setImmunityTimeProperty(
                AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails.BuilderImpl immunityTimeProperty) {
            this.immunityTimeProperty = immunityTimeProperty != null ? immunityTimeProperty.build() : null;
        }

        @Override
        public final Builder immunityTimeProperty(AwsWafv2WebAclCaptchaConfigImmunityTimePropertyDetails immunityTimeProperty) {
            this.immunityTimeProperty = immunityTimeProperty;
            return this;
        }

        @Override
        public AwsWafv2WebAclCaptchaConfigDetails build() {
            return new AwsWafv2WebAclCaptchaConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
