/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an IAM user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamUserDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamUserDetails.Builder, AwsIamUserDetails> {
    private static final SdkField<List<AwsIamAttachedManagedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField
            .<List<AwsIamAttachedManagedPolicy>> builder(MarshallingType.LIST)
            .memberName("AttachedManagedPolicies")
            .getter(getter(AwsIamUserDetails::attachedManagedPolicies))
            .setter(setter(Builder::attachedManagedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsIamAttachedManagedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsIamAttachedManagedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateDate").getter(getter(AwsIamUserDetails::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<List<String>> GROUP_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupList")
            .getter(getter(AwsIamUserDetails::groupList))
            .setter(setter(Builder::groupList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(AwsIamUserDetails::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<AwsIamPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField
            .<AwsIamPermissionsBoundary> builder(MarshallingType.SDK_POJO).memberName("PermissionsBoundary")
            .getter(getter(AwsIamUserDetails::permissionsBoundary)).setter(setter(Builder::permissionsBoundary))
            .constructor(AwsIamPermissionsBoundary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build())
            .build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(AwsIamUserDetails::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(AwsIamUserDetails::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<List<AwsIamUserPolicy>> USER_POLICY_LIST_FIELD = SdkField
            .<List<AwsIamUserPolicy>> builder(MarshallingType.LIST)
            .memberName("UserPolicyList")
            .getter(getter(AwsIamUserDetails::userPolicyList))
            .setter(setter(Builder::userPolicyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPolicyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsIamUserPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsIamUserPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ATTACHED_MANAGED_POLICIES_FIELD, CREATE_DATE_FIELD, GROUP_LIST_FIELD, PATH_FIELD, PERMISSIONS_BOUNDARY_FIELD,
            USER_ID_FIELD, USER_NAME_FIELD, USER_POLICY_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsIamAttachedManagedPolicy> attachedManagedPolicies;

    private final String createDate;

    private final List<String> groupList;

    private final String path;

    private final AwsIamPermissionsBoundary permissionsBoundary;

    private final String userId;

    private final String userName;

    private final List<AwsIamUserPolicy> userPolicyList;

    private AwsIamUserDetails(BuilderImpl builder) {
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.createDate = builder.createDate;
        this.groupList = builder.groupList;
        this.path = builder.path;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.userPolicyList = builder.userPolicyList;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttachedManagedPolicies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAttachedManagedPolicies() {
        return attachedManagedPolicies != null && !(attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the managed policies that are attached to the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachedManagedPolicies} method.
     * </p>
     * 
     * @return A list of the managed policies that are attached to the user.
     */
    public final List<AwsIamAttachedManagedPolicy> attachedManagedPolicies() {
        return attachedManagedPolicies;
    }

    /**
     * <p>
     * Indicates when the user was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the user was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createDate() {
        return createDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupList() {
        return groupList != null && !(groupList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM groups that the user belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupList} method.
     * </p>
     * 
     * @return A list of IAM groups that the user belongs to.
     */
    public final List<String> groupList() {
        return groupList;
    }

    /**
     * <p>
     * The path to the user.
     * </p>
     * 
     * @return The path to the user.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The permissions boundary for the user.
     * </p>
     * 
     * @return The permissions boundary for the user.
     */
    public final AwsIamPermissionsBoundary permissionsBoundary() {
        return permissionsBoundary;
    }

    /**
     * <p>
     * The unique identifier for the user.
     * </p>
     * 
     * @return The unique identifier for the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public final String userName() {
        return userName;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserPolicyList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserPolicyList() {
        return userPolicyList != null && !(userPolicyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of inline policies that are embedded in the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserPolicyList} method.
     * </p>
     * 
     * @return The list of inline policies that are embedded in the user.
     */
    public final List<AwsIamUserPolicy> userPolicyList() {
        return userPolicyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedManagedPolicies() ? attachedManagedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupList() ? groupList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserPolicyList() ? userPolicyList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamUserDetails)) {
            return false;
        }
        AwsIamUserDetails other = (AwsIamUserDetails) obj;
        return hasAttachedManagedPolicies() == other.hasAttachedManagedPolicies()
                && Objects.equals(attachedManagedPolicies(), other.attachedManagedPolicies())
                && Objects.equals(createDate(), other.createDate()) && hasGroupList() == other.hasGroupList()
                && Objects.equals(groupList(), other.groupList()) && Objects.equals(path(), other.path())
                && Objects.equals(permissionsBoundary(), other.permissionsBoundary()) && Objects.equals(userId(), other.userId())
                && Objects.equals(userName(), other.userName()) && hasUserPolicyList() == other.hasUserPolicyList()
                && Objects.equals(userPolicyList(), other.userPolicyList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamUserDetails")
                .add("AttachedManagedPolicies", hasAttachedManagedPolicies() ? attachedManagedPolicies() : null)
                .add("CreateDate", createDate()).add("GroupList", hasGroupList() ? groupList() : null).add("Path", path())
                .add("PermissionsBoundary", permissionsBoundary()).add("UserId", userId()).add("UserName", userName())
                .add("UserPolicyList", hasUserPolicyList() ? userPolicyList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachedManagedPolicies":
            return Optional.ofNullable(clazz.cast(attachedManagedPolicies()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "GroupList":
            return Optional.ofNullable(clazz.cast(groupList()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "PermissionsBoundary":
            return Optional.ofNullable(clazz.cast(permissionsBoundary()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "UserPolicyList":
            return Optional.ofNullable(clazz.cast(userPolicyList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamUserDetails, T> g) {
        return obj -> g.apply((AwsIamUserDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamUserDetails> {
        /**
         * <p>
         * A list of the managed policies that are attached to the user.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of the managed policies that are attached to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy> attachedManagedPolicies);

        /**
         * <p>
         * A list of the managed policies that are attached to the user.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of the managed policies that are attached to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(AwsIamAttachedManagedPolicy... attachedManagedPolicies);

        /**
         * <p>
         * A list of the managed policies that are attached to the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #attachedManagedPolicies(List<AwsIamAttachedManagedPolicy>)}.
         * 
         * @param attachedManagedPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedManagedPolicies(java.util.Collection<AwsIamAttachedManagedPolicy>)
         */
        Builder attachedManagedPolicies(Consumer<AwsIamAttachedManagedPolicy.Builder>... attachedManagedPolicies);

        /**
         * <p>
         * Indicates when the user was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createDate
         *        Indicates when the user was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(String createDate);

        /**
         * <p>
         * A list of IAM groups that the user belongs to.
         * </p>
         * 
         * @param groupList
         *        A list of IAM groups that the user belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupList(Collection<String> groupList);

        /**
         * <p>
         * A list of IAM groups that the user belongs to.
         * </p>
         * 
         * @param groupList
         *        A list of IAM groups that the user belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupList(String... groupList);

        /**
         * <p>
         * The path to the user.
         * </p>
         * 
         * @param path
         *        The path to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The permissions boundary for the user.
         * </p>
         * 
         * @param permissionsBoundary
         *        The permissions boundary for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundary(AwsIamPermissionsBoundary permissionsBoundary);

        /**
         * <p>
         * The permissions boundary for the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIamPermissionsBoundary.Builder}
         * avoiding the need to create one manually via {@link AwsIamPermissionsBoundary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIamPermissionsBoundary.Builder#build()} is called immediately
         * and its result is passed to {@link #permissionsBoundary(AwsIamPermissionsBoundary)}.
         * 
         * @param permissionsBoundary
         *        a consumer that will call methods on {@link AwsIamPermissionsBoundary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionsBoundary(AwsIamPermissionsBoundary)
         */
        default Builder permissionsBoundary(Consumer<AwsIamPermissionsBoundary.Builder> permissionsBoundary) {
            return permissionsBoundary(AwsIamPermissionsBoundary.builder().applyMutation(permissionsBoundary).build());
        }

        /**
         * <p>
         * The unique identifier for the user.
         * </p>
         * 
         * @param userId
         *        The unique identifier for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param userName
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The list of inline policies that are embedded in the user.
         * </p>
         * 
         * @param userPolicyList
         *        The list of inline policies that are embedded in the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPolicyList(Collection<AwsIamUserPolicy> userPolicyList);

        /**
         * <p>
         * The list of inline policies that are embedded in the user.
         * </p>
         * 
         * @param userPolicyList
         *        The list of inline policies that are embedded in the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPolicyList(AwsIamUserPolicy... userPolicyList);

        /**
         * <p>
         * The list of inline policies that are embedded in the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #userPolicyList(List<AwsIamUserPolicy>)}.
         * 
         * @param userPolicyList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPolicyList(java.util.Collection<AwsIamUserPolicy>)
         */
        Builder userPolicyList(Consumer<AwsIamUserPolicy.Builder>... userPolicyList);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsIamAttachedManagedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private String createDate;

        private List<String> groupList = DefaultSdkAutoConstructList.getInstance();

        private String path;

        private AwsIamPermissionsBoundary permissionsBoundary;

        private String userId;

        private String userName;

        private List<AwsIamUserPolicy> userPolicyList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamUserDetails model) {
            attachedManagedPolicies(model.attachedManagedPolicies);
            createDate(model.createDate);
            groupList(model.groupList);
            path(model.path);
            permissionsBoundary(model.permissionsBoundary);
            userId(model.userId);
            userName(model.userName);
            userPolicyList(model.userPolicyList);
        }

        public final List<AwsIamAttachedManagedPolicy.Builder> getAttachedManagedPolicies() {
            List<AwsIamAttachedManagedPolicy.Builder> result = AwsIamAttachedManagedPolicyListCopier
                    .copyToBuilder(this.attachedManagedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = AwsIamAttachedManagedPolicyListCopier.copyFromBuilder(attachedManagedPolicies);
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = AwsIamAttachedManagedPolicyListCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AwsIamAttachedManagedPolicy... attachedManagedPolicies) {
            attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AwsIamAttachedManagedPolicy.Builder>... attachedManagedPolicies) {
            attachedManagedPolicies(Stream.of(attachedManagedPolicies)
                    .map(c -> AwsIamAttachedManagedPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Collection<String> getGroupList() {
            if (groupList instanceof SdkAutoConstructList) {
                return null;
            }
            return groupList;
        }

        public final void setGroupList(Collection<String> groupList) {
            this.groupList = StringListCopier.copy(groupList);
        }

        @Override
        public final Builder groupList(Collection<String> groupList) {
            this.groupList = StringListCopier.copy(groupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupList(String... groupList) {
            groupList(Arrays.asList(groupList));
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final AwsIamPermissionsBoundary.Builder getPermissionsBoundary() {
            return permissionsBoundary != null ? permissionsBoundary.toBuilder() : null;
        }

        public final void setPermissionsBoundary(AwsIamPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        @Override
        public final Builder permissionsBoundary(AwsIamPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final List<AwsIamUserPolicy.Builder> getUserPolicyList() {
            List<AwsIamUserPolicy.Builder> result = AwsIamUserPolicyListCopier.copyToBuilder(this.userPolicyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserPolicyList(Collection<AwsIamUserPolicy.BuilderImpl> userPolicyList) {
            this.userPolicyList = AwsIamUserPolicyListCopier.copyFromBuilder(userPolicyList);
        }

        @Override
        public final Builder userPolicyList(Collection<AwsIamUserPolicy> userPolicyList) {
            this.userPolicyList = AwsIamUserPolicyListCopier.copy(userPolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPolicyList(AwsIamUserPolicy... userPolicyList) {
            userPolicyList(Arrays.asList(userPolicyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPolicyList(Consumer<AwsIamUserPolicy.Builder>... userPolicyList) {
            userPolicyList(Stream.of(userPolicyList).map(c -> AwsIamUserPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsIamUserDetails build() {
            return new AwsIamUserDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
