/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration option setting for the environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElasticBeanstalkEnvironmentOptionSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElasticBeanstalkEnvironmentOptionSetting.Builder, AwsElasticBeanstalkEnvironmentOptionSetting> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(AwsElasticBeanstalkEnvironmentOptionSetting::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> OPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionName").getter(getter(AwsElasticBeanstalkEnvironmentOptionSetting::optionName))
            .setter(setter(Builder::optionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(AwsElasticBeanstalkEnvironmentOptionSetting::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(AwsElasticBeanstalkEnvironmentOptionSetting::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD,
            OPTION_NAME_FIELD, RESOURCE_NAME_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final String optionName;

    private final String resourceName;

    private final String value;

    private AwsElasticBeanstalkEnvironmentOptionSetting(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.optionName = builder.optionName;
        this.resourceName = builder.resourceName;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of resource that the configuration option is associated with.
     * </p>
     * 
     * @return The type of resource that the configuration option is associated with.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the option.
     * </p>
     * 
     * @return The name of the option.
     */
    public final String optionName() {
        return optionName;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The value of the configuration setting.
     * </p>
     * 
     * @return The value of the configuration setting.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(optionName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticBeanstalkEnvironmentOptionSetting)) {
            return false;
        }
        AwsElasticBeanstalkEnvironmentOptionSetting other = (AwsElasticBeanstalkEnvironmentOptionSetting) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(optionName(), other.optionName())
                && Objects.equals(resourceName(), other.resourceName()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElasticBeanstalkEnvironmentOptionSetting").add("Namespace", namespace())
                .add("OptionName", optionName()).add("ResourceName", resourceName()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "OptionName":
            return Optional.ofNullable(clazz.cast(optionName()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticBeanstalkEnvironmentOptionSetting, T> g) {
        return obj -> g.apply((AwsElasticBeanstalkEnvironmentOptionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElasticBeanstalkEnvironmentOptionSetting> {
        /**
         * <p>
         * The type of resource that the configuration option is associated with.
         * </p>
         * 
         * @param namespace
         *        The type of resource that the configuration option is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the option.
         * </p>
         * 
         * @param optionName
         *        The name of the option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionName(String optionName);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The value of the configuration setting.
         * </p>
         * 
         * @param value
         *        The value of the configuration setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private String optionName;

        private String resourceName;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticBeanstalkEnvironmentOptionSetting model) {
            namespace(model.namespace);
            optionName(model.optionName);
            resourceName(model.resourceName);
            value(model.value);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getOptionName() {
            return optionName;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public AwsElasticBeanstalkEnvironmentOptionSetting build() {
            return new AwsElasticBeanstalkEnvironmentOptionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
