/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an alarm and associates it with the specified metric or metric math expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudWatchAlarmDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudWatchAlarmDetails.Builder, AwsCloudWatchAlarmDetails> {
    private static final SdkField<Boolean> ACTIONS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ActionsEnabled").getter(getter(AwsCloudWatchAlarmDetails::actionsEnabled))
            .setter(setter(Builder::actionsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionsEnabled").build()).build();

    private static final SdkField<List<String>> ALARM_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlarmActions")
            .getter(getter(AwsCloudWatchAlarmDetails::alarmActions))
            .setter(setter(Builder::alarmActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALARM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmArn").getter(getter(AwsCloudWatchAlarmDetails::alarmArn)).setter(setter(Builder::alarmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmArn").build()).build();

    private static final SdkField<String> ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AlarmConfigurationUpdatedTimestamp")
            .getter(getter(AwsCloudWatchAlarmDetails::alarmConfigurationUpdatedTimestamp))
            .setter(setter(Builder::alarmConfigurationUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfigurationUpdatedTimestamp")
                    .build()).build();

    private static final SdkField<String> ALARM_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmDescription").getter(getter(AwsCloudWatchAlarmDetails::alarmDescription))
            .setter(setter(Builder::alarmDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmDescription").build()).build();

    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlarmName").getter(getter(AwsCloudWatchAlarmDetails::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()).build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonOperator").getter(getter(AwsCloudWatchAlarmDetails::comparisonOperator))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DatapointsToAlarm").getter(getter(AwsCloudWatchAlarmDetails::datapointsToAlarm))
            .setter(setter(Builder::datapointsToAlarm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatapointsToAlarm").build()).build();

    private static final SdkField<List<AwsCloudWatchAlarmDimensionsDetails>> DIMENSIONS_FIELD = SdkField
            .<List<AwsCloudWatchAlarmDimensionsDetails>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(AwsCloudWatchAlarmDetails::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCloudWatchAlarmDimensionsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsCloudWatchAlarmDimensionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVALUATE_LOW_SAMPLE_COUNT_PERCENTILE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EvaluateLowSampleCountPercentile")
            .getter(getter(AwsCloudWatchAlarmDetails::evaluateLowSampleCountPercentile))
            .setter(setter(Builder::evaluateLowSampleCountPercentile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluateLowSampleCountPercentile")
                    .build()).build();

    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationPeriods").getter(getter(AwsCloudWatchAlarmDetails::evaluationPeriods))
            .setter(setter(Builder::evaluationPeriods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriods").build()).build();

    private static final SdkField<String> EXTENDED_STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtendedStatistic").getter(getter(AwsCloudWatchAlarmDetails::extendedStatistic))
            .setter(setter(Builder::extendedStatistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedStatistic").build()).build();

    private static final SdkField<List<String>> INSUFFICIENT_DATA_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsufficientDataActions")
            .getter(getter(AwsCloudWatchAlarmDetails::insufficientDataActions))
            .setter(setter(Builder::insufficientDataActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(AwsCloudWatchAlarmDetails::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(AwsCloudWatchAlarmDetails::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<List<String>> OK_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OkActions")
            .getter(getter(AwsCloudWatchAlarmDetails::okActions))
            .setter(setter(Builder::okActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OkActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(AwsCloudWatchAlarmDetails::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statistic").getter(getter(AwsCloudWatchAlarmDetails::statistic)).setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()).build();

    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Threshold").getter(getter(AwsCloudWatchAlarmDetails::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final SdkField<String> THRESHOLD_METRIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThresholdMetricId").getter(getter(AwsCloudWatchAlarmDetails::thresholdMetricId))
            .setter(setter(Builder::thresholdMetricId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdMetricId").build()).build();

    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatMissingData").getter(getter(AwsCloudWatchAlarmDetails::treatMissingData))
            .setter(setter(Builder::treatMissingData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatMissingData").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(AwsCloudWatchAlarmDetails::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_ENABLED_FIELD,
            ALARM_ACTIONS_FIELD, ALARM_ARN_FIELD, ALARM_CONFIGURATION_UPDATED_TIMESTAMP_FIELD, ALARM_DESCRIPTION_FIELD,
            ALARM_NAME_FIELD, COMPARISON_OPERATOR_FIELD, DATAPOINTS_TO_ALARM_FIELD, DIMENSIONS_FIELD,
            EVALUATE_LOW_SAMPLE_COUNT_PERCENTILE_FIELD, EVALUATION_PERIODS_FIELD, EXTENDED_STATISTIC_FIELD,
            INSUFFICIENT_DATA_ACTIONS_FIELD, METRIC_NAME_FIELD, NAMESPACE_FIELD, OK_ACTIONS_FIELD, PERIOD_FIELD, STATISTIC_FIELD,
            THRESHOLD_FIELD, THRESHOLD_METRIC_ID_FIELD, TREAT_MISSING_DATA_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean actionsEnabled;

    private final List<String> alarmActions;

    private final String alarmArn;

    private final String alarmConfigurationUpdatedTimestamp;

    private final String alarmDescription;

    private final String alarmName;

    private final String comparisonOperator;

    private final Integer datapointsToAlarm;

    private final List<AwsCloudWatchAlarmDimensionsDetails> dimensions;

    private final String evaluateLowSampleCountPercentile;

    private final Integer evaluationPeriods;

    private final String extendedStatistic;

    private final List<String> insufficientDataActions;

    private final String metricName;

    private final String namespace;

    private final List<String> okActions;

    private final Integer period;

    private final String statistic;

    private final Double threshold;

    private final String thresholdMetricId;

    private final String treatMissingData;

    private final String unit;

    private AwsCloudWatchAlarmDetails(BuilderImpl builder) {
        this.actionsEnabled = builder.actionsEnabled;
        this.alarmActions = builder.alarmActions;
        this.alarmArn = builder.alarmArn;
        this.alarmConfigurationUpdatedTimestamp = builder.alarmConfigurationUpdatedTimestamp;
        this.alarmDescription = builder.alarmDescription;
        this.alarmName = builder.alarmName;
        this.comparisonOperator = builder.comparisonOperator;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.dimensions = builder.dimensions;
        this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.extendedStatistic = builder.extendedStatistic;
        this.insufficientDataActions = builder.insufficientDataActions;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.okActions = builder.okActions;
        this.period = builder.period;
        this.statistic = builder.statistic;
        this.threshold = builder.threshold;
        this.thresholdMetricId = builder.thresholdMetricId;
        this.treatMissingData = builder.treatMissingData;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * Indicates whether actions should be executed during any changes to the alarm state.
     * </p>
     * 
     * @return Indicates whether actions should be executed during any changes to the alarm state.
     */
    public final Boolean actionsEnabled() {
        return actionsEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlarmActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlarmActions() {
        return alarmActions != null && !(alarmActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of actions, specified as Amazon Resource Names (ARNs) to execute when this alarm transitions into an
     * <code>ALARM</code> state from any other state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarmActions} method.
     * </p>
     * 
     * @return The list of actions, specified as Amazon Resource Names (ARNs) to execute when this alarm transitions
     *         into an <code>ALARM</code> state from any other state.
     */
    public final List<String> alarmActions() {
        return alarmActions;
    }

    /**
     * <p>
     * The ARN of the alarm.
     * </p>
     * 
     * @return The ARN of the alarm.
     */
    public final String alarmArn() {
        return alarmArn;
    }

    /**
     * <p>
     * The time stamp of the last update to the alarm configuration.
     * </p>
     * 
     * @return The time stamp of the last update to the alarm configuration.
     */
    public final String alarmConfigurationUpdatedTimestamp() {
        return alarmConfigurationUpdatedTimestamp;
    }

    /**
     * <p>
     * The description of the alarm.
     * </p>
     * 
     * @return The description of the alarm.
     */
    public final String alarmDescription() {
        return alarmDescription;
    }

    /**
     * <p>
     * The name of the alarm. If you don't specify a name, CloudFront generates a unique physical ID and uses that ID
     * for the alarm name.
     * </p>
     * 
     * @return The name of the alarm. If you don't specify a name, CloudFront generates a unique physical ID and uses
     *         that ID for the alarm name.
     */
    public final String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
     * value is used as the first operand.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified statistic and threshold. The specified
     *         statistic value is used as the first operand.
     */
    public final String comparisonOperator() {
        return comparisonOperator;
    }

    /**
     * <p>
     * The number of datapoints that must be breaching to trigger the alarm.
     * </p>
     * 
     * @return The number of datapoints that must be breaching to trigger the alarm.
     */
    public final Integer datapointsToAlarm() {
        return datapointsToAlarm;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimensions for the metric associated with the alarm.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return The dimensions for the metric associated with the alarm.
     */
    public final List<AwsCloudWatchAlarmDimensionsDetails> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change during periods
     * with too few data points to be statistically significant. If <code>evaluate</code> or this parameter is not used,
     * the alarm is always evaluated and possibly changes state no matter how many data points are available.
     * </p>
     * 
     * @return Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change during
     *         periods with too few data points to be statistically significant. If <code>evaluate</code> or this
     *         parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data
     *         points are available.
     */
    public final String evaluateLowSampleCountPercentile() {
        return evaluateLowSampleCountPercentile;
    }

    /**
     * <p>
     * The number of periods over which data is compared to the specified threshold.
     * </p>
     * 
     * @return The number of periods over which data is compared to the specified threshold.
     */
    public final Integer evaluationPeriods() {
        return evaluationPeriods;
    }

    /**
     * <p>
     * The percentile statistic for the metric associated with the alarm.
     * </p>
     * 
     * @return The percentile statistic for the metric associated with the alarm.
     */
    public final String extendedStatistic() {
        return extendedStatistic;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsufficientDataActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInsufficientDataActions() {
        return insufficientDataActions != null && !(insufficientDataActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
     * state. Each action is specified as an ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsufficientDataActions} method.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any
     *         other state. Each action is specified as an ARN.
     */
    public final List<String> insufficientDataActions() {
        return insufficientDataActions;
    }

    /**
     * <p>
     * The name of the metric associated with the alarm. This is required for an alarm based on a metric. For an alarm
     * based on a math expression, you use <code>Metrics</code> instead and you can't specify <code>MetricName</code>.
     * </p>
     * 
     * @return The name of the metric associated with the alarm. This is required for an alarm based on a metric. For an
     *         alarm based on a math expression, you use <code>Metrics</code> instead and you can't specify
     *         <code>MetricName</code>.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace of the metric associated with the alarm. This is required for an alarm based on a metric. For an
     * alarm based on a math expression, you can't specify <code>Namespace</code> and you use <code>Metrics</code>
     * instead.
     * </p>
     * 
     * @return The namespace of the metric associated with the alarm. This is required for an alarm based on a metric.
     *         For an alarm based on a math expression, you can't specify <code>Namespace</code> and you use
     *         <code>Metrics</code> instead.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the OkActions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOkActions() {
        return okActions != null && !(okActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to execute when this alarm transitions to the <code>OK</code> state from any other state. Each action
     * is specified as an ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOkActions} method.
     * </p>
     * 
     * @return The actions to execute when this alarm transitions to the <code>OK</code> state from any other state.
     *         Each action is specified as an ARN.
     */
    public final List<String> okActions() {
        return okActions;
    }

    /**
     * <p>
     * The period, in seconds, over which the statistic is applied. This is required for an alarm based on a metric.
     * </p>
     * 
     * @return The period, in seconds, over which the statistic is applied. This is required for an alarm based on a
     *         metric.
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
     * <code>ExtendedStatistic</code>.
     * </p>
     * <p>
     * For an alarm based on a metric, you must specify either <code>Statistic</code> or <code>ExtendedStatistic</code>
     * but not both.
     * </p>
     * <p>
     * For an alarm based on a math expression, you can't specify <code>Statistic</code>. Instead, you use
     * <code>Metrics</code>.
     * </p>
     * 
     * @return The statistic for the metric associated with the alarm, other than percentile. For percentile statistics,
     *         use <code>ExtendedStatistic</code>.</p>
     *         <p>
     *         For an alarm based on a metric, you must specify either <code>Statistic</code> or
     *         <code>ExtendedStatistic</code> but not both.
     *         </p>
     *         <p>
     *         For an alarm based on a math expression, you can't specify <code>Statistic</code>. Instead, you use
     *         <code>Metrics</code>.
     */
    public final String statistic() {
        return statistic;
    }

    /**
     * <p>
     * The value to compare with the specified statistic.
     * </p>
     * 
     * @return The value to compare with the specified statistic.
     */
    public final Double threshold() {
        return threshold;
    }

    /**
     * <p>
     * n an alarm based on an anomaly detection model, this is the ID of the <code>ANOMALY_DETECTION_BAND</code>
     * function used as the threshold for the alarm.
     * </p>
     * 
     * @return n an alarm based on an anomaly detection model, this is the ID of the <code>ANOMALY_DETECTION_BAND</code>
     *         function used as the threshold for the alarm.
     */
    public final String thresholdMetricId() {
        return thresholdMetricId;
    }

    /**
     * <p>
     * Sets how this alarm is to handle missing data points.
     * </p>
     * 
     * @return Sets how this alarm is to handle missing data points.
     */
    public final String treatMissingData() {
        return treatMissingData;
    }

    /**
     * <p>
     * The unit of the metric associated with the alarm.
     * </p>
     * 
     * @return The unit of the metric associated with the alarm.
     */
    public final String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmActions() ? alarmActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(alarmArn());
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfigurationUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(alarmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperator());
        hashCode = 31 * hashCode + Objects.hashCode(datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluateLowSampleCountPercentile());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(extendedStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsufficientDataActions() ? insufficientDataActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(hasOkActions() ? okActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(statistic());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdMetricId());
        hashCode = 31 * hashCode + Objects.hashCode(treatMissingData());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudWatchAlarmDetails)) {
            return false;
        }
        AwsCloudWatchAlarmDetails other = (AwsCloudWatchAlarmDetails) obj;
        return Objects.equals(actionsEnabled(), other.actionsEnabled()) && hasAlarmActions() == other.hasAlarmActions()
                && Objects.equals(alarmActions(), other.alarmActions()) && Objects.equals(alarmArn(), other.alarmArn())
                && Objects.equals(alarmConfigurationUpdatedTimestamp(), other.alarmConfigurationUpdatedTimestamp())
                && Objects.equals(alarmDescription(), other.alarmDescription()) && Objects.equals(alarmName(), other.alarmName())
                && Objects.equals(comparisonOperator(), other.comparisonOperator())
                && Objects.equals(datapointsToAlarm(), other.datapointsToAlarm()) && hasDimensions() == other.hasDimensions()
                && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(evaluateLowSampleCountPercentile(), other.evaluateLowSampleCountPercentile())
                && Objects.equals(evaluationPeriods(), other.evaluationPeriods())
                && Objects.equals(extendedStatistic(), other.extendedStatistic())
                && hasInsufficientDataActions() == other.hasInsufficientDataActions()
                && Objects.equals(insufficientDataActions(), other.insufficientDataActions())
                && Objects.equals(metricName(), other.metricName()) && Objects.equals(namespace(), other.namespace())
                && hasOkActions() == other.hasOkActions() && Objects.equals(okActions(), other.okActions())
                && Objects.equals(period(), other.period()) && Objects.equals(statistic(), other.statistic())
                && Objects.equals(threshold(), other.threshold())
                && Objects.equals(thresholdMetricId(), other.thresholdMetricId())
                && Objects.equals(treatMissingData(), other.treatMissingData()) && Objects.equals(unit(), other.unit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudWatchAlarmDetails").add("ActionsEnabled", actionsEnabled())
                .add("AlarmActions", hasAlarmActions() ? alarmActions() : null).add("AlarmArn", alarmArn())
                .add("AlarmConfigurationUpdatedTimestamp", alarmConfigurationUpdatedTimestamp())
                .add("AlarmDescription", alarmDescription()).add("AlarmName", alarmName())
                .add("ComparisonOperator", comparisonOperator()).add("DatapointsToAlarm", datapointsToAlarm())
                .add("Dimensions", hasDimensions() ? dimensions() : null)
                .add("EvaluateLowSampleCountPercentile", evaluateLowSampleCountPercentile())
                .add("EvaluationPeriods", evaluationPeriods()).add("ExtendedStatistic", extendedStatistic())
                .add("InsufficientDataActions", hasInsufficientDataActions() ? insufficientDataActions() : null)
                .add("MetricName", metricName()).add("Namespace", namespace())
                .add("OkActions", hasOkActions() ? okActions() : null).add("Period", period()).add("Statistic", statistic())
                .add("Threshold", threshold()).add("ThresholdMetricId", thresholdMetricId())
                .add("TreatMissingData", treatMissingData()).add("Unit", unit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionsEnabled":
            return Optional.ofNullable(clazz.cast(actionsEnabled()));
        case "AlarmActions":
            return Optional.ofNullable(clazz.cast(alarmActions()));
        case "AlarmArn":
            return Optional.ofNullable(clazz.cast(alarmArn()));
        case "AlarmConfigurationUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(alarmConfigurationUpdatedTimestamp()));
        case "AlarmDescription":
            return Optional.ofNullable(clazz.cast(alarmDescription()));
        case "AlarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperator()));
        case "DatapointsToAlarm":
            return Optional.ofNullable(clazz.cast(datapointsToAlarm()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "EvaluateLowSampleCountPercentile":
            return Optional.ofNullable(clazz.cast(evaluateLowSampleCountPercentile()));
        case "EvaluationPeriods":
            return Optional.ofNullable(clazz.cast(evaluationPeriods()));
        case "ExtendedStatistic":
            return Optional.ofNullable(clazz.cast(extendedStatistic()));
        case "InsufficientDataActions":
            return Optional.ofNullable(clazz.cast(insufficientDataActions()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "OkActions":
            return Optional.ofNullable(clazz.cast(okActions()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statistic()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "ThresholdMetricId":
            return Optional.ofNullable(clazz.cast(thresholdMetricId()));
        case "TreatMissingData":
            return Optional.ofNullable(clazz.cast(treatMissingData()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudWatchAlarmDetails, T> g) {
        return obj -> g.apply((AwsCloudWatchAlarmDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudWatchAlarmDetails> {
        /**
         * <p>
         * Indicates whether actions should be executed during any changes to the alarm state.
         * </p>
         * 
         * @param actionsEnabled
         *        Indicates whether actions should be executed during any changes to the alarm state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionsEnabled(Boolean actionsEnabled);

        /**
         * <p>
         * The list of actions, specified as Amazon Resource Names (ARNs) to execute when this alarm transitions into an
         * <code>ALARM</code> state from any other state.
         * </p>
         * 
         * @param alarmActions
         *        The list of actions, specified as Amazon Resource Names (ARNs) to execute when this alarm transitions
         *        into an <code>ALARM</code> state from any other state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(Collection<String> alarmActions);

        /**
         * <p>
         * The list of actions, specified as Amazon Resource Names (ARNs) to execute when this alarm transitions into an
         * <code>ALARM</code> state from any other state.
         * </p>
         * 
         * @param alarmActions
         *        The list of actions, specified as Amazon Resource Names (ARNs) to execute when this alarm transitions
         *        into an <code>ALARM</code> state from any other state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmActions(String... alarmActions);

        /**
         * <p>
         * The ARN of the alarm.
         * </p>
         * 
         * @param alarmArn
         *        The ARN of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmArn(String alarmArn);

        /**
         * <p>
         * The time stamp of the last update to the alarm configuration.
         * </p>
         * 
         * @param alarmConfigurationUpdatedTimestamp
         *        The time stamp of the last update to the alarm configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfigurationUpdatedTimestamp(String alarmConfigurationUpdatedTimestamp);

        /**
         * <p>
         * The description of the alarm.
         * </p>
         * 
         * @param alarmDescription
         *        The description of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmDescription(String alarmDescription);

        /**
         * <p>
         * The name of the alarm. If you don't specify a name, CloudFront generates a unique physical ID and uses that
         * ID for the alarm name.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm. If you don't specify a name, CloudFront generates a unique physical ID and uses
         *        that ID for the alarm name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic
         * value is used as the first operand.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified statistic and threshold. The specified
         *        statistic value is used as the first operand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The number of datapoints that must be breaching to trigger the alarm.
         * </p>
         * 
         * @param datapointsToAlarm
         *        The number of datapoints that must be breaching to trigger the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapointsToAlarm(Integer datapointsToAlarm);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<AwsCloudWatchAlarmDimensionsDetails> dimensions);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * 
         * @param dimensions
         *        The dimensions for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(AwsCloudWatchAlarmDimensionsDetails... dimensions);

        /**
         * <p>
         * The dimensions for the metric associated with the alarm.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dimensions(List<AwsCloudWatchAlarmDimensionsDetails>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsCloudWatchAlarmDimensionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(java.util.Collection<AwsCloudWatchAlarmDimensionsDetails>)
         */
        Builder dimensions(Consumer<AwsCloudWatchAlarmDimensionsDetails.Builder>... dimensions);

        /**
         * <p>
         * Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change during
         * periods with too few data points to be statistically significant. If <code>evaluate</code> or this parameter
         * is not used, the alarm is always evaluated and possibly changes state no matter how many data points are
         * available.
         * </p>
         * 
         * @param evaluateLowSampleCountPercentile
         *        Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change
         *        during periods with too few data points to be statistically significant. If <code>evaluate</code> or
         *        this parameter is not used, the alarm is always evaluated and possibly changes state no matter how
         *        many data points are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile);

        /**
         * <p>
         * The number of periods over which data is compared to the specified threshold.
         * </p>
         * 
         * @param evaluationPeriods
         *        The number of periods over which data is compared to the specified threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriods(Integer evaluationPeriods);

        /**
         * <p>
         * The percentile statistic for the metric associated with the alarm.
         * </p>
         * 
         * @param extendedStatistic
         *        The percentile statistic for the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendedStatistic(String extendedStatistic);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an ARN.
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(Collection<String> insufficientDataActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other
         * state. Each action is specified as an ARN.
         * </p>
         * 
         * @param insufficientDataActions
         *        The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from
         *        any other state. Each action is specified as an ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientDataActions(String... insufficientDataActions);

        /**
         * <p>
         * The name of the metric associated with the alarm. This is required for an alarm based on a metric. For an
         * alarm based on a math expression, you use <code>Metrics</code> instead and you can't specify
         * <code>MetricName</code>.
         * </p>
         * 
         * @param metricName
         *        The name of the metric associated with the alarm. This is required for an alarm based on a metric. For
         *        an alarm based on a math expression, you use <code>Metrics</code> instead and you can't specify
         *        <code>MetricName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace of the metric associated with the alarm. This is required for an alarm based on a metric. For
         * an alarm based on a math expression, you can't specify <code>Namespace</code> and you use
         * <code>Metrics</code> instead.
         * </p>
         * 
         * @param namespace
         *        The namespace of the metric associated with the alarm. This is required for an alarm based on a
         *        metric. For an alarm based on a math expression, you can't specify <code>Namespace</code> and you use
         *        <code>Metrics</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>OK</code> state from any other state. Each
         * action is specified as an ARN.
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to the <code>OK</code> state from any other state.
         *        Each action is specified as an ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(Collection<String> okActions);

        /**
         * <p>
         * The actions to execute when this alarm transitions to the <code>OK</code> state from any other state. Each
         * action is specified as an ARN.
         * </p>
         * 
         * @param okActions
         *        The actions to execute when this alarm transitions to the <code>OK</code> state from any other state.
         *        Each action is specified as an ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okActions(String... okActions);

        /**
         * <p>
         * The period, in seconds, over which the statistic is applied. This is required for an alarm based on a metric.
         * </p>
         * 
         * @param period
         *        The period, in seconds, over which the statistic is applied. This is required for an alarm based on a
         *        metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use
         * <code>ExtendedStatistic</code>.
         * </p>
         * <p>
         * For an alarm based on a metric, you must specify either <code>Statistic</code> or
         * <code>ExtendedStatistic</code> but not both.
         * </p>
         * <p>
         * For an alarm based on a math expression, you can't specify <code>Statistic</code>. Instead, you use
         * <code>Metrics</code>.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric associated with the alarm, other than percentile. For percentile
         *        statistics, use <code>ExtendedStatistic</code>.</p>
         *        <p>
         *        For an alarm based on a metric, you must specify either <code>Statistic</code> or
         *        <code>ExtendedStatistic</code> but not both.
         *        </p>
         *        <p>
         *        For an alarm based on a math expression, you can't specify <code>Statistic</code>. Instead, you use
         *        <code>Metrics</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The value to compare with the specified statistic.
         * </p>
         * 
         * @param threshold
         *        The value to compare with the specified statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * <p>
         * n an alarm based on an anomaly detection model, this is the ID of the <code>ANOMALY_DETECTION_BAND</code>
         * function used as the threshold for the alarm.
         * </p>
         * 
         * @param thresholdMetricId
         *        n an alarm based on an anomaly detection model, this is the ID of the
         *        <code>ANOMALY_DETECTION_BAND</code> function used as the threshold for the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdMetricId(String thresholdMetricId);

        /**
         * <p>
         * Sets how this alarm is to handle missing data points.
         * </p>
         * 
         * @param treatMissingData
         *        Sets how this alarm is to handle missing data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatMissingData(String treatMissingData);

        /**
         * <p>
         * The unit of the metric associated with the alarm.
         * </p>
         * 
         * @param unit
         *        The unit of the metric associated with the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);
    }

    static final class BuilderImpl implements Builder {
        private Boolean actionsEnabled;

        private List<String> alarmActions = DefaultSdkAutoConstructList.getInstance();

        private String alarmArn;

        private String alarmConfigurationUpdatedTimestamp;

        private String alarmDescription;

        private String alarmName;

        private String comparisonOperator;

        private Integer datapointsToAlarm;

        private List<AwsCloudWatchAlarmDimensionsDetails> dimensions = DefaultSdkAutoConstructList.getInstance();

        private String evaluateLowSampleCountPercentile;

        private Integer evaluationPeriods;

        private String extendedStatistic;

        private List<String> insufficientDataActions = DefaultSdkAutoConstructList.getInstance();

        private String metricName;

        private String namespace;

        private List<String> okActions = DefaultSdkAutoConstructList.getInstance();

        private Integer period;

        private String statistic;

        private Double threshold;

        private String thresholdMetricId;

        private String treatMissingData;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudWatchAlarmDetails model) {
            actionsEnabled(model.actionsEnabled);
            alarmActions(model.alarmActions);
            alarmArn(model.alarmArn);
            alarmConfigurationUpdatedTimestamp(model.alarmConfigurationUpdatedTimestamp);
            alarmDescription(model.alarmDescription);
            alarmName(model.alarmName);
            comparisonOperator(model.comparisonOperator);
            datapointsToAlarm(model.datapointsToAlarm);
            dimensions(model.dimensions);
            evaluateLowSampleCountPercentile(model.evaluateLowSampleCountPercentile);
            evaluationPeriods(model.evaluationPeriods);
            extendedStatistic(model.extendedStatistic);
            insufficientDataActions(model.insufficientDataActions);
            metricName(model.metricName);
            namespace(model.namespace);
            okActions(model.okActions);
            period(model.period);
            statistic(model.statistic);
            threshold(model.threshold);
            thresholdMetricId(model.thresholdMetricId);
            treatMissingData(model.treatMissingData);
            unit(model.unit);
        }

        public final Boolean getActionsEnabled() {
            return actionsEnabled;
        }

        public final void setActionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
        }

        @Override
        public final Builder actionsEnabled(Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        public final Collection<String> getAlarmActions() {
            if (alarmActions instanceof SdkAutoConstructList) {
                return null;
            }
            return alarmActions;
        }

        public final void setAlarmActions(Collection<String> alarmActions) {
            this.alarmActions = NonEmptyStringListCopier.copy(alarmActions);
        }

        @Override
        public final Builder alarmActions(Collection<String> alarmActions) {
            this.alarmActions = NonEmptyStringListCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(String... alarmActions) {
            alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        public final String getAlarmArn() {
            return alarmArn;
        }

        public final void setAlarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
        }

        @Override
        public final Builder alarmArn(String alarmArn) {
            this.alarmArn = alarmArn;
            return this;
        }

        public final String getAlarmConfigurationUpdatedTimestamp() {
            return alarmConfigurationUpdatedTimestamp;
        }

        public final void setAlarmConfigurationUpdatedTimestamp(String alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
        }

        @Override
        public final Builder alarmConfigurationUpdatedTimestamp(String alarmConfigurationUpdatedTimestamp) {
            this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
            return this;
        }

        public final String getAlarmDescription() {
            return alarmDescription;
        }

        public final void setAlarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
        }

        @Override
        public final Builder alarmDescription(String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        public final String getAlarmName() {
            return alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        public final Integer getDatapointsToAlarm() {
            return datapointsToAlarm;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final List<AwsCloudWatchAlarmDimensionsDetails.Builder> getDimensions() {
            List<AwsCloudWatchAlarmDimensionsDetails.Builder> result = AwsCloudWatchAlarmDimensionsListCopier
                    .copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<AwsCloudWatchAlarmDimensionsDetails.BuilderImpl> dimensions) {
            this.dimensions = AwsCloudWatchAlarmDimensionsListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<AwsCloudWatchAlarmDimensionsDetails> dimensions) {
            this.dimensions = AwsCloudWatchAlarmDimensionsListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(AwsCloudWatchAlarmDimensionsDetails... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<AwsCloudWatchAlarmDimensionsDetails.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> AwsCloudWatchAlarmDimensionsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEvaluateLowSampleCountPercentile() {
            return evaluateLowSampleCountPercentile;
        }

        public final void setEvaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
        }

        @Override
        public final Builder evaluateLowSampleCountPercentile(String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final String getExtendedStatistic() {
            return extendedStatistic;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final Collection<String> getInsufficientDataActions() {
            if (insufficientDataActions instanceof SdkAutoConstructList) {
                return null;
            }
            return insufficientDataActions;
        }

        public final void setInsufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = NonEmptyStringListCopier.copy(insufficientDataActions);
        }

        @Override
        public final Builder insufficientDataActions(Collection<String> insufficientDataActions) {
            this.insufficientDataActions = NonEmptyStringListCopier.copy(insufficientDataActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insufficientDataActions(String... insufficientDataActions) {
            insufficientDataActions(Arrays.asList(insufficientDataActions));
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final Collection<String> getOkActions() {
            if (okActions instanceof SdkAutoConstructList) {
                return null;
            }
            return okActions;
        }

        public final void setOkActions(Collection<String> okActions) {
            this.okActions = NonEmptyStringListCopier.copy(okActions);
        }

        @Override
        public final Builder okActions(Collection<String> okActions) {
            this.okActions = NonEmptyStringListCopier.copy(okActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder okActions(String... okActions) {
            okActions(Arrays.asList(okActions));
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        public final Double getThreshold() {
            return threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getThresholdMetricId() {
            return thresholdMetricId;
        }

        public final void setThresholdMetricId(String thresholdMetricId) {
            this.thresholdMetricId = thresholdMetricId;
        }

        @Override
        public final Builder thresholdMetricId(String thresholdMetricId) {
            this.thresholdMetricId = thresholdMetricId;
            return this;
        }

        public final String getTreatMissingData() {
            return treatMissingData;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public AwsCloudWatchAlarmDetails build() {
            return new AwsCloudWatchAlarmDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
