/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the SSL/TLS protocols that CloudFront can use when establishing an
 * HTTPS connection with your origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionOriginSslProtocols implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionOriginSslProtocols.Builder, AwsCloudFrontDistributionOriginSslProtocols> {
    private static final SdkField<List<String>> ITEMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(AwsCloudFrontDistributionOriginSslProtocols::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity").getter(getter(AwsCloudFrontDistributionOriginSslProtocols::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, QUANTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> items;

    private final Integer quantity;

    private AwsCloudFrontDistributionOriginSslProtocols(BuilderImpl builder) {
        this.items = builder.items;
        this.quantity = builder.quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains allowed SSL/TLS protocols for this distribution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return A list that contains allowed SSL/TLS protocols for this distribution.
     */
    public final List<String> items() {
        return items;
    }

    /**
     * <p>
     * The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an HTTPS connection
     * with this origin.
     * </p>
     * 
     * @return The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an HTTPS
     *         connection with this origin.
     */
    public final Integer quantity() {
        return quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginSslProtocols)) {
            return false;
        }
        AwsCloudFrontDistributionOriginSslProtocols other = (AwsCloudFrontDistributionOriginSslProtocols) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(quantity(), other.quantity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionOriginSslProtocols").add("Items", hasItems() ? items() : null)
                .add("Quantity", quantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginSslProtocols, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginSslProtocols) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionOriginSslProtocols> {
        /**
         * <p>
         * A list that contains allowed SSL/TLS protocols for this distribution.
         * </p>
         * 
         * @param items
         *        A list that contains allowed SSL/TLS protocols for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<String> items);

        /**
         * <p>
         * A list that contains allowed SSL/TLS protocols for this distribution.
         * </p>
         * 
         * @param items
         *        A list that contains allowed SSL/TLS protocols for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(String... items);

        /**
         * <p>
         * The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an HTTPS
         * connection with this origin.
         * </p>
         * 
         * @param quantity
         *        The number of SSL/TLS protocols that you want to allow CloudFront to use when establishing an HTTPS
         *        connection with this origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);
    }

    static final class BuilderImpl implements Builder {
        private List<String> items = DefaultSdkAutoConstructList.getInstance();

        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginSslProtocols model) {
            items(model.items);
            quantity(model.quantity);
        }

        public final Collection<String> getItems() {
            if (items instanceof SdkAutoConstructList) {
                return null;
            }
            return items;
        }

        public final void setItems(Collection<String> items) {
            this.items = NonEmptyStringListCopier.copy(items);
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = NonEmptyStringListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionOriginSslProtocols build() {
            return new AwsCloudFrontDistributionOriginSslProtocols(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
