/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecretResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<DescribeSecretResponse.Builder, DescribeSecretResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(DescribeSecretResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeSecretResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeSecretResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DescribeSecretResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ROTATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RotationEnabled").getter(getter(DescribeSecretResponse::rotationEnabled))
            .setter(setter(Builder::rotationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationEnabled").build()).build();

    private static final SdkField<String> ROTATION_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationLambdaARN").getter(getter(DescribeSecretResponse::rotationLambdaARN))
            .setter(setter(Builder::rotationLambdaARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationLambdaARN").build()).build();

    private static final SdkField<RotationRulesType> ROTATION_RULES_FIELD = SdkField
            .<RotationRulesType> builder(MarshallingType.SDK_POJO).memberName("RotationRules")
            .getter(getter(DescribeSecretResponse::rotationRules)).setter(setter(Builder::rotationRules))
            .constructor(RotationRulesType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationRules").build()).build();

    private static final SdkField<Instant> LAST_ROTATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastRotatedDate").getter(getter(DescribeSecretResponse::lastRotatedDate))
            .setter(setter(Builder::lastRotatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRotatedDate").build()).build();

    private static final SdkField<Instant> LAST_CHANGED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastChangedDate").getter(getter(DescribeSecretResponse::lastChangedDate))
            .setter(setter(Builder::lastChangedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastChangedDate").build()).build();

    private static final SdkField<Instant> LAST_ACCESSED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAccessedDate").getter(getter(DescribeSecretResponse::lastAccessedDate))
            .setter(setter(Builder::lastAccessedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedDate").build()).build();

    private static final SdkField<Instant> DELETED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletedDate").getter(getter(DescribeSecretResponse::deletedDate)).setter(setter(Builder::deletedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedDate").build()).build();

    private static final SdkField<Instant> NEXT_ROTATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NextRotationDate").getter(getter(DescribeSecretResponse::nextRotationDate))
            .setter(setter(Builder::nextRotationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRotationDate").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribeSecretResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> VERSION_IDS_TO_STAGES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("VersionIdsToStages")
            .getter(getter(DescribeSecretResponse::versionIdsToStages))
            .setter(setter(Builder::versionIdsToStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionIdsToStages").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> OWNING_SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwningService").getter(getter(DescribeSecretResponse::owningService))
            .setter(setter(Builder::owningService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwningService").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(DescribeSecretResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryRegion").getter(getter(DescribeSecretResponse::primaryRegion))
            .setter(setter(Builder::primaryRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryRegion").build()).build();

    private static final SdkField<List<ReplicationStatusType>> REPLICATION_STATUS_FIELD = SdkField
            .<List<ReplicationStatusType>> builder(MarshallingType.LIST)
            .memberName("ReplicationStatus")
            .getter(getter(DescribeSecretResponse::replicationStatus))
            .setter(setter(Builder::replicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationStatusType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationStatusType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, KMS_KEY_ID_FIELD, ROTATION_ENABLED_FIELD, ROTATION_LAMBDA_ARN_FIELD, ROTATION_RULES_FIELD,
            LAST_ROTATED_DATE_FIELD, LAST_CHANGED_DATE_FIELD, LAST_ACCESSED_DATE_FIELD, DELETED_DATE_FIELD,
            NEXT_ROTATION_DATE_FIELD, TAGS_FIELD, VERSION_IDS_TO_STAGES_FIELD, OWNING_SERVICE_FIELD, CREATED_DATE_FIELD,
            PRIMARY_REGION_FIELD, REPLICATION_STATUS_FIELD));

    private final String arn;

    private final String name;

    private final String description;

    private final String kmsKeyId;

    private final Boolean rotationEnabled;

    private final String rotationLambdaARN;

    private final RotationRulesType rotationRules;

    private final Instant lastRotatedDate;

    private final Instant lastChangedDate;

    private final Instant lastAccessedDate;

    private final Instant deletedDate;

    private final Instant nextRotationDate;

    private final List<Tag> tags;

    private final Map<String, List<String>> versionIdsToStages;

    private final String owningService;

    private final Instant createdDate;

    private final String primaryRegion;

    private final List<ReplicationStatusType> replicationStatus;

    private DescribeSecretResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.rotationEnabled = builder.rotationEnabled;
        this.rotationLambdaARN = builder.rotationLambdaARN;
        this.rotationRules = builder.rotationRules;
        this.lastRotatedDate = builder.lastRotatedDate;
        this.lastChangedDate = builder.lastChangedDate;
        this.lastAccessedDate = builder.lastAccessedDate;
        this.deletedDate = builder.deletedDate;
        this.nextRotationDate = builder.nextRotationDate;
        this.tags = builder.tags;
        this.versionIdsToStages = builder.versionIdsToStages;
        this.owningService = builder.owningService;
        this.createdDate = builder.createdDate;
        this.primaryRegion = builder.primaryRegion;
        this.replicationStatus = builder.replicationStatus;
    }

    /**
     * <p>
     * The ARN of the secret.
     * </p>
     * 
     * @return The ARN of the secret.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the secret.
     * </p>
     * 
     * @return The name of the secret.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the secret.
     * </p>
     * 
     * @return The description of the secret.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The key ID or alias ARN of the KMS key that Secrets Manager uses to encrypt the secret value. If the secret is
     * encrypted with the Amazon Web Services managed key <code>aws/secretsmanager</code>, this field is omitted.
     * Secrets created using the console use an KMS key ID.
     * </p>
     * 
     * @return The key ID or alias ARN of the KMS key that Secrets Manager uses to encrypt the secret value. If the
     *         secret is encrypted with the Amazon Web Services managed key <code>aws/secretsmanager</code>, this field
     *         is omitted. Secrets created using the console use an KMS key ID.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether automatic rotation is turned on for this secret.
     * </p>
     * <p>
     * To turn on rotation, use <a>RotateSecret</a>. To turn off rotation, use <a>CancelRotateSecret</a>.
     * </p>
     * 
     * @return Specifies whether automatic rotation is turned on for this secret.</p>
     *         <p>
     *         To turn on rotation, use <a>RotateSecret</a>. To turn off rotation, use <a>CancelRotateSecret</a>.
     */
    public final Boolean rotationEnabled() {
        return rotationEnabled;
    }

    /**
     * <p>
     * The ARN of the Lambda function that Secrets Manager invokes to rotate the secret.
     * </p>
     * 
     * @return The ARN of the Lambda function that Secrets Manager invokes to rotate the secret.
     */
    public final String rotationLambdaARN() {
        return rotationLambdaARN;
    }

    /**
     * <p>
     * The rotation schedule and Lambda function for this secret. If the secret previously had rotation turned on, but
     * it is now turned off, this field shows the previous rotation schedule and rotation function. If the secret never
     * had rotation turned on, this field is omitted.
     * </p>
     * 
     * @return The rotation schedule and Lambda function for this secret. If the secret previously had rotation turned
     *         on, but it is now turned off, this field shows the previous rotation schedule and rotation function. If
     *         the secret never had rotation turned on, this field is omitted.
     */
    public final RotationRulesType rotationRules() {
        return rotationRules;
    }

    /**
     * <p>
     * The last date and time that Secrets Manager rotated the secret. If the secret isn't configured for rotation,
     * Secrets Manager returns null.
     * </p>
     * 
     * @return The last date and time that Secrets Manager rotated the secret. If the secret isn't configured for
     *         rotation, Secrets Manager returns null.
     */
    public final Instant lastRotatedDate() {
        return lastRotatedDate;
    }

    /**
     * <p>
     * The last date and time that this secret was modified in any way.
     * </p>
     * 
     * @return The last date and time that this secret was modified in any way.
     */
    public final Instant lastChangedDate() {
        return lastChangedDate;
    }

    /**
     * <p>
     * The date that the secret was last accessed in the Region. This field is omitted if the secret has never been
     * retrieved in the Region.
     * </p>
     * 
     * @return The date that the secret was last accessed in the Region. This field is omitted if the secret has never
     *         been retrieved in the Region.
     */
    public final Instant lastAccessedDate() {
        return lastAccessedDate;
    }

    /**
     * <p>
     * The date the secret is scheduled for deletion. If it is not scheduled for deletion, this field is omitted. When
     * you delete a secret, Secrets Manager requires a recovery window of at least 7 days before deleting the secret.
     * Some time after the deleted date, Secrets Manager deletes the secret, including all of its versions.
     * </p>
     * <p>
     * If a secret is scheduled for deletion, then its details, including the encrypted secret value, is not accessible.
     * To cancel a scheduled deletion and restore access to the secret, use <a>RestoreSecret</a>.
     * </p>
     * 
     * @return The date the secret is scheduled for deletion. If it is not scheduled for deletion, this field is
     *         omitted. When you delete a secret, Secrets Manager requires a recovery window of at least 7 days before
     *         deleting the secret. Some time after the deleted date, Secrets Manager deletes the secret, including all
     *         of its versions.</p>
     *         <p>
     *         If a secret is scheduled for deletion, then its details, including the encrypted secret value, is not
     *         accessible. To cancel a scheduled deletion and restore access to the secret, use <a>RestoreSecret</a>.
     */
    public final Instant deletedDate() {
        return deletedDate;
    }

    /**
     * <p>
     * The next date and time that Secrets Manager will rotate the secret, rounded to the nearest hour. If the secret
     * isn't configured for rotation, Secrets Manager returns null.
     * </p>
     * 
     * @return The next date and time that Secrets Manager will rotate the secret, rounded to the nearest hour. If the
     *         secret isn't configured for rotation, Secrets Manager returns null.
     */
    public final Instant nextRotationDate() {
        return nextRotationDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags attached to the secret. To add tags to a secret, use <a>TagResource</a>. To remove tags, use
     * <a>UntagResource</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags attached to the secret. To add tags to a secret, use <a>TagResource</a>. To remove tags,
     *         use <a>UntagResource</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the VersionIdsToStages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVersionIdsToStages() {
        return versionIdsToStages != null && !(versionIdsToStages instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the versions of the secret that have staging labels attached. Versions that don't have staging labels
     * are considered deprecated and Secrets Manager can delete them.
     * </p>
     * <p>
     * Secrets Manager uses staging labels to indicate the status of a secret version during rotation. The three staging
     * labels for rotation are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWSCURRENT</code>, which indicates the current version of the secret.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWSPENDING</code>, which indicates the version of the secret that contains new secret information that will
     * become the next current version when rotation finishes.
     * </p>
     * <p>
     * During rotation, Secrets Manager creates an <code>AWSPENDING</code> version ID before creating the new secret
     * version. To check if a secret version exists, call <a>GetSecretValue</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWSPREVIOUS</code>, which indicates the previous current version of the secret. You can use this as the
     * <i>last known good</i> version.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about rotation and staging labels, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation
     * works</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVersionIdsToStages} method.
     * </p>
     * 
     * @return A list of the versions of the secret that have staging labels attached. Versions that don't have staging
     *         labels are considered deprecated and Secrets Manager can delete them.</p>
     *         <p>
     *         Secrets Manager uses staging labels to indicate the status of a secret version during rotation. The three
     *         staging labels for rotation are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWSCURRENT</code>, which indicates the current version of the secret.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWSPENDING</code>, which indicates the version of the secret that contains new secret information
     *         that will become the next current version when rotation finishes.
     *         </p>
     *         <p>
     *         During rotation, Secrets Manager creates an <code>AWSPENDING</code> version ID before creating the new
     *         secret version. To check if a secret version exists, call <a>GetSecretValue</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWSPREVIOUS</code>, which indicates the previous current version of the secret. You can use this as
     *         the <i>last known good</i> version.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about rotation and staging labels, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation
     *         works</a>.
     */
    public final Map<String, List<String>> versionIdsToStages() {
        return versionIdsToStages;
    }

    /**
     * <p>
     * The ID of the service that created this secret. For more information, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets managed by
     * other Amazon Web Services services</a>.
     * </p>
     * 
     * @return The ID of the service that created this secret. For more information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
     *         managed by other Amazon Web Services services</a>.
     */
    public final String owningService() {
        return owningService;
    }

    /**
     * <p>
     * The date the secret was created.
     * </p>
     * 
     * @return The date the secret was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The Region the secret is in. If a secret is replicated to other Regions, the replicas are listed in
     * <code>ReplicationStatus</code>.
     * </p>
     * 
     * @return The Region the secret is in. If a secret is replicated to other Regions, the replicas are listed in
     *         <code>ReplicationStatus</code>.
     */
    public final String primaryRegion() {
        return primaryRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationStatus property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationStatus() {
        return replicationStatus != null && !(replicationStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the replicas of this secret and their status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Failed</code>, which indicates that the replica was not created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InSync</code>, which indicates that the replica was created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationStatus} method.
     * </p>
     * 
     * @return A list of the replicas of this secret and their status: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Failed</code>, which indicates that the replica was not created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InSync</code>, which indicates that the replica was created.
     *         </p>
     *         </li>
     */
    public final List<ReplicationStatusType> replicationStatus() {
        return replicationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(rotationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(rotationLambdaARN());
        hashCode = 31 * hashCode + Objects.hashCode(rotationRules());
        hashCode = 31 * hashCode + Objects.hashCode(lastRotatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastChangedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessedDate());
        hashCode = 31 * hashCode + Objects.hashCode(deletedDate());
        hashCode = 31 * hashCode + Objects.hashCode(nextRotationDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVersionIdsToStages() ? versionIdsToStages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owningService());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationStatus() ? replicationStatus() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecretResponse)) {
            return false;
        }
        DescribeSecretResponse other = (DescribeSecretResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(rotationEnabled(), other.rotationEnabled())
                && Objects.equals(rotationLambdaARN(), other.rotationLambdaARN())
                && Objects.equals(rotationRules(), other.rotationRules())
                && Objects.equals(lastRotatedDate(), other.lastRotatedDate())
                && Objects.equals(lastChangedDate(), other.lastChangedDate())
                && Objects.equals(lastAccessedDate(), other.lastAccessedDate())
                && Objects.equals(deletedDate(), other.deletedDate())
                && Objects.equals(nextRotationDate(), other.nextRotationDate()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasVersionIdsToStages() == other.hasVersionIdsToStages()
                && Objects.equals(versionIdsToStages(), other.versionIdsToStages())
                && Objects.equals(owningService(), other.owningService()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(primaryRegion(), other.primaryRegion())
                && hasReplicationStatus() == other.hasReplicationStatus()
                && Objects.equals(replicationStatus(), other.replicationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSecretResponse").add("ARN", arn()).add("Name", name()).add("Description", description())
                .add("KmsKeyId", kmsKeyId()).add("RotationEnabled", rotationEnabled())
                .add("RotationLambdaARN", rotationLambdaARN()).add("RotationRules", rotationRules())
                .add("LastRotatedDate", lastRotatedDate()).add("LastChangedDate", lastChangedDate())
                .add("LastAccessedDate", lastAccessedDate()).add("DeletedDate", deletedDate())
                .add("NextRotationDate", nextRotationDate()).add("Tags", hasTags() ? tags() : null)
                .add("VersionIdsToStages", hasVersionIdsToStages() ? versionIdsToStages() : null)
                .add("OwningService", owningService()).add("CreatedDate", createdDate()).add("PrimaryRegion", primaryRegion())
                .add("ReplicationStatus", hasReplicationStatus() ? replicationStatus() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "RotationEnabled":
            return Optional.ofNullable(clazz.cast(rotationEnabled()));
        case "RotationLambdaARN":
            return Optional.ofNullable(clazz.cast(rotationLambdaARN()));
        case "RotationRules":
            return Optional.ofNullable(clazz.cast(rotationRules()));
        case "LastRotatedDate":
            return Optional.ofNullable(clazz.cast(lastRotatedDate()));
        case "LastChangedDate":
            return Optional.ofNullable(clazz.cast(lastChangedDate()));
        case "LastAccessedDate":
            return Optional.ofNullable(clazz.cast(lastAccessedDate()));
        case "DeletedDate":
            return Optional.ofNullable(clazz.cast(deletedDate()));
        case "NextRotationDate":
            return Optional.ofNullable(clazz.cast(nextRotationDate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VersionIdsToStages":
            return Optional.ofNullable(clazz.cast(versionIdsToStages()));
        case "OwningService":
            return Optional.ofNullable(clazz.cast(owningService()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "PrimaryRegion":
            return Optional.ofNullable(clazz.cast(primaryRegion()));
        case "ReplicationStatus":
            return Optional.ofNullable(clazz.cast(replicationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecretResponse, T> g) {
        return obj -> g.apply((DescribeSecretResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecretsManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSecretResponse> {
        /**
         * <p>
         * The ARN of the secret.
         * </p>
         * 
         * @param arn
         *        The ARN of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the secret.
         * </p>
         * 
         * @param name
         *        The name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the secret.
         * </p>
         * 
         * @param description
         *        The description of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The key ID or alias ARN of the KMS key that Secrets Manager uses to encrypt the secret value. If the secret
         * is encrypted with the Amazon Web Services managed key <code>aws/secretsmanager</code>, this field is omitted.
         * Secrets created using the console use an KMS key ID.
         * </p>
         * 
         * @param kmsKeyId
         *        The key ID or alias ARN of the KMS key that Secrets Manager uses to encrypt the secret value. If the
         *        secret is encrypted with the Amazon Web Services managed key <code>aws/secretsmanager</code>, this
         *        field is omitted. Secrets created using the console use an KMS key ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether automatic rotation is turned on for this secret.
         * </p>
         * <p>
         * To turn on rotation, use <a>RotateSecret</a>. To turn off rotation, use <a>CancelRotateSecret</a>.
         * </p>
         * 
         * @param rotationEnabled
         *        Specifies whether automatic rotation is turned on for this secret.</p>
         *        <p>
         *        To turn on rotation, use <a>RotateSecret</a>. To turn off rotation, use <a>CancelRotateSecret</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationEnabled(Boolean rotationEnabled);

        /**
         * <p>
         * The ARN of the Lambda function that Secrets Manager invokes to rotate the secret.
         * </p>
         * 
         * @param rotationLambdaARN
         *        The ARN of the Lambda function that Secrets Manager invokes to rotate the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationLambdaARN(String rotationLambdaARN);

        /**
         * <p>
         * The rotation schedule and Lambda function for this secret. If the secret previously had rotation turned on,
         * but it is now turned off, this field shows the previous rotation schedule and rotation function. If the
         * secret never had rotation turned on, this field is omitted.
         * </p>
         * 
         * @param rotationRules
         *        The rotation schedule and Lambda function for this secret. If the secret previously had rotation
         *        turned on, but it is now turned off, this field shows the previous rotation schedule and rotation
         *        function. If the secret never had rotation turned on, this field is omitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationRules(RotationRulesType rotationRules);

        /**
         * <p>
         * The rotation schedule and Lambda function for this secret. If the secret previously had rotation turned on,
         * but it is now turned off, this field shows the previous rotation schedule and rotation function. If the
         * secret never had rotation turned on, this field is omitted.
         * </p>
         * This is a convenience method that creates an instance of the {@link RotationRulesType.Builder} avoiding the
         * need to create one manually via {@link RotationRulesType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RotationRulesType.Builder#build()} is called immediately and its
         * result is passed to {@link #rotationRules(RotationRulesType)}.
         * 
         * @param rotationRules
         *        a consumer that will call methods on {@link RotationRulesType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rotationRules(RotationRulesType)
         */
        default Builder rotationRules(Consumer<RotationRulesType.Builder> rotationRules) {
            return rotationRules(RotationRulesType.builder().applyMutation(rotationRules).build());
        }

        /**
         * <p>
         * The last date and time that Secrets Manager rotated the secret. If the secret isn't configured for rotation,
         * Secrets Manager returns null.
         * </p>
         * 
         * @param lastRotatedDate
         *        The last date and time that Secrets Manager rotated the secret. If the secret isn't configured for
         *        rotation, Secrets Manager returns null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRotatedDate(Instant lastRotatedDate);

        /**
         * <p>
         * The last date and time that this secret was modified in any way.
         * </p>
         * 
         * @param lastChangedDate
         *        The last date and time that this secret was modified in any way.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastChangedDate(Instant lastChangedDate);

        /**
         * <p>
         * The date that the secret was last accessed in the Region. This field is omitted if the secret has never been
         * retrieved in the Region.
         * </p>
         * 
         * @param lastAccessedDate
         *        The date that the secret was last accessed in the Region. This field is omitted if the secret has
         *        never been retrieved in the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessedDate(Instant lastAccessedDate);

        /**
         * <p>
         * The date the secret is scheduled for deletion. If it is not scheduled for deletion, this field is omitted.
         * When you delete a secret, Secrets Manager requires a recovery window of at least 7 days before deleting the
         * secret. Some time after the deleted date, Secrets Manager deletes the secret, including all of its versions.
         * </p>
         * <p>
         * If a secret is scheduled for deletion, then its details, including the encrypted secret value, is not
         * accessible. To cancel a scheduled deletion and restore access to the secret, use <a>RestoreSecret</a>.
         * </p>
         * 
         * @param deletedDate
         *        The date the secret is scheduled for deletion. If it is not scheduled for deletion, this field is
         *        omitted. When you delete a secret, Secrets Manager requires a recovery window of at least 7 days
         *        before deleting the secret. Some time after the deleted date, Secrets Manager deletes the secret,
         *        including all of its versions.</p>
         *        <p>
         *        If a secret is scheduled for deletion, then its details, including the encrypted secret value, is not
         *        accessible. To cancel a scheduled deletion and restore access to the secret, use <a>RestoreSecret</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedDate(Instant deletedDate);

        /**
         * <p>
         * The next date and time that Secrets Manager will rotate the secret, rounded to the nearest hour. If the
         * secret isn't configured for rotation, Secrets Manager returns null.
         * </p>
         * 
         * @param nextRotationDate
         *        The next date and time that Secrets Manager will rotate the secret, rounded to the nearest hour. If
         *        the secret isn't configured for rotation, Secrets Manager returns null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextRotationDate(Instant nextRotationDate);

        /**
         * <p>
         * The list of tags attached to the secret. To add tags to a secret, use <a>TagResource</a>. To remove tags, use
         * <a>UntagResource</a>.
         * </p>
         * 
         * @param tags
         *        The list of tags attached to the secret. To add tags to a secret, use <a>TagResource</a>. To remove
         *        tags, use <a>UntagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags attached to the secret. To add tags to a secret, use <a>TagResource</a>. To remove tags, use
         * <a>UntagResource</a>.
         * </p>
         * 
         * @param tags
         *        The list of tags attached to the secret. To add tags to a secret, use <a>TagResource</a>. To remove
         *        tags, use <a>UntagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags attached to the secret. To add tags to a secret, use <a>TagResource</a>. To remove tags, use
         * <a>UntagResource</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.secretsmanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.secretsmanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.secretsmanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.secretsmanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A list of the versions of the secret that have staging labels attached. Versions that don't have staging
         * labels are considered deprecated and Secrets Manager can delete them.
         * </p>
         * <p>
         * Secrets Manager uses staging labels to indicate the status of a secret version during rotation. The three
         * staging labels for rotation are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWSCURRENT</code>, which indicates the current version of the secret.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWSPENDING</code>, which indicates the version of the secret that contains new secret information that
         * will become the next current version when rotation finishes.
         * </p>
         * <p>
         * During rotation, Secrets Manager creates an <code>AWSPENDING</code> version ID before creating the new secret
         * version. To check if a secret version exists, call <a>GetSecretValue</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWSPREVIOUS</code>, which indicates the previous current version of the secret. You can use this as the
         * <i>last known good</i> version.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about rotation and staging labels, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How rotation
         * works</a>.
         * </p>
         * 
         * @param versionIdsToStages
         *        A list of the versions of the secret that have staging labels attached. Versions that don't have
         *        staging labels are considered deprecated and Secrets Manager can delete them.</p>
         *        <p>
         *        Secrets Manager uses staging labels to indicate the status of a secret version during rotation. The
         *        three staging labels for rotation are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWSCURRENT</code>, which indicates the current version of the secret.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWSPENDING</code>, which indicates the version of the secret that contains new secret
         *        information that will become the next current version when rotation finishes.
         *        </p>
         *        <p>
         *        During rotation, Secrets Manager creates an <code>AWSPENDING</code> version ID before creating the new
         *        secret version. To check if a secret version exists, call <a>GetSecretValue</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWSPREVIOUS</code>, which indicates the previous current version of the secret. You can use this
         *        as the <i>last known good</i> version.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about rotation and staging labels, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html">How
         *        rotation works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdsToStages(Map<String, ? extends Collection<String>> versionIdsToStages);

        /**
         * <p>
         * The ID of the service that created this secret. For more information, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
         * managed by other Amazon Web Services services</a>.
         * </p>
         * 
         * @param owningService
         *        The ID of the service that created this secret. For more information, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html">Secrets
         *        managed by other Amazon Web Services services</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningService(String owningService);

        /**
         * <p>
         * The date the secret was created.
         * </p>
         * 
         * @param createdDate
         *        The date the secret was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The Region the secret is in. If a secret is replicated to other Regions, the replicas are listed in
         * <code>ReplicationStatus</code>.
         * </p>
         * 
         * @param primaryRegion
         *        The Region the secret is in. If a secret is replicated to other Regions, the replicas are listed in
         *        <code>ReplicationStatus</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryRegion(String primaryRegion);

        /**
         * <p>
         * A list of the replicas of this secret and their status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Failed</code>, which indicates that the replica was not created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InSync</code>, which indicates that the replica was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationStatus
         *        A list of the replicas of this secret and their status: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Failed</code>, which indicates that the replica was not created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the
         *        replica.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InSync</code>, which indicates that the replica was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatus(Collection<ReplicationStatusType> replicationStatus);

        /**
         * <p>
         * A list of the replicas of this secret and their status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Failed</code>, which indicates that the replica was not created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InSync</code>, which indicates that the replica was created.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationStatus
         *        A list of the replicas of this secret and their status: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Failed</code>, which indicates that the replica was not created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the
         *        replica.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InSync</code>, which indicates that the replica was created.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatus(ReplicationStatusType... replicationStatus);

        /**
         * <p>
         * A list of the replicas of this secret and their status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Failed</code>, which indicates that the replica was not created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code>, which indicates that Secrets Manager is in the process of creating the replica.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InSync</code>, which indicates that the replica was created.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationStatus(List<ReplicationStatusType>)}.
         * 
         * @param replicationStatus
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationStatus(java.util.Collection<ReplicationStatusType>)
         */
        Builder replicationStatus(Consumer<ReplicationStatusType.Builder>... replicationStatus);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String kmsKeyId;

        private Boolean rotationEnabled;

        private String rotationLambdaARN;

        private RotationRulesType rotationRules;

        private Instant lastRotatedDate;

        private Instant lastChangedDate;

        private Instant lastAccessedDate;

        private Instant deletedDate;

        private Instant nextRotationDate;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<String>> versionIdsToStages = DefaultSdkAutoConstructMap.getInstance();

        private String owningService;

        private Instant createdDate;

        private String primaryRegion;

        private List<ReplicationStatusType> replicationStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecretResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            kmsKeyId(model.kmsKeyId);
            rotationEnabled(model.rotationEnabled);
            rotationLambdaARN(model.rotationLambdaARN);
            rotationRules(model.rotationRules);
            lastRotatedDate(model.lastRotatedDate);
            lastChangedDate(model.lastChangedDate);
            lastAccessedDate(model.lastAccessedDate);
            deletedDate(model.deletedDate);
            nextRotationDate(model.nextRotationDate);
            tags(model.tags);
            versionIdsToStages(model.versionIdsToStages);
            owningService(model.owningService);
            createdDate(model.createdDate);
            primaryRegion(model.primaryRegion);
            replicationStatus(model.replicationStatus);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getRotationEnabled() {
            return rotationEnabled;
        }

        public final void setRotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
        }

        @Override
        public final Builder rotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
            return this;
        }

        public final String getRotationLambdaARN() {
            return rotationLambdaARN;
        }

        public final void setRotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
        }

        @Override
        public final Builder rotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
            return this;
        }

        public final RotationRulesType.Builder getRotationRules() {
            return rotationRules != null ? rotationRules.toBuilder() : null;
        }

        public final void setRotationRules(RotationRulesType.BuilderImpl rotationRules) {
            this.rotationRules = rotationRules != null ? rotationRules.build() : null;
        }

        @Override
        public final Builder rotationRules(RotationRulesType rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        public final Instant getLastRotatedDate() {
            return lastRotatedDate;
        }

        public final void setLastRotatedDate(Instant lastRotatedDate) {
            this.lastRotatedDate = lastRotatedDate;
        }

        @Override
        public final Builder lastRotatedDate(Instant lastRotatedDate) {
            this.lastRotatedDate = lastRotatedDate;
            return this;
        }

        public final Instant getLastChangedDate() {
            return lastChangedDate;
        }

        public final void setLastChangedDate(Instant lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
        }

        @Override
        public final Builder lastChangedDate(Instant lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
            return this;
        }

        public final Instant getLastAccessedDate() {
            return lastAccessedDate;
        }

        public final void setLastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
        }

        @Override
        public final Builder lastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
            return this;
        }

        public final Instant getDeletedDate() {
            return deletedDate;
        }

        public final void setDeletedDate(Instant deletedDate) {
            this.deletedDate = deletedDate;
        }

        @Override
        public final Builder deletedDate(Instant deletedDate) {
            this.deletedDate = deletedDate;
            return this;
        }

        public final Instant getNextRotationDate() {
            return nextRotationDate;
        }

        public final void setNextRotationDate(Instant nextRotationDate) {
            this.nextRotationDate = nextRotationDate;
        }

        @Override
        public final Builder nextRotationDate(Instant nextRotationDate) {
            this.nextRotationDate = nextRotationDate;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getVersionIdsToStages() {
            if (versionIdsToStages instanceof SdkAutoConstructMap) {
                return null;
            }
            return versionIdsToStages;
        }

        public final void setVersionIdsToStages(Map<String, ? extends Collection<String>> versionIdsToStages) {
            this.versionIdsToStages = SecretVersionsToStagesMapTypeCopier.copy(versionIdsToStages);
        }

        @Override
        public final Builder versionIdsToStages(Map<String, ? extends Collection<String>> versionIdsToStages) {
            this.versionIdsToStages = SecretVersionsToStagesMapTypeCopier.copy(versionIdsToStages);
            return this;
        }

        public final String getOwningService() {
            return owningService;
        }

        public final void setOwningService(String owningService) {
            this.owningService = owningService;
        }

        @Override
        public final Builder owningService(String owningService) {
            this.owningService = owningService;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getPrimaryRegion() {
            return primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final List<ReplicationStatusType.Builder> getReplicationStatus() {
            List<ReplicationStatusType.Builder> result = ReplicationStatusListTypeCopier.copyToBuilder(this.replicationStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationStatus(Collection<ReplicationStatusType.BuilderImpl> replicationStatus) {
            this.replicationStatus = ReplicationStatusListTypeCopier.copyFromBuilder(replicationStatus);
        }

        @Override
        public final Builder replicationStatus(Collection<ReplicationStatusType> replicationStatus) {
            this.replicationStatus = ReplicationStatusListTypeCopier.copy(replicationStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatus(ReplicationStatusType... replicationStatus) {
            replicationStatus(Arrays.asList(replicationStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatus(Consumer<ReplicationStatusType.Builder>... replicationStatus) {
            replicationStatus(Stream.of(replicationStatus).map(c -> ReplicationStatusType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSecretResponse build() {
            return new DescribeSecretResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
