/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.schemas.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaSummary> {
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(SchemaSummary.getter(SchemaSummary::lastModified)).setter(SchemaSummary.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaArn").getter(SchemaSummary.getter(SchemaSummary::schemaArn)).setter(SchemaSummary.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaName").getter(SchemaSummary.getter(SchemaSummary::schemaName)).setter(SchemaSummary.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(SchemaSummary.getter(SchemaSummary::tags)).setter(SchemaSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> VERSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionCount").getter(SchemaSummary.getter(SchemaSummary::versionCount)).setter(SchemaSummary.setter(Builder::versionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFIED_FIELD, SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD, TAGS_FIELD, VERSION_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant lastModified;
    private final String schemaArn;
    private final String schemaName;
    private final Map<String, String> tags;
    private final Long versionCount;

    private SchemaSummary(BuilderImpl builder) {
        this.lastModified = builder.lastModified;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.tags = builder.tags;
        this.versionCount = builder.versionCount;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Long versionCount() {
        return this.versionCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaSummary)) {
            return false;
        }
        SchemaSummary other = (SchemaSummary)obj;
        return Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.schemaName(), other.schemaName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.versionCount(), other.versionCount());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaSummary").add("LastModified", (Object)this.lastModified()).add("SchemaArn", (Object)this.schemaArn()).add("SchemaName", (Object)this.schemaName()).add("Tags", this.hasTags() ? this.tags() : null).add("VersionCount", (Object)this.versionCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "VersionCount": {
                return Optional.ofNullable(clazz.cast(this.versionCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaSummary, T> g) {
        return obj -> g.apply((SchemaSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastModified;
        private String schemaArn;
        private String schemaName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Long versionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaSummary model) {
            this.lastModified(model.lastModified);
            this.schemaArn(model.schemaArn);
            this.schemaName(model.schemaName);
            this.tags(model.tags);
            this.versionCount(model.versionCount);
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Long getVersionCount() {
            return this.versionCount;
        }

        public final void setVersionCount(Long versionCount) {
            this.versionCount = versionCount;
        }

        @Override
        public final Builder versionCount(Long versionCount) {
            this.versionCount = versionCount;
            return this;
        }

        public SchemaSummary build() {
            return new SchemaSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaSummary> {
        public Builder lastModified(Instant var1);

        public Builder schemaArn(String var1);

        public Builder schemaName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder versionCount(Long var1);
    }
}

