/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.scheduler.SchedulerClient;
import software.amazon.awssdk.services.scheduler.internal.UserAgentUtils;
import software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest;
import software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse;
import software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary;

public class ListScheduleGroupsIterable
implements SdkIterable<ListScheduleGroupsResponse> {
    private final SchedulerClient client;
    private final ListScheduleGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScheduleGroupsIterable(SchedulerClient client, ListScheduleGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListScheduleGroupsResponseFetcher();
    }

    public Iterator<ListScheduleGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduleGroupSummary> scheduleGroups() {
        Function<ListScheduleGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduleGroups() != null) {
                return response.scheduleGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScheduleGroupsResponseFetcher
    implements SyncPageFetcher<ListScheduleGroupsResponse> {
        private ListScheduleGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduleGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScheduleGroupsResponse nextPage(ListScheduleGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListScheduleGroupsIterable.this.client.listScheduleGroups(ListScheduleGroupsIterable.this.firstRequest);
            }
            return ListScheduleGroupsIterable.this.client.listScheduleGroups((ListScheduleGroupsRequest)((Object)ListScheduleGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

