/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScheduleGroupsResponse extends SchedulerResponse implements
        ToCopyableBuilder<ListScheduleGroupsResponse.Builder, ListScheduleGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListScheduleGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ScheduleGroupSummary>> SCHEDULE_GROUPS_FIELD = SdkField
            .<List<ScheduleGroupSummary>> builder(MarshallingType.LIST)
            .memberName("ScheduleGroups")
            .getter(getter(ListScheduleGroupsResponse::scheduleGroups))
            .setter(setter(Builder::scheduleGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduleGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduleGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCHEDULE_GROUPS_FIELD));

    private final String nextToken;

    private final List<ScheduleGroupSummary> scheduleGroups;

    private ListScheduleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduleGroups = builder.scheduleGroups;
    }

    /**
     * <p>
     * Indicates whether there are additional results to retrieve. If the value is null, there are no more results.
     * </p>
     * 
     * @return Indicates whether there are additional results to retrieve. If the value is null, there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduleGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScheduleGroups() {
        return scheduleGroups != null && !(scheduleGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The schedule groups that match the specified criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduleGroups} method.
     * </p>
     * 
     * @return The schedule groups that match the specified criteria.
     */
    public final List<ScheduleGroupSummary> scheduleGroups() {
        return scheduleGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduleGroups() ? scheduleGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduleGroupsResponse)) {
            return false;
        }
        ListScheduleGroupsResponse other = (ListScheduleGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasScheduleGroups() == other.hasScheduleGroups()
                && Objects.equals(scheduleGroups(), other.scheduleGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScheduleGroupsResponse").add("NextToken", nextToken())
                .add("ScheduleGroups", hasScheduleGroups() ? scheduleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ScheduleGroups":
            return Optional.ofNullable(clazz.cast(scheduleGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScheduleGroupsResponse, T> g) {
        return obj -> g.apply((ListScheduleGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchedulerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListScheduleGroupsResponse> {
        /**
         * <p>
         * Indicates whether there are additional results to retrieve. If the value is null, there are no more results.
         * </p>
         * 
         * @param nextToken
         *        Indicates whether there are additional results to retrieve. If the value is null, there are no more
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The schedule groups that match the specified criteria.
         * </p>
         * 
         * @param scheduleGroups
         *        The schedule groups that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleGroups(Collection<ScheduleGroupSummary> scheduleGroups);

        /**
         * <p>
         * The schedule groups that match the specified criteria.
         * </p>
         * 
         * @param scheduleGroups
         *        The schedule groups that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleGroups(ScheduleGroupSummary... scheduleGroups);

        /**
         * <p>
         * The schedule groups that match the specified criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduleGroups(List<ScheduleGroupSummary>)}.
         * 
         * @param scheduleGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleGroups(java.util.Collection<ScheduleGroupSummary>)
         */
        Builder scheduleGroups(Consumer<ScheduleGroupSummary.Builder>... scheduleGroups);
    }

    static final class BuilderImpl extends SchedulerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ScheduleGroupSummary> scheduleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduleGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            scheduleGroups(model.scheduleGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScheduleGroupSummary.Builder> getScheduleGroups() {
            List<ScheduleGroupSummary.Builder> result = ScheduleGroupListCopier.copyToBuilder(this.scheduleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduleGroups(Collection<ScheduleGroupSummary.BuilderImpl> scheduleGroups) {
            this.scheduleGroups = ScheduleGroupListCopier.copyFromBuilder(scheduleGroups);
        }

        @Override
        public final Builder scheduleGroups(Collection<ScheduleGroupSummary> scheduleGroups) {
            this.scheduleGroups = ScheduleGroupListCopier.copy(scheduleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleGroups(ScheduleGroupSummary... scheduleGroups) {
            scheduleGroups(Arrays.asList(scheduleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleGroups(Consumer<ScheduleGroupSummary.Builder>... scheduleGroups) {
            scheduleGroups(Stream.of(scheduleGroups).map(c -> ScheduleGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScheduleGroupsResponse build() {
            return new ListScheduleGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
