/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.savingsplans.DefaultSavingsplansAsyncClient;
import software.amazon.awssdk.services.savingsplans.DefaultSavingsplansBaseClientBuilder;
import software.amazon.awssdk.services.savingsplans.SavingsplansAsyncClient;
import software.amazon.awssdk.services.savingsplans.SavingsplansAsyncClientBuilder;
import software.amazon.awssdk.services.savingsplans.SavingsplansServiceClientConfiguration;
import software.amazon.awssdk.services.savingsplans.endpoints.SavingsplansEndpointProvider;

@SdkInternalApi
final class DefaultSavingsplansAsyncClientBuilder
extends DefaultSavingsplansBaseClientBuilder<SavingsplansAsyncClientBuilder, SavingsplansAsyncClient>
implements SavingsplansAsyncClientBuilder {
    DefaultSavingsplansAsyncClientBuilder() {
    }

    @Override
    public DefaultSavingsplansAsyncClientBuilder endpointProvider(SavingsplansEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SavingsplansAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSavingsplansAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SavingsplansServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSavingsplansAsyncClient client = new DefaultSavingsplansAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SavingsplansServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SavingsplansServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

