/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerruntime.model.responsestream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointWithResponseStreamResponseHandler;
import software.amazon.awssdk.services.sagemakerruntime.model.PayloadPart;
import software.amazon.awssdk.services.sagemakerruntime.model.ResponseStream;

/**
 * A specialization of {@code software.amazon.awssdk.services.sagemakerruntime.model.PayloadPart} that represents the
 * {@code ResponseStream$PayloadPart} event. Do not use this class directly. Instead, use the static builder methods on
 * {@link software.amazon.awssdk.services.sagemakerruntime.model.ResponseStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultPayloadPart extends PayloadPart {
    private static final long serialVersionUID = 1L;

    DefaultPayloadPart(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(InvokeEndpointWithResponseStreamResponseHandler.Visitor visitor) {
        visitor.visitPayloadPart(this);
    }

    @Override
    public ResponseStream.EventType sdkEventType() {
        return ResponseStream.EventType.PAYLOAD_PART;
    }

    public interface Builder extends PayloadPart.Builder {
        @Override
        DefaultPayloadPart build();
    }

    private static final class BuilderImpl extends PayloadPart.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultPayloadPart event) {
            super(event);
        }

        @Override
        public DefaultPayloadPart build() {
            return new DefaultPayloadPart(this);
        }
    }
}
