/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeEndpointWithResponseStreamResponse extends SageMakerRuntimeResponse implements
        ToCopyableBuilder<InvokeEndpointWithResponseStreamResponse.Builder, InvokeEndpointWithResponseStreamResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentType")
            .getter(getter(InvokeEndpointWithResponseStreamResponse::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Content-Type")
                    .build()).build();

    private static final SdkField<String> INVOKED_PRODUCTION_VARIANT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InvokedProductionVariant")
            .getter(getter(InvokeEndpointWithResponseStreamResponse::invokedProductionVariant))
            .setter(setter(Builder::invokedProductionVariant))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-Amzn-Invoked-Production-Variant")
                    .build()).build();

    private static final SdkField<String> CUSTOM_ATTRIBUTES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomAttributes")
            .getter(getter(InvokeEndpointWithResponseStreamResponse::customAttributes))
            .setter(setter(Builder::customAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Custom-Attributes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            INVOKED_PRODUCTION_VARIANT_FIELD, CUSTOM_ATTRIBUTES_FIELD));

    private final String contentType;

    private final String invokedProductionVariant;

    private final String customAttributes;

    private InvokeEndpointWithResponseStreamResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.invokedProductionVariant = builder.invokedProductionVariant;
        this.customAttributes = builder.customAttributes;
    }

    /**
     * <p>
     * The MIME type of the inference returned from the model container.
     * </p>
     * 
     * @return The MIME type of the inference returned from the model container.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Identifies the production variant that was invoked.
     * </p>
     * 
     * @return Identifies the production variant that was invoked.
     */
    public final String invokedProductionVariant() {
        return invokedProductionVariant;
    }

    /**
     * <p>
     * Provides additional information in the response about the inference returned by a model hosted at an Amazon
     * SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value, for
     * example, to return an ID received in the <code>CustomAttributes</code> header of a request or other metadata that
     * a service endpoint was programmed to produce. The value must consist of no more than 1024 visible US-ASCII
     * characters as specified in <a href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value
     * Components</a> of the Hypertext Transfer Protocol (HTTP/1.1). If the customer wants the custom attribute
     * returned, the model must set the custom attribute to be included on the way back.
     * </p>
     * <p>
     * The code in your model is responsible for setting or updating any custom attributes in the response. If your code
     * does not set this value in the response, an empty value is returned. For example, if a custom attribute
     * represents the trace ID, your model can prepend the custom attribute with <code>Trace ID:</code> in your
     * post-processing function.
     * </p>
     * <p>
     * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python SDK.
     * </p>
     * 
     * @return Provides additional information in the response about the inference returned by a model hosted at an
     *         Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use
     *         this value, for example, to return an ID received in the <code>CustomAttributes</code> header of a
     *         request or other metadata that a service endpoint was programmed to produce. The value must consist of no
     *         more than 1024 visible US-ASCII characters as specified in <a
     *         href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the
     *         Hypertext Transfer Protocol (HTTP/1.1). If the customer wants the custom attribute returned, the model
     *         must set the custom attribute to be included on the way back. </p>
     *         <p>
     *         The code in your model is responsible for setting or updating any custom attributes in the response. If
     *         your code does not set this value in the response, an empty value is returned. For example, if a custom
     *         attribute represents the trace ID, your model can prepend the custom attribute with
     *         <code>Trace ID:</code> in your post-processing function.
     *         </p>
     *         <p>
     *         This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker
     *         Python SDK.
     */
    public final String customAttributes() {
        return customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(invokedProductionVariant());
        hashCode = 31 * hashCode + Objects.hashCode(customAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointWithResponseStreamResponse)) {
            return false;
        }
        InvokeEndpointWithResponseStreamResponse other = (InvokeEndpointWithResponseStreamResponse) obj;
        return Objects.equals(contentType(), other.contentType())
                && Objects.equals(invokedProductionVariant(), other.invokedProductionVariant())
                && Objects.equals(customAttributes(), other.customAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeEndpointWithResponseStreamResponse").add("ContentType", contentType())
                .add("InvokedProductionVariant", invokedProductionVariant())
                .add("CustomAttributes", customAttributes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "InvokedProductionVariant":
            return Optional.ofNullable(clazz.cast(invokedProductionVariant()));
        case "CustomAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointWithResponseStreamResponse, T> g) {
        return obj -> g.apply((InvokeEndpointWithResponseStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeEndpointWithResponseStreamResponse> {
        /**
         * <p>
         * The MIME type of the inference returned from the model container.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the inference returned from the model container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Identifies the production variant that was invoked.
         * </p>
         * 
         * @param invokedProductionVariant
         *        Identifies the production variant that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedProductionVariant(String invokedProductionVariant);

        /**
         * <p>
         * Provides additional information in the response about the inference returned by a model hosted at an Amazon
         * SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could use this value,
         * for example, to return an ID received in the <code>CustomAttributes</code> header of a request or other
         * metadata that a service endpoint was programmed to produce. The value must consist of no more than 1024
         * visible US-ASCII characters as specified in <a
         * href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of the
         * Hypertext Transfer Protocol (HTTP/1.1). If the customer wants the custom attribute returned, the model must
         * set the custom attribute to be included on the way back.
         * </p>
         * <p>
         * The code in your model is responsible for setting or updating any custom attributes in the response. If your
         * code does not set this value in the response, an empty value is returned. For example, if a custom attribute
         * represents the trace ID, your model can prepend the custom attribute with <code>Trace ID:</code> in your
         * post-processing function.
         * </p>
         * <p>
         * This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker Python
         * SDK.
         * </p>
         * 
         * @param customAttributes
         *        Provides additional information in the response about the inference returned by a model hosted at an
         *        Amazon SageMaker endpoint. The information is an opaque value that is forwarded verbatim. You could
         *        use this value, for example, to return an ID received in the <code>CustomAttributes</code> header of a
         *        request or other metadata that a service endpoint was programmed to produce. The value must consist of
         *        no more than 1024 visible US-ASCII characters as specified in <a
         *        href="https://tools.ietf.org/html/rfc7230#section-3.2.6">Section 3.3.6. Field Value Components</a> of
         *        the Hypertext Transfer Protocol (HTTP/1.1). If the customer wants the custom attribute returned, the
         *        model must set the custom attribute to be included on the way back. </p>
         *        <p>
         *        The code in your model is responsible for setting or updating any custom attributes in the response.
         *        If your code does not set this value in the response, an empty value is returned. For example, if a
         *        custom attribute represents the trace ID, your model can prepend the custom attribute with
         *        <code>Trace ID:</code> in your post-processing function.
         *        </p>
         *        <p>
         *        This feature is currently supported in the Amazon Web Services SDKs but not in the Amazon SageMaker
         *        Python SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(String customAttributes);
    }

    static final class BuilderImpl extends SageMakerRuntimeResponse.BuilderImpl implements Builder {
        private String contentType;

        private String invokedProductionVariant;

        private String customAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointWithResponseStreamResponse model) {
            super(model);
            contentType(model.contentType);
            invokedProductionVariant(model.invokedProductionVariant);
            customAttributes(model.customAttributes);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getInvokedProductionVariant() {
            return invokedProductionVariant;
        }

        public final void setInvokedProductionVariant(String invokedProductionVariant) {
            this.invokedProductionVariant = invokedProductionVariant;
        }

        @Override
        public final Builder invokedProductionVariant(String invokedProductionVariant) {
            this.invokedProductionVariant = invokedProductionVariant;
            return this;
        }

        public final String getCustomAttributes() {
            return customAttributes;
        }

        public final void setCustomAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
        }

        @Override
        public final Builder customAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @Override
        public InvokeEndpointWithResponseStreamResponse build() {
            return new InvokeEndpointWithResponseStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
