/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialAsyncClient;
import software.amazon.awssdk.services.sagemakergeospatial.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse;

public class ListVectorEnrichmentJobsPublisher
implements SdkPublisher<ListVectorEnrichmentJobsResponse> {
    private final SageMakerGeospatialAsyncClient client;
    private final ListVectorEnrichmentJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVectorEnrichmentJobsPublisher(SageMakerGeospatialAsyncClient client, ListVectorEnrichmentJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVectorEnrichmentJobsPublisher(SageMakerGeospatialAsyncClient client, ListVectorEnrichmentJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVectorEnrichmentJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVectorEnrichmentJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListVectorEnrichmentJobOutputConfig> vectorEnrichmentJobSummaries() {
        Function<ListVectorEnrichmentJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.vectorEnrichmentJobSummaries() != null) {
                return response.vectorEnrichmentJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVectorEnrichmentJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVectorEnrichmentJobsResponseFetcher
    implements AsyncPageFetcher<ListVectorEnrichmentJobsResponse> {
        private ListVectorEnrichmentJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListVectorEnrichmentJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVectorEnrichmentJobsResponse> nextPage(ListVectorEnrichmentJobsResponse previousPage) {
            if (previousPage == null) {
                return ListVectorEnrichmentJobsPublisher.this.client.listVectorEnrichmentJobs(ListVectorEnrichmentJobsPublisher.this.firstRequest);
            }
            return ListVectorEnrichmentJobsPublisher.this.client.listVectorEnrichmentJobs((ListVectorEnrichmentJobsRequest)((Object)ListVectorEnrichmentJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

