/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakergeospatial.model.OutputType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputBand
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputBand> {
    private static final SdkField<String> BAND_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BandName").getter(OutputBand.getter(OutputBand::bandName)).setter(OutputBand.setter(Builder::bandName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandName").build()}).build();
    private static final SdkField<String> OUTPUT_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputDataType").getter(OutputBand.getter(OutputBand::outputDataTypeAsString)).setter(OutputBand.setter(Builder::outputDataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BAND_NAME_FIELD, OUTPUT_DATA_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bandName;
    private final String outputDataType;

    private OutputBand(BuilderImpl builder) {
        this.bandName = builder.bandName;
        this.outputDataType = builder.outputDataType;
    }

    public final String bandName() {
        return this.bandName;
    }

    public final OutputType outputDataType() {
        return OutputType.fromValue(this.outputDataType);
    }

    public final String outputDataTypeAsString() {
        return this.outputDataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bandName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputBand)) {
            return false;
        }
        OutputBand other = (OutputBand)obj;
        return Objects.equals(this.bandName(), other.bandName()) && Objects.equals(this.outputDataTypeAsString(), other.outputDataTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OutputBand").add("BandName", (Object)this.bandName()).add("OutputDataType", (Object)this.outputDataTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BandName": {
                return Optional.ofNullable(clazz.cast(this.bandName()));
            }
            case "OutputDataType": {
                return Optional.ofNullable(clazz.cast(this.outputDataTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputBand, T> g) {
        return obj -> g.apply((OutputBand)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bandName;
        private String outputDataType;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputBand model) {
            this.bandName(model.bandName);
            this.outputDataType(model.outputDataType);
        }

        public final String getBandName() {
            return this.bandName;
        }

        public final void setBandName(String bandName) {
            this.bandName = bandName;
        }

        @Override
        public final Builder bandName(String bandName) {
            this.bandName = bandName;
            return this;
        }

        public final String getOutputDataType() {
            return this.outputDataType;
        }

        public final void setOutputDataType(String outputDataType) {
            this.outputDataType = outputDataType;
        }

        @Override
        public final Builder outputDataType(String outputDataType) {
            this.outputDataType = outputDataType;
            return this;
        }

        @Override
        public final Builder outputDataType(OutputType outputDataType) {
            this.outputDataType(outputDataType == null ? null : outputDataType.toString());
            return this;
        }

        public OutputBand build() {
            return new OutputBand(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputBand> {
        public Builder bandName(String var1);

        public Builder outputDataType(String var1);

        public Builder outputDataType(OutputType var1);
    }
}

