/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTileRequest extends SageMakerGeospatialRequest implements
        ToCopyableBuilder<GetTileRequest.Builder, GetTileRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetTileRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Arn").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(GetTileRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ExecutionRoleArn").build())
            .build();

    private static final SdkField<List<String>> IMAGE_ASSETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ImageAssets")
            .getter(getter(GetTileRequest::imageAssets))
            .setter(setter(Builder::imageAssets))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ImageAssets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IMAGE_MASK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ImageMask").getter(getter(GetTileRequest::imageMask)).setter(setter(Builder::imageMask))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ImageMask").build()).build();

    private static final SdkField<String> OUTPUT_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputDataType").getter(getter(GetTileRequest::outputDataTypeAsString))
            .setter(setter(Builder::outputDataType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OutputDataType").build())
            .build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat").getter(getter(GetTileRequest::outputFormat)).setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OutputFormat").build()).build();

    private static final SdkField<String> PROPERTY_FILTERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyFilters").getter(getter(GetTileRequest::propertyFilters))
            .setter(setter(Builder::propertyFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PropertyFilters").build())
            .build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(GetTileRequest::targetAsString)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Target").build()).build();

    private static final SdkField<String> TIME_RANGE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeRangeFilter").getter(getter(GetTileRequest::timeRangeFilter))
            .setter(setter(Builder::timeRangeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TimeRangeFilter").build())
            .build();

    private static final SdkField<Integer> X_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("x")
            .getter(getter(GetTileRequest::x)).setter(setter(Builder::x))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("x").build()).build();

    private static final SdkField<Integer> Y_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("y")
            .getter(getter(GetTileRequest::y)).setter(setter(Builder::y))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("y").build()).build();

    private static final SdkField<Integer> Z_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("z")
            .getter(getter(GetTileRequest::z)).setter(setter(Builder::z))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("z").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            EXECUTION_ROLE_ARN_FIELD, IMAGE_ASSETS_FIELD, IMAGE_MASK_FIELD, OUTPUT_DATA_TYPE_FIELD, OUTPUT_FORMAT_FIELD,
            PROPERTY_FILTERS_FIELD, TARGET_FIELD, TIME_RANGE_FILTER_FIELD, X_FIELD, Y_FIELD, Z_FIELD));

    private final String arn;

    private final String executionRoleArn;

    private final List<String> imageAssets;

    private final Boolean imageMask;

    private final String outputDataType;

    private final String outputFormat;

    private final String propertyFilters;

    private final String target;

    private final String timeRangeFilter;

    private final Integer x;

    private final Integer y;

    private final Integer z;

    private GetTileRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.executionRoleArn = builder.executionRoleArn;
        this.imageAssets = builder.imageAssets;
        this.imageMask = builder.imageMask;
        this.outputDataType = builder.outputDataType;
        this.outputFormat = builder.outputFormat;
        this.propertyFilters = builder.propertyFilters;
        this.target = builder.target;
        this.timeRangeFilter = builder.timeRangeFilter;
        this.x = builder.x;
        this.y = builder.y;
        this.z = builder.z;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the tile operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the tile operation.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that you specify.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that you specify.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageAssets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageAssets() {
        return imageAssets != null && !(imageAssets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The particular assets or bands to tile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageAssets} method.
     * </p>
     * 
     * @return The particular assets or bands to tile.
     */
    public final List<String> imageAssets() {
        return imageAssets;
    }

    /**
     * <p>
     * Determines whether or not to return a valid data mask.
     * </p>
     * 
     * @return Determines whether or not to return a valid data mask.
     */
    public final Boolean imageMask() {
        return imageMask;
    }

    /**
     * <p>
     * The output data type of the tile operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputDataType}
     * will return {@link OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputDataTypeAsString}.
     * </p>
     * 
     * @return The output data type of the tile operation.
     * @see OutputType
     */
    public final OutputType outputDataType() {
        return OutputType.fromValue(outputDataType);
    }

    /**
     * <p>
     * The output data type of the tile operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputDataType}
     * will return {@link OutputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputDataTypeAsString}.
     * </p>
     * 
     * @return The output data type of the tile operation.
     * @see OutputType
     */
    public final String outputDataTypeAsString() {
        return outputDataType;
    }

    /**
     * <p>
     * The data format of the output tile. The formats include .npy, .png and .jpg.
     * </p>
     * 
     * @return The data format of the output tile. The formats include .npy, .png and .jpg.
     */
    public final String outputFormat() {
        return outputFormat;
    }

    /**
     * <p>
     * Property filters for the imagery to tile.
     * </p>
     * 
     * @return Property filters for the imagery to tile.
     */
    public final String propertyFilters() {
        return propertyFilters;
    }

    /**
     * <p>
     * Determines what part of the Earth Observation job to tile. 'INPUT' or 'OUTPUT' are the valid options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link TargetOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return Determines what part of the Earth Observation job to tile. 'INPUT' or 'OUTPUT' are the valid options.
     * @see TargetOptions
     */
    public final TargetOptions target() {
        return TargetOptions.fromValue(target);
    }

    /**
     * <p>
     * Determines what part of the Earth Observation job to tile. 'INPUT' or 'OUTPUT' are the valid options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link TargetOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return Determines what part of the Earth Observation job to tile. 'INPUT' or 'OUTPUT' are the valid options.
     * @see TargetOptions
     */
    public final String targetAsString() {
        return target;
    }

    /**
     * <p>
     * Time range filter applied to imagery to find the images to tile.
     * </p>
     * 
     * @return Time range filter applied to imagery to find the images to tile.
     */
    public final String timeRangeFilter() {
        return timeRangeFilter;
    }

    /**
     * <p>
     * The x coordinate of the tile input.
     * </p>
     * 
     * @return The x coordinate of the tile input.
     */
    public final Integer x() {
        return x;
    }

    /**
     * <p>
     * The y coordinate of the tile input.
     * </p>
     * 
     * @return The y coordinate of the tile input.
     */
    public final Integer y() {
        return y;
    }

    /**
     * <p>
     * The z coordinate of the tile input.
     * </p>
     * 
     * @return The z coordinate of the tile input.
     */
    public final Integer z() {
        return z;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageAssets() ? imageAssets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageMask());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormat());
        hashCode = 31 * hashCode + Objects.hashCode(propertyFilters());
        hashCode = 31 * hashCode + Objects.hashCode(targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(x());
        hashCode = 31 * hashCode + Objects.hashCode(y());
        hashCode = 31 * hashCode + Objects.hashCode(z());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTileRequest)) {
            return false;
        }
        GetTileRequest other = (GetTileRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && hasImageAssets() == other.hasImageAssets() && Objects.equals(imageAssets(), other.imageAssets())
                && Objects.equals(imageMask(), other.imageMask())
                && Objects.equals(outputDataTypeAsString(), other.outputDataTypeAsString())
                && Objects.equals(outputFormat(), other.outputFormat())
                && Objects.equals(propertyFilters(), other.propertyFilters())
                && Objects.equals(targetAsString(), other.targetAsString())
                && Objects.equals(timeRangeFilter(), other.timeRangeFilter()) && Objects.equals(x(), other.x())
                && Objects.equals(y(), other.y()) && Objects.equals(z(), other.z());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTileRequest").add("Arn", arn()).add("ExecutionRoleArn", executionRoleArn())
                .add("ImageAssets", hasImageAssets() ? imageAssets() : null).add("ImageMask", imageMask())
                .add("OutputDataType", outputDataTypeAsString()).add("OutputFormat", outputFormat())
                .add("PropertyFilters", propertyFilters()).add("Target", targetAsString())
                .add("TimeRangeFilter", timeRangeFilter()).add("X", x()).add("Y", y()).add("Z", z()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "ImageAssets":
            return Optional.ofNullable(clazz.cast(imageAssets()));
        case "ImageMask":
            return Optional.ofNullable(clazz.cast(imageMask()));
        case "OutputDataType":
            return Optional.ofNullable(clazz.cast(outputDataTypeAsString()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormat()));
        case "PropertyFilters":
            return Optional.ofNullable(clazz.cast(propertyFilters()));
        case "Target":
            return Optional.ofNullable(clazz.cast(targetAsString()));
        case "TimeRangeFilter":
            return Optional.ofNullable(clazz.cast(timeRangeFilter()));
        case "x":
            return Optional.ofNullable(clazz.cast(x()));
        case "y":
            return Optional.ofNullable(clazz.cast(y()));
        case "z":
            return Optional.ofNullable(clazz.cast(z()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTileRequest, T> g) {
        return obj -> g.apply((GetTileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerGeospatialRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTileRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the tile operation.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the tile operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that you specify.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The particular assets or bands to tile.
         * </p>
         * 
         * @param imageAssets
         *        The particular assets or bands to tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageAssets(Collection<String> imageAssets);

        /**
         * <p>
         * The particular assets or bands to tile.
         * </p>
         * 
         * @param imageAssets
         *        The particular assets or bands to tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageAssets(String... imageAssets);

        /**
         * <p>
         * Determines whether or not to return a valid data mask.
         * </p>
         * 
         * @param imageMask
         *        Determines whether or not to return a valid data mask.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageMask(Boolean imageMask);

        /**
         * <p>
         * The output data type of the tile operation.
         * </p>
         * 
         * @param outputDataType
         *        The output data type of the tile operation.
         * @see OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputType
         */
        Builder outputDataType(String outputDataType);

        /**
         * <p>
         * The output data type of the tile operation.
         * </p>
         * 
         * @param outputDataType
         *        The output data type of the tile operation.
         * @see OutputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputType
         */
        Builder outputDataType(OutputType outputDataType);

        /**
         * <p>
         * The data format of the output tile. The formats include .npy, .png and .jpg.
         * </p>
         * 
         * @param outputFormat
         *        The data format of the output tile. The formats include .npy, .png and .jpg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * Property filters for the imagery to tile.
         * </p>
         * 
         * @param propertyFilters
         *        Property filters for the imagery to tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyFilters(String propertyFilters);

        /**
         * <p>
         * Determines what part of the Earth Observation job to tile. 'INPUT' or 'OUTPUT' are the valid options.
         * </p>
         * 
         * @param target
         *        Determines what part of the Earth Observation job to tile. 'INPUT' or 'OUTPUT' are the valid options.
         * @see TargetOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetOptions
         */
        Builder target(String target);

        /**
         * <p>
         * Determines what part of the Earth Observation job to tile. 'INPUT' or 'OUTPUT' are the valid options.
         * </p>
         * 
         * @param target
         *        Determines what part of the Earth Observation job to tile. 'INPUT' or 'OUTPUT' are the valid options.
         * @see TargetOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetOptions
         */
        Builder target(TargetOptions target);

        /**
         * <p>
         * Time range filter applied to imagery to find the images to tile.
         * </p>
         * 
         * @param timeRangeFilter
         *        Time range filter applied to imagery to find the images to tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeFilter(String timeRangeFilter);

        /**
         * <p>
         * The x coordinate of the tile input.
         * </p>
         * 
         * @param x
         *        The x coordinate of the tile input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x(Integer x);

        /**
         * <p>
         * The y coordinate of the tile input.
         * </p>
         * 
         * @param y
         *        The y coordinate of the tile input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder y(Integer y);

        /**
         * <p>
         * The z coordinate of the tile input.
         * </p>
         * 
         * @param z
         *        The z coordinate of the tile input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder z(Integer z);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerGeospatialRequest.BuilderImpl implements Builder {
        private String arn;

        private String executionRoleArn;

        private List<String> imageAssets = DefaultSdkAutoConstructList.getInstance();

        private Boolean imageMask;

        private String outputDataType;

        private String outputFormat;

        private String propertyFilters;

        private String target;

        private String timeRangeFilter;

        private Integer x;

        private Integer y;

        private Integer z;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTileRequest model) {
            super(model);
            arn(model.arn);
            executionRoleArn(model.executionRoleArn);
            imageAssets(model.imageAssets);
            imageMask(model.imageMask);
            outputDataType(model.outputDataType);
            outputFormat(model.outputFormat);
            propertyFilters(model.propertyFilters);
            target(model.target);
            timeRangeFilter(model.timeRangeFilter);
            x(model.x);
            y(model.y);
            z(model.z);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Collection<String> getImageAssets() {
            if (imageAssets instanceof SdkAutoConstructList) {
                return null;
            }
            return imageAssets;
        }

        public final void setImageAssets(Collection<String> imageAssets) {
            this.imageAssets = StringListInputCopier.copy(imageAssets);
        }

        @Override
        public final Builder imageAssets(Collection<String> imageAssets) {
            this.imageAssets = StringListInputCopier.copy(imageAssets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageAssets(String... imageAssets) {
            imageAssets(Arrays.asList(imageAssets));
            return this;
        }

        public final Boolean getImageMask() {
            return imageMask;
        }

        public final void setImageMask(Boolean imageMask) {
            this.imageMask = imageMask;
        }

        @Override
        public final Builder imageMask(Boolean imageMask) {
            this.imageMask = imageMask;
            return this;
        }

        public final String getOutputDataType() {
            return outputDataType;
        }

        public final void setOutputDataType(String outputDataType) {
            this.outputDataType = outputDataType;
        }

        @Override
        public final Builder outputDataType(String outputDataType) {
            this.outputDataType = outputDataType;
            return this;
        }

        @Override
        public final Builder outputDataType(OutputType outputDataType) {
            this.outputDataType(outputDataType == null ? null : outputDataType.toString());
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public final String getPropertyFilters() {
            return propertyFilters;
        }

        public final void setPropertyFilters(String propertyFilters) {
            this.propertyFilters = propertyFilters;
        }

        @Override
        public final Builder propertyFilters(String propertyFilters) {
            this.propertyFilters = propertyFilters;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(TargetOptions target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final String getTimeRangeFilter() {
            return timeRangeFilter;
        }

        public final void setTimeRangeFilter(String timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
        }

        @Override
        public final Builder timeRangeFilter(String timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        public final Integer getX() {
            return x;
        }

        public final void setX(Integer x) {
            this.x = x;
        }

        @Override
        public final Builder x(Integer x) {
            this.x = x;
            return this;
        }

        public final Integer getY() {
            return y;
        }

        public final void setY(Integer y) {
            this.y = y;
        }

        @Override
        public final Builder y(Integer y) {
            this.y = y;
            return this;
        }

        public final Integer getZ() {
            return z;
        }

        public final void setZ(Integer z) {
            this.z = z;
        }

        @Override
        public final Builder z(Integer z) {
            this.z = z;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTileRequest build() {
            return new GetTileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
