/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInferenceExperimentRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateInferenceExperimentRequest.Builder, UpdateInferenceExperimentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateInferenceExperimentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<InferenceExperimentSchedule> SCHEDULE_FIELD = SdkField
            .<InferenceExperimentSchedule> builder(MarshallingType.SDK_POJO).memberName("Schedule")
            .getter(getter(UpdateInferenceExperimentRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(InferenceExperimentSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateInferenceExperimentRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<ModelVariantConfig>> MODEL_VARIANTS_FIELD = SdkField
            .<List<ModelVariantConfig>> builder(MarshallingType.LIST)
            .memberName("ModelVariants")
            .getter(getter(UpdateInferenceExperimentRequest::modelVariants))
            .setter(setter(Builder::modelVariants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVariants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVariantConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVariantConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InferenceExperimentDataStorageConfig> DATA_STORAGE_CONFIG_FIELD = SdkField
            .<InferenceExperimentDataStorageConfig> builder(MarshallingType.SDK_POJO).memberName("DataStorageConfig")
            .getter(getter(UpdateInferenceExperimentRequest::dataStorageConfig)).setter(setter(Builder::dataStorageConfig))
            .constructor(InferenceExperimentDataStorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorageConfig").build()).build();

    private static final SdkField<ShadowModeConfig> SHADOW_MODE_CONFIG_FIELD = SdkField
            .<ShadowModeConfig> builder(MarshallingType.SDK_POJO).memberName("ShadowModeConfig")
            .getter(getter(UpdateInferenceExperimentRequest::shadowModeConfig)).setter(setter(Builder::shadowModeConfig))
            .constructor(ShadowModeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowModeConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCHEDULE_FIELD,
            DESCRIPTION_FIELD, MODEL_VARIANTS_FIELD, DATA_STORAGE_CONFIG_FIELD, SHADOW_MODE_CONFIG_FIELD));

    private final String name;

    private final InferenceExperimentSchedule schedule;

    private final String description;

    private final List<ModelVariantConfig> modelVariants;

    private final InferenceExperimentDataStorageConfig dataStorageConfig;

    private final ShadowModeConfig shadowModeConfig;

    private UpdateInferenceExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.description = builder.description;
        this.modelVariants = builder.modelVariants;
        this.dataStorageConfig = builder.dataStorageConfig;
        this.shadowModeConfig = builder.shadowModeConfig;
    }

    /**
     * <p>
     * The name of the inference experiment to be updated.
     * </p>
     * 
     * @return The name of the inference experiment to be updated.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The duration for which the inference experiment will run. If the status of the inference experiment is
     * <code>Created</code>, then you can update both the start and end dates. If the status of the inference experiment
     * is <code>Running</code>, then you can update only the end date.
     * </p>
     * 
     * @return The duration for which the inference experiment will run. If the status of the inference experiment is
     *         <code>Created</code>, then you can update both the start and end dates. If the status of the inference
     *         experiment is <code>Running</code>, then you can update only the end date.
     */
    public final InferenceExperimentSchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The description of the inference experiment.
     * </p>
     * 
     * @return The description of the inference experiment.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelVariants property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelVariants() {
        return modelVariants != null && !(modelVariants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ModelVariantConfig</code> objects. There is one for each variant, whose infrastructure
     * configuration you want to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelVariants} method.
     * </p>
     * 
     * @return An array of <code>ModelVariantConfig</code> objects. There is one for each variant, whose infrastructure
     *         configuration you want to update.
     */
    public final List<ModelVariantConfig> modelVariants() {
        return modelVariants;
    }

    /**
     * <p>
     * The Amazon S3 location and configuration for storing inference request and response data.
     * </p>
     * 
     * @return The Amazon S3 location and configuration for storing inference request and response data.
     */
    public final InferenceExperimentDataStorageConfig dataStorageConfig() {
        return dataStorageConfig;
    }

    /**
     * <p>
     * The configuration of <code>ShadowMode</code> inference experiment type. Use this field to specify a production
     * variant which takes all the inference requests, and a shadow variant to which Amazon SageMaker replicates a
     * percentage of the inference requests. For the shadow variant also specify the percentage of requests that Amazon
     * SageMaker replicates.
     * </p>
     * 
     * @return The configuration of <code>ShadowMode</code> inference experiment type. Use this field to specify a
     *         production variant which takes all the inference requests, and a shadow variant to which Amazon SageMaker
     *         replicates a percentage of the inference requests. For the shadow variant also specify the percentage of
     *         requests that Amazon SageMaker replicates.
     */
    public final ShadowModeConfig shadowModeConfig() {
        return shadowModeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelVariants() ? modelVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(shadowModeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInferenceExperimentRequest)) {
            return false;
        }
        UpdateInferenceExperimentRequest other = (UpdateInferenceExperimentRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(description(), other.description()) && hasModelVariants() == other.hasModelVariants()
                && Objects.equals(modelVariants(), other.modelVariants())
                && Objects.equals(dataStorageConfig(), other.dataStorageConfig())
                && Objects.equals(shadowModeConfig(), other.shadowModeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInferenceExperimentRequest").add("Name", name()).add("Schedule", schedule())
                .add("Description", description()).add("ModelVariants", hasModelVariants() ? modelVariants() : null)
                .add("DataStorageConfig", dataStorageConfig()).add("ShadowModeConfig", shadowModeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ModelVariants":
            return Optional.ofNullable(clazz.cast(modelVariants()));
        case "DataStorageConfig":
            return Optional.ofNullable(clazz.cast(dataStorageConfig()));
        case "ShadowModeConfig":
            return Optional.ofNullable(clazz.cast(shadowModeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInferenceExperimentRequest, T> g) {
        return obj -> g.apply((UpdateInferenceExperimentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInferenceExperimentRequest> {
        /**
         * <p>
         * The name of the inference experiment to be updated.
         * </p>
         * 
         * @param name
         *        The name of the inference experiment to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The duration for which the inference experiment will run. If the status of the inference experiment is
         * <code>Created</code>, then you can update both the start and end dates. If the status of the inference
         * experiment is <code>Running</code>, then you can update only the end date.
         * </p>
         * 
         * @param schedule
         *        The duration for which the inference experiment will run. If the status of the inference experiment is
         *        <code>Created</code>, then you can update both the start and end dates. If the status of the inference
         *        experiment is <code>Running</code>, then you can update only the end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(InferenceExperimentSchedule schedule);

        /**
         * <p>
         * The duration for which the inference experiment will run. If the status of the inference experiment is
         * <code>Created</code>, then you can update both the start and end dates. If the status of the inference
         * experiment is <code>Running</code>, then you can update only the end date.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceExperimentSchedule.Builder}
         * avoiding the need to create one manually via {@link InferenceExperimentSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceExperimentSchedule.Builder#build()} is called
         * immediately and its result is passed to {@link #schedule(InferenceExperimentSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link InferenceExperimentSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(InferenceExperimentSchedule)
         */
        default Builder schedule(Consumer<InferenceExperimentSchedule.Builder> schedule) {
            return schedule(InferenceExperimentSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The description of the inference experiment.
         * </p>
         * 
         * @param description
         *        The description of the inference experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of <code>ModelVariantConfig</code> objects. There is one for each variant, whose infrastructure
         * configuration you want to update.
         * </p>
         * 
         * @param modelVariants
         *        An array of <code>ModelVariantConfig</code> objects. There is one for each variant, whose
         *        infrastructure configuration you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariants(Collection<ModelVariantConfig> modelVariants);

        /**
         * <p>
         * An array of <code>ModelVariantConfig</code> objects. There is one for each variant, whose infrastructure
         * configuration you want to update.
         * </p>
         * 
         * @param modelVariants
         *        An array of <code>ModelVariantConfig</code> objects. There is one for each variant, whose
         *        infrastructure configuration you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVariants(ModelVariantConfig... modelVariants);

        /**
         * <p>
         * An array of <code>ModelVariantConfig</code> objects. There is one for each variant, whose infrastructure
         * configuration you want to update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #modelVariants(List<ModelVariantConfig>)}.
         * 
         * @param modelVariants
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVariants(java.util.Collection<ModelVariantConfig>)
         */
        Builder modelVariants(Consumer<ModelVariantConfig.Builder>... modelVariants);

        /**
         * <p>
         * The Amazon S3 location and configuration for storing inference request and response data.
         * </p>
         * 
         * @param dataStorageConfig
         *        The Amazon S3 location and configuration for storing inference request and response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorageConfig(InferenceExperimentDataStorageConfig dataStorageConfig);

        /**
         * <p>
         * The Amazon S3 location and configuration for storing inference request and response data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceExperimentDataStorageConfig.Builder} avoiding the need to create one manually via
         * {@link InferenceExperimentDataStorageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceExperimentDataStorageConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #dataStorageConfig(InferenceExperimentDataStorageConfig)}.
         * 
         * @param dataStorageConfig
         *        a consumer that will call methods on {@link InferenceExperimentDataStorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataStorageConfig(InferenceExperimentDataStorageConfig)
         */
        default Builder dataStorageConfig(Consumer<InferenceExperimentDataStorageConfig.Builder> dataStorageConfig) {
            return dataStorageConfig(InferenceExperimentDataStorageConfig.builder().applyMutation(dataStorageConfig).build());
        }

        /**
         * <p>
         * The configuration of <code>ShadowMode</code> inference experiment type. Use this field to specify a
         * production variant which takes all the inference requests, and a shadow variant to which Amazon SageMaker
         * replicates a percentage of the inference requests. For the shadow variant also specify the percentage of
         * requests that Amazon SageMaker replicates.
         * </p>
         * 
         * @param shadowModeConfig
         *        The configuration of <code>ShadowMode</code> inference experiment type. Use this field to specify a
         *        production variant which takes all the inference requests, and a shadow variant to which Amazon
         *        SageMaker replicates a percentage of the inference requests. For the shadow variant also specify the
         *        percentage of requests that Amazon SageMaker replicates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowModeConfig(ShadowModeConfig shadowModeConfig);

        /**
         * <p>
         * The configuration of <code>ShadowMode</code> inference experiment type. Use this field to specify a
         * production variant which takes all the inference requests, and a shadow variant to which Amazon SageMaker
         * replicates a percentage of the inference requests. For the shadow variant also specify the percentage of
         * requests that Amazon SageMaker replicates.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShadowModeConfig.Builder} avoiding the
         * need to create one manually via {@link ShadowModeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShadowModeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #shadowModeConfig(ShadowModeConfig)}.
         * 
         * @param shadowModeConfig
         *        a consumer that will call methods on {@link ShadowModeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shadowModeConfig(ShadowModeConfig)
         */
        default Builder shadowModeConfig(Consumer<ShadowModeConfig.Builder> shadowModeConfig) {
            return shadowModeConfig(ShadowModeConfig.builder().applyMutation(shadowModeConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String name;

        private InferenceExperimentSchedule schedule;

        private String description;

        private List<ModelVariantConfig> modelVariants = DefaultSdkAutoConstructList.getInstance();

        private InferenceExperimentDataStorageConfig dataStorageConfig;

        private ShadowModeConfig shadowModeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInferenceExperimentRequest model) {
            super(model);
            name(model.name);
            schedule(model.schedule);
            description(model.description);
            modelVariants(model.modelVariants);
            dataStorageConfig(model.dataStorageConfig);
            shadowModeConfig(model.shadowModeConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InferenceExperimentSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(InferenceExperimentSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(InferenceExperimentSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ModelVariantConfig.Builder> getModelVariants() {
            List<ModelVariantConfig.Builder> result = ModelVariantConfigListCopier.copyToBuilder(this.modelVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVariants(Collection<ModelVariantConfig.BuilderImpl> modelVariants) {
            this.modelVariants = ModelVariantConfigListCopier.copyFromBuilder(modelVariants);
        }

        @Override
        public final Builder modelVariants(Collection<ModelVariantConfig> modelVariants) {
            this.modelVariants = ModelVariantConfigListCopier.copy(modelVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(ModelVariantConfig... modelVariants) {
            modelVariants(Arrays.asList(modelVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVariants(Consumer<ModelVariantConfig.Builder>... modelVariants) {
            modelVariants(Stream.of(modelVariants).map(c -> ModelVariantConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InferenceExperimentDataStorageConfig.Builder getDataStorageConfig() {
            return dataStorageConfig != null ? dataStorageConfig.toBuilder() : null;
        }

        public final void setDataStorageConfig(InferenceExperimentDataStorageConfig.BuilderImpl dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig != null ? dataStorageConfig.build() : null;
        }

        @Override
        public final Builder dataStorageConfig(InferenceExperimentDataStorageConfig dataStorageConfig) {
            this.dataStorageConfig = dataStorageConfig;
            return this;
        }

        public final ShadowModeConfig.Builder getShadowModeConfig() {
            return shadowModeConfig != null ? shadowModeConfig.toBuilder() : null;
        }

        public final void setShadowModeConfig(ShadowModeConfig.BuilderImpl shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig != null ? shadowModeConfig.build() : null;
        }

        @Override
        public final Builder shadowModeConfig(ShadowModeConfig shadowModeConfig) {
            this.shadowModeConfig = shadowModeConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInferenceExperimentRequest build() {
            return new UpdateInferenceExperimentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
