/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImageVersionRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateImageVersionRequest.Builder, UpdateImageVersionRequest> {
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(UpdateImageVersionRequest::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(UpdateImageVersionRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version").getter(getter(UpdateImageVersionRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<List<String>> ALIASES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AliasesToAdd")
            .getter(getter(UpdateImageVersionRequest::aliasesToAdd))
            .setter(setter(Builder::aliasesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALIASES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AliasesToDelete")
            .getter(getter(UpdateImageVersionRequest::aliasesToDelete))
            .setter(setter(Builder::aliasesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VENDOR_GUIDANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorGuidance").getter(getter(UpdateImageVersionRequest::vendorGuidanceAsString))
            .setter(setter(Builder::vendorGuidance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorGuidance").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(UpdateImageVersionRequest::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<String> ML_FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLFramework").getter(getter(UpdateImageVersionRequest::mlFramework))
            .setter(setter(Builder::mlFramework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLFramework").build()).build();

    private static final SdkField<String> PROGRAMMING_LANG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgrammingLang").getter(getter(UpdateImageVersionRequest::programmingLang))
            .setter(setter(Builder::programmingLang))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgrammingLang").build()).build();

    private static final SdkField<String> PROCESSOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Processor").getter(getter(UpdateImageVersionRequest::processorAsString))
            .setter(setter(Builder::processor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processor").build()).build();

    private static final SdkField<Boolean> HOROVOD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Horovod").getter(getter(UpdateImageVersionRequest::horovod)).setter(setter(Builder::horovod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Horovod").build()).build();

    private static final SdkField<String> RELEASE_NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReleaseNotes").getter(getter(UpdateImageVersionRequest::releaseNotes))
            .setter(setter(Builder::releaseNotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseNotes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_NAME_FIELD, ALIAS_FIELD,
            VERSION_FIELD, ALIASES_TO_ADD_FIELD, ALIASES_TO_DELETE_FIELD, VENDOR_GUIDANCE_FIELD, JOB_TYPE_FIELD,
            ML_FRAMEWORK_FIELD, PROGRAMMING_LANG_FIELD, PROCESSOR_FIELD, HOROVOD_FIELD, RELEASE_NOTES_FIELD));

    private final String imageName;

    private final String alias;

    private final Integer version;

    private final List<String> aliasesToAdd;

    private final List<String> aliasesToDelete;

    private final String vendorGuidance;

    private final String jobType;

    private final String mlFramework;

    private final String programmingLang;

    private final String processor;

    private final Boolean horovod;

    private final String releaseNotes;

    private UpdateImageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.imageName = builder.imageName;
        this.alias = builder.alias;
        this.version = builder.version;
        this.aliasesToAdd = builder.aliasesToAdd;
        this.aliasesToDelete = builder.aliasesToDelete;
        this.vendorGuidance = builder.vendorGuidance;
        this.jobType = builder.jobType;
        this.mlFramework = builder.mlFramework;
        this.programmingLang = builder.programmingLang;
        this.processor = builder.processor;
        this.horovod = builder.horovod;
        this.releaseNotes = builder.releaseNotes;
    }

    /**
     * <p>
     * The name of the image.
     * </p>
     * 
     * @return The name of the image.
     */
    public final String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The alias of the image version.
     * </p>
     * 
     * @return The alias of the image version.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The version of the image.
     * </p>
     * 
     * @return The version of the image.
     */
    public final Integer version() {
        return version;
    }

    /**
     * For responses, this returns true if the service returned a value for the AliasesToAdd property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAliasesToAdd() {
        return aliasesToAdd != null && !(aliasesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of aliases to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAliasesToAdd} method.
     * </p>
     * 
     * @return A list of aliases to add.
     */
    public final List<String> aliasesToAdd() {
        return aliasesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the AliasesToDelete property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAliasesToDelete() {
        return aliasesToDelete != null && !(aliasesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of aliases to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAliasesToDelete} method.
     * </p>
     * 
     * @return A list of aliases to delete.
     */
    public final List<String> aliasesToDelete() {
        return aliasesToDelete;
    }

    /**
     * <p>
     * The availability of the image version specified by the maintainer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STABLE</code>: The image version is stable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set to be
     * archived are automatically archived after three months.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are no
     * longer actively supported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vendorGuidance}
     * will return {@link VendorGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vendorGuidanceAsString}.
     * </p>
     * 
     * @return The availability of the image version specified by the maintainer.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STABLE</code>: The image version is stable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set
     *         to be archived are automatically archived after three months.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are
     *         no longer actively supported.
     *         </p>
     *         </li>
     * @see VendorGuidance
     */
    public final VendorGuidance vendorGuidance() {
        return VendorGuidance.fromValue(vendorGuidance);
    }

    /**
     * <p>
     * The availability of the image version specified by the maintainer.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STABLE</code>: The image version is stable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set to be
     * archived are automatically archived after three months.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are no
     * longer actively supported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vendorGuidance}
     * will return {@link VendorGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vendorGuidanceAsString}.
     * </p>
     * 
     * @return The availability of the image version specified by the maintainer.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STABLE</code>: The image version is stable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set
     *         to be archived are automatically archived after three months.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are
     *         no longer actively supported.
     *         </p>
     *         </li>
     * @see VendorGuidance
     */
    public final String vendorGuidanceAsString() {
        return vendorGuidance;
    }

    /**
     * <p>
     * Indicates SageMaker job type compatibility.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Indicates SageMaker job type compatibility.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * Indicates SageMaker job type compatibility.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return Indicates SageMaker job type compatibility.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The machine learning framework vended in the image version.
     * </p>
     * 
     * @return The machine learning framework vended in the image version.
     */
    public final String mlFramework() {
        return mlFramework;
    }

    /**
     * <p>
     * The supported programming language and its version.
     * </p>
     * 
     * @return The supported programming language and its version.
     */
    public final String programmingLang() {
        return programmingLang;
    }

    /**
     * <p>
     * Indicates CPU or GPU compatibility.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CPU</code>: The image version is compatible with CPU.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GPU</code>: The image version is compatible with GPU.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processor} will
     * return {@link Processor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #processorAsString}.
     * </p>
     * 
     * @return Indicates CPU or GPU compatibility.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CPU</code>: The image version is compatible with CPU.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GPU</code>: The image version is compatible with GPU.
     *         </p>
     *         </li>
     * @see Processor
     */
    public final Processor processor() {
        return Processor.fromValue(processor);
    }

    /**
     * <p>
     * Indicates CPU or GPU compatibility.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CPU</code>: The image version is compatible with CPU.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GPU</code>: The image version is compatible with GPU.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #processor} will
     * return {@link Processor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #processorAsString}.
     * </p>
     * 
     * @return Indicates CPU or GPU compatibility.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CPU</code>: The image version is compatible with CPU.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GPU</code>: The image version is compatible with GPU.
     *         </p>
     *         </li>
     * @see Processor
     */
    public final String processorAsString() {
        return processor;
    }

    /**
     * <p>
     * Indicates Horovod compatibility.
     * </p>
     * 
     * @return Indicates Horovod compatibility.
     */
    public final Boolean horovod() {
        return horovod;
    }

    /**
     * <p>
     * The maintainer description of the image version.
     * </p>
     * 
     * @return The maintainer description of the image version.
     */
    public final String releaseNotes() {
        return releaseNotes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasAliasesToAdd() ? aliasesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAliasesToDelete() ? aliasesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vendorGuidanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mlFramework());
        hashCode = 31 * hashCode + Objects.hashCode(programmingLang());
        hashCode = 31 * hashCode + Objects.hashCode(processorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(horovod());
        hashCode = 31 * hashCode + Objects.hashCode(releaseNotes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageVersionRequest)) {
            return false;
        }
        UpdateImageVersionRequest other = (UpdateImageVersionRequest) obj;
        return Objects.equals(imageName(), other.imageName()) && Objects.equals(alias(), other.alias())
                && Objects.equals(version(), other.version()) && hasAliasesToAdd() == other.hasAliasesToAdd()
                && Objects.equals(aliasesToAdd(), other.aliasesToAdd()) && hasAliasesToDelete() == other.hasAliasesToDelete()
                && Objects.equals(aliasesToDelete(), other.aliasesToDelete())
                && Objects.equals(vendorGuidanceAsString(), other.vendorGuidanceAsString())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(mlFramework(), other.mlFramework())
                && Objects.equals(programmingLang(), other.programmingLang())
                && Objects.equals(processorAsString(), other.processorAsString()) && Objects.equals(horovod(), other.horovod())
                && Objects.equals(releaseNotes(), other.releaseNotes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImageVersionRequest").add("ImageName", imageName()).add("Alias", alias())
                .add("Version", version()).add("AliasesToAdd", hasAliasesToAdd() ? aliasesToAdd() : null)
                .add("AliasesToDelete", hasAliasesToDelete() ? aliasesToDelete() : null)
                .add("VendorGuidance", vendorGuidanceAsString()).add("JobType", jobTypeAsString())
                .add("MLFramework", mlFramework()).add("ProgrammingLang", programmingLang())
                .add("Processor", processorAsString()).add("Horovod", horovod()).add("ReleaseNotes", releaseNotes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "AliasesToAdd":
            return Optional.ofNullable(clazz.cast(aliasesToAdd()));
        case "AliasesToDelete":
            return Optional.ofNullable(clazz.cast(aliasesToDelete()));
        case "VendorGuidance":
            return Optional.ofNullable(clazz.cast(vendorGuidanceAsString()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "MLFramework":
            return Optional.ofNullable(clazz.cast(mlFramework()));
        case "ProgrammingLang":
            return Optional.ofNullable(clazz.cast(programmingLang()));
        case "Processor":
            return Optional.ofNullable(clazz.cast(processorAsString()));
        case "Horovod":
            return Optional.ofNullable(clazz.cast(horovod()));
        case "ReleaseNotes":
            return Optional.ofNullable(clazz.cast(releaseNotes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageVersionRequest, T> g) {
        return obj -> g.apply((UpdateImageVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateImageVersionRequest> {
        /**
         * <p>
         * The name of the image.
         * </p>
         * 
         * @param imageName
         *        The name of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The alias of the image version.
         * </p>
         * 
         * @param alias
         *        The alias of the image version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The version of the image.
         * </p>
         * 
         * @param version
         *        The version of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * A list of aliases to add.
         * </p>
         * 
         * @param aliasesToAdd
         *        A list of aliases to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasesToAdd(Collection<String> aliasesToAdd);

        /**
         * <p>
         * A list of aliases to add.
         * </p>
         * 
         * @param aliasesToAdd
         *        A list of aliases to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasesToAdd(String... aliasesToAdd);

        /**
         * <p>
         * A list of aliases to delete.
         * </p>
         * 
         * @param aliasesToDelete
         *        A list of aliases to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasesToDelete(Collection<String> aliasesToDelete);

        /**
         * <p>
         * A list of aliases to delete.
         * </p>
         * 
         * @param aliasesToDelete
         *        A list of aliases to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasesToDelete(String... aliasesToDelete);

        /**
         * <p>
         * The availability of the image version specified by the maintainer.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STABLE</code>: The image version is stable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set to
         * be archived are automatically archived after three months.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are no
         * longer actively supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vendorGuidance
         *        The availability of the image version specified by the maintainer.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STABLE</code>: The image version is stable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are
         *        set to be archived are automatically archived after three months.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and
         *        are no longer actively supported.
         *        </p>
         *        </li>
         * @see VendorGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VendorGuidance
         */
        Builder vendorGuidance(String vendorGuidance);

        /**
         * <p>
         * The availability of the image version specified by the maintainer.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STABLE</code>: The image version is stable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are set to
         * be archived are automatically archived after three months.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and are no
         * longer actively supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vendorGuidance
         *        The availability of the image version specified by the maintainer.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOT_PROVIDED</code>: The maintainers did not provide a status for image version stability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STABLE</code>: The image version is stable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TO_BE_ARCHIVED</code>: The image version is set to be archived. Custom image versions that are
         *        set to be archived are automatically archived after three months.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARCHIVED</code>: The image version is archived. Archived image versions are not searchable and
         *        are no longer actively supported.
         *        </p>
         *        </li>
         * @see VendorGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VendorGuidance
         */
        Builder vendorGuidance(VendorGuidance vendorGuidance);

        /**
         * <p>
         * Indicates SageMaker job type compatibility.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        Indicates SageMaker job type compatibility.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * Indicates SageMaker job type compatibility.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        Indicates SageMaker job type compatibility.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TRAINING</code>: The image version is compatible with SageMaker training jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INFERENCE</code>: The image version is compatible with SageMaker inference jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOTEBOOK_KERNEL</code>: The image version is compatible with SageMaker notebook kernels.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * The machine learning framework vended in the image version.
         * </p>
         * 
         * @param mlFramework
         *        The machine learning framework vended in the image version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlFramework(String mlFramework);

        /**
         * <p>
         * The supported programming language and its version.
         * </p>
         * 
         * @param programmingLang
         *        The supported programming language and its version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programmingLang(String programmingLang);

        /**
         * <p>
         * Indicates CPU or GPU compatibility.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CPU</code>: The image version is compatible with CPU.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GPU</code>: The image version is compatible with GPU.
         * </p>
         * </li>
         * </ul>
         * 
         * @param processor
         *        Indicates CPU or GPU compatibility.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CPU</code>: The image version is compatible with CPU.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GPU</code>: The image version is compatible with GPU.
         *        </p>
         *        </li>
         * @see Processor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Processor
         */
        Builder processor(String processor);

        /**
         * <p>
         * Indicates CPU or GPU compatibility.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CPU</code>: The image version is compatible with CPU.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GPU</code>: The image version is compatible with GPU.
         * </p>
         * </li>
         * </ul>
         * 
         * @param processor
         *        Indicates CPU or GPU compatibility.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CPU</code>: The image version is compatible with CPU.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GPU</code>: The image version is compatible with GPU.
         *        </p>
         *        </li>
         * @see Processor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Processor
         */
        Builder processor(Processor processor);

        /**
         * <p>
         * Indicates Horovod compatibility.
         * </p>
         * 
         * @param horovod
         *        Indicates Horovod compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder horovod(Boolean horovod);

        /**
         * <p>
         * The maintainer description of the image version.
         * </p>
         * 
         * @param releaseNotes
         *        The maintainer description of the image version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseNotes(String releaseNotes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String imageName;

        private String alias;

        private Integer version;

        private List<String> aliasesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> aliasesToDelete = DefaultSdkAutoConstructList.getInstance();

        private String vendorGuidance;

        private String jobType;

        private String mlFramework;

        private String programmingLang;

        private String processor;

        private Boolean horovod;

        private String releaseNotes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageVersionRequest model) {
            super(model);
            imageName(model.imageName);
            alias(model.alias);
            version(model.version);
            aliasesToAdd(model.aliasesToAdd);
            aliasesToDelete(model.aliasesToDelete);
            vendorGuidance(model.vendorGuidance);
            jobType(model.jobType);
            mlFramework(model.mlFramework);
            programmingLang(model.programmingLang);
            processor(model.processor);
            horovod(model.horovod);
            releaseNotes(model.releaseNotes);
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getAliasesToAdd() {
            if (aliasesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return aliasesToAdd;
        }

        public final void setAliasesToAdd(Collection<String> aliasesToAdd) {
            this.aliasesToAdd = SageMakerImageVersionAliasesCopier.copy(aliasesToAdd);
        }

        @Override
        public final Builder aliasesToAdd(Collection<String> aliasesToAdd) {
            this.aliasesToAdd = SageMakerImageVersionAliasesCopier.copy(aliasesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasesToAdd(String... aliasesToAdd) {
            aliasesToAdd(Arrays.asList(aliasesToAdd));
            return this;
        }

        public final Collection<String> getAliasesToDelete() {
            if (aliasesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return aliasesToDelete;
        }

        public final void setAliasesToDelete(Collection<String> aliasesToDelete) {
            this.aliasesToDelete = SageMakerImageVersionAliasesCopier.copy(aliasesToDelete);
        }

        @Override
        public final Builder aliasesToDelete(Collection<String> aliasesToDelete) {
            this.aliasesToDelete = SageMakerImageVersionAliasesCopier.copy(aliasesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasesToDelete(String... aliasesToDelete) {
            aliasesToDelete(Arrays.asList(aliasesToDelete));
            return this;
        }

        public final String getVendorGuidance() {
            return vendorGuidance;
        }

        public final void setVendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
        }

        @Override
        public final Builder vendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
            return this;
        }

        @Override
        public final Builder vendorGuidance(VendorGuidance vendorGuidance) {
            this.vendorGuidance(vendorGuidance == null ? null : vendorGuidance.toString());
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getMlFramework() {
            return mlFramework;
        }

        public final void setMlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
        }

        @Override
        public final Builder mlFramework(String mlFramework) {
            this.mlFramework = mlFramework;
            return this;
        }

        public final String getProgrammingLang() {
            return programmingLang;
        }

        public final void setProgrammingLang(String programmingLang) {
            this.programmingLang = programmingLang;
        }

        @Override
        public final Builder programmingLang(String programmingLang) {
            this.programmingLang = programmingLang;
            return this;
        }

        public final String getProcessor() {
            return processor;
        }

        public final void setProcessor(String processor) {
            this.processor = processor;
        }

        @Override
        public final Builder processor(String processor) {
            this.processor = processor;
            return this;
        }

        @Override
        public final Builder processor(Processor processor) {
            this.processor(processor == null ? null : processor.toString());
            return this;
        }

        public final Boolean getHorovod() {
            return horovod;
        }

        public final void setHorovod(Boolean horovod) {
            this.horovod = horovod;
        }

        @Override
        public final Builder horovod(Boolean horovod) {
            this.horovod = horovod;
            return this;
        }

        public final String getReleaseNotes() {
            return releaseNotes;
        }

        public final void setReleaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
        }

        @Override
        public final Builder releaseNotes(String releaseNotes) {
            this.releaseNotes = releaseNotes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImageVersionRequest build() {
            return new UpdateImageVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
