/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the traffic pattern.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Phase implements SdkPojo, Serializable, ToCopyableBuilder<Phase.Builder, Phase> {
    private static final SdkField<Integer> INITIAL_NUMBER_OF_USERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InitialNumberOfUsers").getter(getter(Phase::initialNumberOfUsers))
            .setter(setter(Builder::initialNumberOfUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialNumberOfUsers").build())
            .build();

    private static final SdkField<Integer> SPAWN_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SpawnRate").getter(getter(Phase::spawnRate)).setter(setter(Builder::spawnRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpawnRate").build()).build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInSeconds").getter(getter(Phase::durationInSeconds)).setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_NUMBER_OF_USERS_FIELD,
            SPAWN_RATE_FIELD, DURATION_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer initialNumberOfUsers;

    private final Integer spawnRate;

    private final Integer durationInSeconds;

    private Phase(BuilderImpl builder) {
        this.initialNumberOfUsers = builder.initialNumberOfUsers;
        this.spawnRate = builder.spawnRate;
        this.durationInSeconds = builder.durationInSeconds;
    }

    /**
     * <p>
     * Specifies how many concurrent users to start with. The value should be between 1 and 3.
     * </p>
     * 
     * @return Specifies how many concurrent users to start with. The value should be between 1 and 3.
     */
    public final Integer initialNumberOfUsers() {
        return initialNumberOfUsers;
    }

    /**
     * <p>
     * Specified how many new users to spawn in a minute.
     * </p>
     * 
     * @return Specified how many new users to spawn in a minute.
     */
    public final Integer spawnRate() {
        return spawnRate;
    }

    /**
     * <p>
     * Specifies how long a traffic phase should be. For custom load tests, the value should be between 120 and 3600.
     * This value should not exceed <code>JobDurationInSeconds</code>.
     * </p>
     * 
     * @return Specifies how long a traffic phase should be. For custom load tests, the value should be between 120 and
     *         3600. This value should not exceed <code>JobDurationInSeconds</code>.
     */
    public final Integer durationInSeconds() {
        return durationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialNumberOfUsers());
        hashCode = 31 * hashCode + Objects.hashCode(spawnRate());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Phase)) {
            return false;
        }
        Phase other = (Phase) obj;
        return Objects.equals(initialNumberOfUsers(), other.initialNumberOfUsers())
                && Objects.equals(spawnRate(), other.spawnRate())
                && Objects.equals(durationInSeconds(), other.durationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Phase").add("InitialNumberOfUsers", initialNumberOfUsers()).add("SpawnRate", spawnRate())
                .add("DurationInSeconds", durationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialNumberOfUsers":
            return Optional.ofNullable(clazz.cast(initialNumberOfUsers()));
        case "SpawnRate":
            return Optional.ofNullable(clazz.cast(spawnRate()));
        case "DurationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Phase, T> g) {
        return obj -> g.apply((Phase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Phase> {
        /**
         * <p>
         * Specifies how many concurrent users to start with. The value should be between 1 and 3.
         * </p>
         * 
         * @param initialNumberOfUsers
         *        Specifies how many concurrent users to start with. The value should be between 1 and 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialNumberOfUsers(Integer initialNumberOfUsers);

        /**
         * <p>
         * Specified how many new users to spawn in a minute.
         * </p>
         * 
         * @param spawnRate
         *        Specified how many new users to spawn in a minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spawnRate(Integer spawnRate);

        /**
         * <p>
         * Specifies how long a traffic phase should be. For custom load tests, the value should be between 120 and
         * 3600. This value should not exceed <code>JobDurationInSeconds</code>.
         * </p>
         * 
         * @param durationInSeconds
         *        Specifies how long a traffic phase should be. For custom load tests, the value should be between 120
         *        and 3600. This value should not exceed <code>JobDurationInSeconds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer initialNumberOfUsers;

        private Integer spawnRate;

        private Integer durationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(Phase model) {
            initialNumberOfUsers(model.initialNumberOfUsers);
            spawnRate(model.spawnRate);
            durationInSeconds(model.durationInSeconds);
        }

        public final Integer getInitialNumberOfUsers() {
            return initialNumberOfUsers;
        }

        public final void setInitialNumberOfUsers(Integer initialNumberOfUsers) {
            this.initialNumberOfUsers = initialNumberOfUsers;
        }

        @Override
        public final Builder initialNumberOfUsers(Integer initialNumberOfUsers) {
            this.initialNumberOfUsers = initialNumberOfUsers;
            return this;
        }

        public final Integer getSpawnRate() {
            return spawnRate;
        }

        public final void setSpawnRate(Integer spawnRate) {
            this.spawnRate = spawnRate;
        }

        @Override
        public final Builder spawnRate(Integer spawnRate) {
            this.spawnRate = spawnRate;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        @Override
        public Phase build() {
            return new Phase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
