/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A model displayed in the Amazon SageMaker Model Dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDashboardModel implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelDashboardModel.Builder, ModelDashboardModel> {
    private static final SdkField<Model> MODEL_FIELD = SdkField.<Model> builder(MarshallingType.SDK_POJO).memberName("Model")
            .getter(getter(ModelDashboardModel::model)).setter(setter(Builder::model)).constructor(Model::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<List<ModelDashboardEndpoint>> ENDPOINTS_FIELD = SdkField
            .<List<ModelDashboardEndpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(ModelDashboardModel::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelDashboardEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelDashboardEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TransformJob> LAST_BATCH_TRANSFORM_JOB_FIELD = SdkField
            .<TransformJob> builder(MarshallingType.SDK_POJO).memberName("LastBatchTransformJob")
            .getter(getter(ModelDashboardModel::lastBatchTransformJob)).setter(setter(Builder::lastBatchTransformJob))
            .constructor(TransformJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBatchTransformJob").build())
            .build();

    private static final SdkField<List<ModelDashboardMonitoringSchedule>> MONITORING_SCHEDULES_FIELD = SdkField
            .<List<ModelDashboardMonitoringSchedule>> builder(MarshallingType.LIST)
            .memberName("MonitoringSchedules")
            .getter(getter(ModelDashboardModel::monitoringSchedules))
            .setter(setter(Builder::monitoringSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelDashboardMonitoringSchedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelDashboardMonitoringSchedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ModelDashboardModelCard> MODEL_CARD_FIELD = SdkField
            .<ModelDashboardModelCard> builder(MarshallingType.SDK_POJO).memberName("ModelCard")
            .getter(getter(ModelDashboardModel::modelCard)).setter(setter(Builder::modelCard))
            .constructor(ModelDashboardModelCard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_FIELD, ENDPOINTS_FIELD,
            LAST_BATCH_TRANSFORM_JOB_FIELD, MONITORING_SCHEDULES_FIELD, MODEL_CARD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Model model;

    private final List<ModelDashboardEndpoint> endpoints;

    private final TransformJob lastBatchTransformJob;

    private final List<ModelDashboardMonitoringSchedule> monitoringSchedules;

    private final ModelDashboardModelCard modelCard;

    private ModelDashboardModel(BuilderImpl builder) {
        this.model = builder.model;
        this.endpoints = builder.endpoints;
        this.lastBatchTransformJob = builder.lastBatchTransformJob;
        this.monitoringSchedules = builder.monitoringSchedules;
        this.modelCard = builder.modelCard;
    }

    /**
     * <p>
     * A model displayed in the Model Dashboard.
     * </p>
     * 
     * @return A model displayed in the Model Dashboard.
     */
    public final Model model() {
        return model;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The endpoints that host a model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return The endpoints that host a model.
     */
    public final List<ModelDashboardEndpoint> endpoints() {
        return endpoints;
    }

    /**
     * Returns the value of the LastBatchTransformJob property for this object.
     * 
     * @return The value of the LastBatchTransformJob property for this object.
     */
    public final TransformJob lastBatchTransformJob() {
        return lastBatchTransformJob;
    }

    /**
     * For responses, this returns true if the service returned a value for the MonitoringSchedules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMonitoringSchedules() {
        return monitoringSchedules != null && !(monitoringSchedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The monitoring schedules for a model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonitoringSchedules} method.
     * </p>
     * 
     * @return The monitoring schedules for a model.
     */
    public final List<ModelDashboardMonitoringSchedule> monitoringSchedules() {
        return monitoringSchedules;
    }

    /**
     * <p>
     * The model card for a model.
     * </p>
     * 
     * @return The model card for a model.
     */
    public final ModelDashboardModelCard modelCard() {
        return modelCard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastBatchTransformJob());
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitoringSchedules() ? monitoringSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modelCard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDashboardModel)) {
            return false;
        }
        ModelDashboardModel other = (ModelDashboardModel) obj;
        return Objects.equals(model(), other.model()) && hasEndpoints() == other.hasEndpoints()
                && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(lastBatchTransformJob(), other.lastBatchTransformJob())
                && hasMonitoringSchedules() == other.hasMonitoringSchedules()
                && Objects.equals(monitoringSchedules(), other.monitoringSchedules())
                && Objects.equals(modelCard(), other.modelCard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDashboardModel").add("Model", model())
                .add("Endpoints", hasEndpoints() ? endpoints() : null).add("LastBatchTransformJob", lastBatchTransformJob())
                .add("MonitoringSchedules", hasMonitoringSchedules() ? monitoringSchedules() : null)
                .add("ModelCard", modelCard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "LastBatchTransformJob":
            return Optional.ofNullable(clazz.cast(lastBatchTransformJob()));
        case "MonitoringSchedules":
            return Optional.ofNullable(clazz.cast(monitoringSchedules()));
        case "ModelCard":
            return Optional.ofNullable(clazz.cast(modelCard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDashboardModel, T> g) {
        return obj -> g.apply((ModelDashboardModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDashboardModel> {
        /**
         * <p>
         * A model displayed in the Model Dashboard.
         * </p>
         * 
         * @param model
         *        A model displayed in the Model Dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(Model model);

        /**
         * <p>
         * A model displayed in the Model Dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link Model.Builder} avoiding the need to
         * create one manually via {@link Model#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Model.Builder#build()} is called immediately and its result is
         * passed to {@link #model(Model)}.
         * 
         * @param model
         *        a consumer that will call methods on {@link Model.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #model(Model)
         */
        default Builder model(Consumer<Model.Builder> model) {
            return model(Model.builder().applyMutation(model).build());
        }

        /**
         * <p>
         * The endpoints that host a model.
         * </p>
         * 
         * @param endpoints
         *        The endpoints that host a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<ModelDashboardEndpoint> endpoints);

        /**
         * <p>
         * The endpoints that host a model.
         * </p>
         * 
         * @param endpoints
         *        The endpoints that host a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(ModelDashboardEndpoint... endpoints);

        /**
         * <p>
         * The endpoints that host a model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint.Builder#build()} is called
         * immediately and its result is passed to {@link #endpoints(List<ModelDashboardEndpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelDashboardEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(java.util.Collection<ModelDashboardEndpoint>)
         */
        Builder endpoints(Consumer<ModelDashboardEndpoint.Builder>... endpoints);

        /**
         * Sets the value of the LastBatchTransformJob property for this object.
         *
         * @param lastBatchTransformJob
         *        The new value for the LastBatchTransformJob property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBatchTransformJob(TransformJob lastBatchTransformJob);

        /**
         * Sets the value of the LastBatchTransformJob property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TransformJob.Builder} avoiding the need
         * to create one manually via {@link TransformJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformJob.Builder#build()} is called immediately and its
         * result is passed to {@link #lastBatchTransformJob(TransformJob)}.
         * 
         * @param lastBatchTransformJob
         *        a consumer that will call methods on {@link TransformJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastBatchTransformJob(TransformJob)
         */
        default Builder lastBatchTransformJob(Consumer<TransformJob.Builder> lastBatchTransformJob) {
            return lastBatchTransformJob(TransformJob.builder().applyMutation(lastBatchTransformJob).build());
        }

        /**
         * <p>
         * The monitoring schedules for a model.
         * </p>
         * 
         * @param monitoringSchedules
         *        The monitoring schedules for a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringSchedules(Collection<ModelDashboardMonitoringSchedule> monitoringSchedules);

        /**
         * <p>
         * The monitoring schedules for a model.
         * </p>
         * 
         * @param monitoringSchedules
         *        The monitoring schedules for a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringSchedules(ModelDashboardMonitoringSchedule... monitoringSchedules);

        /**
         * <p>
         * The monitoring schedules for a model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #monitoringSchedules(List<ModelDashboardMonitoringSchedule>)}.
         * 
         * @param monitoringSchedules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelDashboardMonitoringSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringSchedules(java.util.Collection<ModelDashboardMonitoringSchedule>)
         */
        Builder monitoringSchedules(Consumer<ModelDashboardMonitoringSchedule.Builder>... monitoringSchedules);

        /**
         * <p>
         * The model card for a model.
         * </p>
         * 
         * @param modelCard
         *        The model card for a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCard(ModelDashboardModelCard modelCard);

        /**
         * <p>
         * The model card for a model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDashboardModelCard.Builder} avoiding
         * the need to create one manually via {@link ModelDashboardModelCard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDashboardModelCard.Builder#build()} is called immediately
         * and its result is passed to {@link #modelCard(ModelDashboardModelCard)}.
         * 
         * @param modelCard
         *        a consumer that will call methods on {@link ModelDashboardModelCard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelCard(ModelDashboardModelCard)
         */
        default Builder modelCard(Consumer<ModelDashboardModelCard.Builder> modelCard) {
            return modelCard(ModelDashboardModelCard.builder().applyMutation(modelCard).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Model model;

        private List<ModelDashboardEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private TransformJob lastBatchTransformJob;

        private List<ModelDashboardMonitoringSchedule> monitoringSchedules = DefaultSdkAutoConstructList.getInstance();

        private ModelDashboardModelCard modelCard;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDashboardModel model) {
            model(model.model);
            endpoints(model.endpoints);
            lastBatchTransformJob(model.lastBatchTransformJob);
            monitoringSchedules(model.monitoringSchedules);
            modelCard(model.modelCard);
        }

        public final Model.Builder getModel() {
            return model != null ? model.toBuilder() : null;
        }

        public final void setModel(Model.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        @Override
        public final Builder model(Model model) {
            this.model = model;
            return this;
        }

        public final List<ModelDashboardEndpoint.Builder> getEndpoints() {
            List<ModelDashboardEndpoint.Builder> result = ModelDashboardEndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<ModelDashboardEndpoint.BuilderImpl> endpoints) {
            this.endpoints = ModelDashboardEndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<ModelDashboardEndpoint> endpoints) {
            this.endpoints = ModelDashboardEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(ModelDashboardEndpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<ModelDashboardEndpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> ModelDashboardEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TransformJob.Builder getLastBatchTransformJob() {
            return lastBatchTransformJob != null ? lastBatchTransformJob.toBuilder() : null;
        }

        public final void setLastBatchTransformJob(TransformJob.BuilderImpl lastBatchTransformJob) {
            this.lastBatchTransformJob = lastBatchTransformJob != null ? lastBatchTransformJob.build() : null;
        }

        @Override
        public final Builder lastBatchTransformJob(TransformJob lastBatchTransformJob) {
            this.lastBatchTransformJob = lastBatchTransformJob;
            return this;
        }

        public final List<ModelDashboardMonitoringSchedule.Builder> getMonitoringSchedules() {
            List<ModelDashboardMonitoringSchedule.Builder> result = ModelDashboardMonitoringSchedulesCopier
                    .copyToBuilder(this.monitoringSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringSchedules(Collection<ModelDashboardMonitoringSchedule.BuilderImpl> monitoringSchedules) {
            this.monitoringSchedules = ModelDashboardMonitoringSchedulesCopier.copyFromBuilder(monitoringSchedules);
        }

        @Override
        public final Builder monitoringSchedules(Collection<ModelDashboardMonitoringSchedule> monitoringSchedules) {
            this.monitoringSchedules = ModelDashboardMonitoringSchedulesCopier.copy(monitoringSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringSchedules(ModelDashboardMonitoringSchedule... monitoringSchedules) {
            monitoringSchedules(Arrays.asList(monitoringSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringSchedules(Consumer<ModelDashboardMonitoringSchedule.Builder>... monitoringSchedules) {
            monitoringSchedules(Stream.of(monitoringSchedules)
                    .map(c -> ModelDashboardMonitoringSchedule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ModelDashboardModelCard.Builder getModelCard() {
            return modelCard != null ? modelCard.toBuilder() : null;
        }

        public final void setModelCard(ModelDashboardModelCard.BuilderImpl modelCard) {
            this.modelCard = modelCard != null ? modelCard.build() : null;
        }

        @Override
        public final Builder modelCard(ModelDashboardModelCard modelCard) {
            this.modelCard = modelCard;
            return this;
        }

        @Override
        public ModelDashboardModel build() {
            return new ModelDashboardModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
