/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLabelingJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListLabelingJobsResponse.Builder, ListLabelingJobsResponse> {
    private static final SdkField<List<LabelingJobSummary>> LABELING_JOB_SUMMARY_LIST_FIELD = SdkField
            .<List<LabelingJobSummary>> builder(MarshallingType.LIST)
            .memberName("LabelingJobSummaryList")
            .getter(getter(ListLabelingJobsResponse::labelingJobSummaryList))
            .setter(setter(Builder::labelingJobSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LabelingJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LabelingJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLabelingJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LABELING_JOB_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<LabelingJobSummary> labelingJobSummaryList;

    private final String nextToken;

    private ListLabelingJobsResponse(BuilderImpl builder) {
        super(builder);
        this.labelingJobSummaryList = builder.labelingJobSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabelingJobSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLabelingJobSummaryList() {
        return labelingJobSummaryList != null && !(labelingJobSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabelingJobSummaryList} method.
     * </p>
     * 
     * @return An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
     */
    public final List<LabelingJobSummary> labelingJobSummaryList() {
        return labelingJobSummaryList;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To retrieve the next set of labeling jobs, use it in
     * the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To retrieve the next set of labeling jobs,
     *         use it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelingJobSummaryList() ? labelingJobSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelingJobsResponse)) {
            return false;
        }
        ListLabelingJobsResponse other = (ListLabelingJobsResponse) obj;
        return hasLabelingJobSummaryList() == other.hasLabelingJobSummaryList()
                && Objects.equals(labelingJobSummaryList(), other.labelingJobSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLabelingJobsResponse")
                .add("LabelingJobSummaryList", hasLabelingJobSummaryList() ? labelingJobSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelingJobSummaryList":
            return Optional.ofNullable(clazz.cast(labelingJobSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLabelingJobsResponse, T> g) {
        return obj -> g.apply((ListLabelingJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLabelingJobsResponse> {
        /**
         * <p>
         * An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * </p>
         * 
         * @param labelingJobSummaryList
         *        An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobSummaryList(Collection<LabelingJobSummary> labelingJobSummaryList);

        /**
         * <p>
         * An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * </p>
         * 
         * @param labelingJobSummaryList
         *        An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobSummaryList(LabelingJobSummary... labelingJobSummaryList);

        /**
         * <p>
         * An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #labelingJobSummaryList(List<LabelingJobSummary>)}.
         * 
         * @param labelingJobSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelingJobSummaryList(java.util.Collection<LabelingJobSummary>)
         */
        Builder labelingJobSummaryList(Consumer<LabelingJobSummary.Builder>... labelingJobSummaryList);

        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To retrieve the next set of labeling jobs, use it
         * in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To retrieve the next set of labeling jobs,
         *        use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<LabelingJobSummary> labelingJobSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelingJobsResponse model) {
            super(model);
            labelingJobSummaryList(model.labelingJobSummaryList);
            nextToken(model.nextToken);
        }

        public final List<LabelingJobSummary.Builder> getLabelingJobSummaryList() {
            List<LabelingJobSummary.Builder> result = LabelingJobSummaryListCopier.copyToBuilder(this.labelingJobSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabelingJobSummaryList(Collection<LabelingJobSummary.BuilderImpl> labelingJobSummaryList) {
            this.labelingJobSummaryList = LabelingJobSummaryListCopier.copyFromBuilder(labelingJobSummaryList);
        }

        @Override
        public final Builder labelingJobSummaryList(Collection<LabelingJobSummary> labelingJobSummaryList) {
            this.labelingJobSummaryList = LabelingJobSummaryListCopier.copy(labelingJobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelingJobSummaryList(LabelingJobSummary... labelingJobSummaryList) {
            labelingJobSummaryList(Arrays.asList(labelingJobSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelingJobSummaryList(Consumer<LabelingJobSummary.Builder>... labelingJobSummaryList) {
            labelingJobSummaryList(Stream.of(labelingJobSummaryList)
                    .map(c -> LabelingJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLabelingJobsResponse build() {
            return new ListLabelingJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
