/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHubsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListHubsResponse.Builder, ListHubsResponse> {
    private static final SdkField<List<HubInfo>> HUB_SUMMARIES_FIELD = SdkField
            .<List<HubInfo>> builder(MarshallingType.LIST)
            .memberName("HubSummaries")
            .getter(getter(ListHubsResponse::hubSummaries))
            .setter(setter(Builder::hubSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HubInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(HubInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHubsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<HubInfo> hubSummaries;

    private final String nextToken;

    private ListHubsResponse(BuilderImpl builder) {
        super(builder);
        this.hubSummaries = builder.hubSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the HubSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHubSummaries() {
        return hubSummaries != null && !(hubSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summaries of the listed hubs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHubSummaries} method.
     * </p>
     * 
     * @return The summaries of the listed hubs.
     */
    public final List<HubInfo> hubSummaries() {
        return hubSummaries;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To retrieve the next set of hubs, use it in the
     * subsequent request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To retrieve the next set of hubs, use it in
     *         the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHubSummaries() ? hubSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHubsResponse)) {
            return false;
        }
        ListHubsResponse other = (ListHubsResponse) obj;
        return hasHubSummaries() == other.hasHubSummaries() && Objects.equals(hubSummaries(), other.hubSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHubsResponse").add("HubSummaries", hasHubSummaries() ? hubSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubSummaries":
            return Optional.ofNullable(clazz.cast(hubSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHubsResponse, T> g) {
        return obj -> g.apply((ListHubsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHubsResponse> {
        /**
         * <p>
         * The summaries of the listed hubs.
         * </p>
         * 
         * @param hubSummaries
         *        The summaries of the listed hubs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSummaries(Collection<HubInfo> hubSummaries);

        /**
         * <p>
         * The summaries of the listed hubs.
         * </p>
         * 
         * @param hubSummaries
         *        The summaries of the listed hubs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSummaries(HubInfo... hubSummaries);

        /**
         * <p>
         * The summaries of the listed hubs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.HubInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.HubInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.HubInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #hubSummaries(List<HubInfo>)}.
         * 
         * @param hubSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.HubInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hubSummaries(java.util.Collection<HubInfo>)
         */
        Builder hubSummaries(Consumer<HubInfo.Builder>... hubSummaries);

        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To retrieve the next set of hubs, use it in the
         * subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To retrieve the next set of hubs, use it
         *        in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<HubInfo> hubSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHubsResponse model) {
            super(model);
            hubSummaries(model.hubSummaries);
            nextToken(model.nextToken);
        }

        public final List<HubInfo.Builder> getHubSummaries() {
            List<HubInfo.Builder> result = HubInfoListCopier.copyToBuilder(this.hubSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHubSummaries(Collection<HubInfo.BuilderImpl> hubSummaries) {
            this.hubSummaries = HubInfoListCopier.copyFromBuilder(hubSummaries);
        }

        @Override
        public final Builder hubSummaries(Collection<HubInfo> hubSummaries) {
            this.hubSummaries = HubInfoListCopier.copy(hubSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSummaries(HubInfo... hubSummaries) {
            hubSummaries(Arrays.asList(hubSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSummaries(Consumer<HubInfo.Builder>... hubSummaries) {
            hubSummaries(Stream.of(hubSummaries).map(c -> HubInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHubsResponse build() {
            return new ListHubsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
