/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about hub content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HubContentInfo implements SdkPojo, Serializable, ToCopyableBuilder<HubContentInfo.Builder, HubContentInfo> {
    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentName").getter(getter(HubContentInfo::hubContentName)).setter(setter(Builder::hubContentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()).build();

    private static final SdkField<String> HUB_CONTENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentArn").getter(getter(HubContentInfo::hubContentArn)).setter(setter(Builder::hubContentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentArn").build()).build();

    private static final SdkField<String> HUB_CONTENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentVersion").getter(getter(HubContentInfo::hubContentVersion))
            .setter(setter(Builder::hubContentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentVersion").build()).build();

    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentType").getter(getter(HubContentInfo::hubContentTypeAsString))
            .setter(setter(Builder::hubContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()).build();

    private static final SdkField<String> DOCUMENT_SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentSchemaVersion").getter(getter(HubContentInfo::documentSchemaVersion))
            .setter(setter(Builder::documentSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentSchemaVersion").build())
            .build();

    private static final SdkField<String> HUB_CONTENT_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentDisplayName").getter(getter(HubContentInfo::hubContentDisplayName))
            .setter(setter(Builder::hubContentDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDisplayName").build())
            .build();

    private static final SdkField<String> HUB_CONTENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentDescription").getter(getter(HubContentInfo::hubContentDescription))
            .setter(setter(Builder::hubContentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDescription").build())
            .build();

    private static final SdkField<List<String>> HUB_CONTENT_SEARCH_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HubContentSearchKeywords")
            .getter(getter(HubContentInfo::hubContentSearchKeywords))
            .setter(setter(Builder::hubContentSearchKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentSearchKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HUB_CONTENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentStatus").getter(getter(HubContentInfo::hubContentStatusAsString))
            .setter(setter(Builder::hubContentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(HubContentInfo::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_CONTENT_NAME_FIELD,
            HUB_CONTENT_ARN_FIELD, HUB_CONTENT_VERSION_FIELD, HUB_CONTENT_TYPE_FIELD, DOCUMENT_SCHEMA_VERSION_FIELD,
            HUB_CONTENT_DISPLAY_NAME_FIELD, HUB_CONTENT_DESCRIPTION_FIELD, HUB_CONTENT_SEARCH_KEYWORDS_FIELD,
            HUB_CONTENT_STATUS_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hubContentName;

    private final String hubContentArn;

    private final String hubContentVersion;

    private final String hubContentType;

    private final String documentSchemaVersion;

    private final String hubContentDisplayName;

    private final String hubContentDescription;

    private final List<String> hubContentSearchKeywords;

    private final String hubContentStatus;

    private final Instant creationTime;

    private HubContentInfo(BuilderImpl builder) {
        this.hubContentName = builder.hubContentName;
        this.hubContentArn = builder.hubContentArn;
        this.hubContentVersion = builder.hubContentVersion;
        this.hubContentType = builder.hubContentType;
        this.documentSchemaVersion = builder.documentSchemaVersion;
        this.hubContentDisplayName = builder.hubContentDisplayName;
        this.hubContentDescription = builder.hubContentDescription;
        this.hubContentSearchKeywords = builder.hubContentSearchKeywords;
        this.hubContentStatus = builder.hubContentStatus;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the hub content.
     * </p>
     * 
     * @return The name of the hub content.
     */
    public final String hubContentName() {
        return hubContentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the hub content.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the hub content.
     */
    public final String hubContentArn() {
        return hubContentArn;
    }

    /**
     * <p>
     * The version of the hub content.
     * </p>
     * 
     * @return The version of the hub content.
     */
    public final String hubContentVersion() {
        return hubContentVersion;
    }

    /**
     * <p>
     * The type of hub content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content.
     * @see HubContentType
     */
    public final HubContentType hubContentType() {
        return HubContentType.fromValue(hubContentType);
    }

    /**
     * <p>
     * The type of hub content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content.
     * @see HubContentType
     */
    public final String hubContentTypeAsString() {
        return hubContentType;
    }

    /**
     * <p>
     * The version of the hub content document schema.
     * </p>
     * 
     * @return The version of the hub content document schema.
     */
    public final String documentSchemaVersion() {
        return documentSchemaVersion;
    }

    /**
     * <p>
     * The display name of the hub content.
     * </p>
     * 
     * @return The display name of the hub content.
     */
    public final String hubContentDisplayName() {
        return hubContentDisplayName;
    }

    /**
     * <p>
     * A description of the hub content.
     * </p>
     * 
     * @return A description of the hub content.
     */
    public final String hubContentDescription() {
        return hubContentDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the HubContentSearchKeywords property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHubContentSearchKeywords() {
        return hubContentSearchKeywords != null && !(hubContentSearchKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The searchable keywords for the hub content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHubContentSearchKeywords} method.
     * </p>
     * 
     * @return The searchable keywords for the hub content.
     */
    public final List<String> hubContentSearchKeywords() {
        return hubContentSearchKeywords;
    }

    /**
     * <p>
     * The status of the hub content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentStatus}
     * will return {@link HubContentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentStatusAsString}.
     * </p>
     * 
     * @return The status of the hub content.
     * @see HubContentStatus
     */
    public final HubContentStatus hubContentStatus() {
        return HubContentStatus.fromValue(hubContentStatus);
    }

    /**
     * <p>
     * The status of the hub content.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentStatus}
     * will return {@link HubContentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentStatusAsString}.
     * </p>
     * 
     * @return The status of the hub content.
     * @see HubContentStatus
     */
    public final String hubContentStatusAsString() {
        return hubContentStatus;
    }

    /**
     * <p>
     * The date and time that the hub content was created.
     * </p>
     * 
     * @return The date and time that the hub content was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentArn());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasHubContentSearchKeywords() ? hubContentSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hubContentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HubContentInfo)) {
            return false;
        }
        HubContentInfo other = (HubContentInfo) obj;
        return Objects.equals(hubContentName(), other.hubContentName()) && Objects.equals(hubContentArn(), other.hubContentArn())
                && Objects.equals(hubContentVersion(), other.hubContentVersion())
                && Objects.equals(hubContentTypeAsString(), other.hubContentTypeAsString())
                && Objects.equals(documentSchemaVersion(), other.documentSchemaVersion())
                && Objects.equals(hubContentDisplayName(), other.hubContentDisplayName())
                && Objects.equals(hubContentDescription(), other.hubContentDescription())
                && hasHubContentSearchKeywords() == other.hasHubContentSearchKeywords()
                && Objects.equals(hubContentSearchKeywords(), other.hubContentSearchKeywords())
                && Objects.equals(hubContentStatusAsString(), other.hubContentStatusAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HubContentInfo").add("HubContentName", hubContentName()).add("HubContentArn", hubContentArn())
                .add("HubContentVersion", hubContentVersion()).add("HubContentType", hubContentTypeAsString())
                .add("DocumentSchemaVersion", documentSchemaVersion()).add("HubContentDisplayName", hubContentDisplayName())
                .add("HubContentDescription", hubContentDescription())
                .add("HubContentSearchKeywords", hasHubContentSearchKeywords() ? hubContentSearchKeywords() : null)
                .add("HubContentStatus", hubContentStatusAsString()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubContentName":
            return Optional.ofNullable(clazz.cast(hubContentName()));
        case "HubContentArn":
            return Optional.ofNullable(clazz.cast(hubContentArn()));
        case "HubContentVersion":
            return Optional.ofNullable(clazz.cast(hubContentVersion()));
        case "HubContentType":
            return Optional.ofNullable(clazz.cast(hubContentTypeAsString()));
        case "DocumentSchemaVersion":
            return Optional.ofNullable(clazz.cast(documentSchemaVersion()));
        case "HubContentDisplayName":
            return Optional.ofNullable(clazz.cast(hubContentDisplayName()));
        case "HubContentDescription":
            return Optional.ofNullable(clazz.cast(hubContentDescription()));
        case "HubContentSearchKeywords":
            return Optional.ofNullable(clazz.cast(hubContentSearchKeywords()));
        case "HubContentStatus":
            return Optional.ofNullable(clazz.cast(hubContentStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HubContentInfo, T> g) {
        return obj -> g.apply((HubContentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HubContentInfo> {
        /**
         * <p>
         * The name of the hub content.
         * </p>
         * 
         * @param hubContentName
         *        The name of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentName(String hubContentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the hub content.
         * </p>
         * 
         * @param hubContentArn
         *        The Amazon Resource Name (ARN) of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentArn(String hubContentArn);

        /**
         * <p>
         * The version of the hub content.
         * </p>
         * 
         * @param hubContentVersion
         *        The version of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentVersion(String hubContentVersion);

        /**
         * <p>
         * The type of hub content.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(String hubContentType);

        /**
         * <p>
         * The type of hub content.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(HubContentType hubContentType);

        /**
         * <p>
         * The version of the hub content document schema.
         * </p>
         * 
         * @param documentSchemaVersion
         *        The version of the hub content document schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentSchemaVersion(String documentSchemaVersion);

        /**
         * <p>
         * The display name of the hub content.
         * </p>
         * 
         * @param hubContentDisplayName
         *        The display name of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentDisplayName(String hubContentDisplayName);

        /**
         * <p>
         * A description of the hub content.
         * </p>
         * 
         * @param hubContentDescription
         *        A description of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentDescription(String hubContentDescription);

        /**
         * <p>
         * The searchable keywords for the hub content.
         * </p>
         * 
         * @param hubContentSearchKeywords
         *        The searchable keywords for the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords);

        /**
         * <p>
         * The searchable keywords for the hub content.
         * </p>
         * 
         * @param hubContentSearchKeywords
         *        The searchable keywords for the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentSearchKeywords(String... hubContentSearchKeywords);

        /**
         * <p>
         * The status of the hub content.
         * </p>
         * 
         * @param hubContentStatus
         *        The status of the hub content.
         * @see HubContentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentStatus
         */
        Builder hubContentStatus(String hubContentStatus);

        /**
         * <p>
         * The status of the hub content.
         * </p>
         * 
         * @param hubContentStatus
         *        The status of the hub content.
         * @see HubContentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentStatus
         */
        Builder hubContentStatus(HubContentStatus hubContentStatus);

        /**
         * <p>
         * The date and time that the hub content was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the hub content was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String hubContentName;

        private String hubContentArn;

        private String hubContentVersion;

        private String hubContentType;

        private String documentSchemaVersion;

        private String hubContentDisplayName;

        private String hubContentDescription;

        private List<String> hubContentSearchKeywords = DefaultSdkAutoConstructList.getInstance();

        private String hubContentStatus;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HubContentInfo model) {
            hubContentName(model.hubContentName);
            hubContentArn(model.hubContentArn);
            hubContentVersion(model.hubContentVersion);
            hubContentType(model.hubContentType);
            documentSchemaVersion(model.documentSchemaVersion);
            hubContentDisplayName(model.hubContentDisplayName);
            hubContentDescription(model.hubContentDescription);
            hubContentSearchKeywords(model.hubContentSearchKeywords);
            hubContentStatus(model.hubContentStatus);
            creationTime(model.creationTime);
        }

        public final String getHubContentName() {
            return hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentArn() {
            return hubContentArn;
        }

        public final void setHubContentArn(String hubContentArn) {
            this.hubContentArn = hubContentArn;
        }

        @Override
        public final Builder hubContentArn(String hubContentArn) {
            this.hubContentArn = hubContentArn;
            return this;
        }

        public final String getHubContentVersion() {
            return hubContentVersion;
        }

        public final void setHubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
        }

        @Override
        public final Builder hubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
            return this;
        }

        public final String getHubContentType() {
            return hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getDocumentSchemaVersion() {
            return documentSchemaVersion;
        }

        public final void setDocumentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
        }

        @Override
        public final Builder documentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
            return this;
        }

        public final String getHubContentDisplayName() {
            return hubContentDisplayName;
        }

        public final void setHubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
        }

        @Override
        public final Builder hubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
            return this;
        }

        public final String getHubContentDescription() {
            return hubContentDescription;
        }

        public final void setHubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
        }

        @Override
        public final Builder hubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
            return this;
        }

        public final Collection<String> getHubContentSearchKeywords() {
            if (hubContentSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return hubContentSearchKeywords;
        }

        public final void setHubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
        }

        @Override
        public final Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentSearchKeywords(String... hubContentSearchKeywords) {
            hubContentSearchKeywords(Arrays.asList(hubContentSearchKeywords));
            return this;
        }

        public final String getHubContentStatus() {
            return hubContentStatus;
        }

        public final void setHubContentStatus(String hubContentStatus) {
            this.hubContentStatus = hubContentStatus;
        }

        @Override
        public final Builder hubContentStatus(String hubContentStatus) {
            this.hubContentStatus = hubContentStatus;
            return this;
        }

        @Override
        public final Builder hubContentStatus(HubContentStatus hubContentStatus) {
            this.hubContentStatus(hubContentStatus == null ? null : hubContentStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public HubContentInfo build() {
            return new HubContentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
