/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EdgeOutputConfig.Builder, EdgeOutputConfig> {
    private static final SdkField<String> S3_OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3OutputLocation").getter(getter(EdgeOutputConfig::s3OutputLocation))
            .setter(setter(Builder::s3OutputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(EdgeOutputConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> PRESET_DEPLOYMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PresetDeploymentType").getter(getter(EdgeOutputConfig::presetDeploymentTypeAsString))
            .setter(setter(Builder::presetDeploymentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetDeploymentType").build())
            .build();

    private static final SdkField<String> PRESET_DEPLOYMENT_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PresetDeploymentConfig").getter(getter(EdgeOutputConfig::presetDeploymentConfig))
            .setter(setter(Builder::presetDeploymentConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetDeploymentConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_LOCATION_FIELD,
            KMS_KEY_ID_FIELD, PRESET_DEPLOYMENT_TYPE_FIELD, PRESET_DEPLOYMENT_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3OutputLocation;

    private final String kmsKeyId;

    private final String presetDeploymentType;

    private final String presetDeploymentConfig;

    private EdgeOutputConfig(BuilderImpl builder) {
        this.s3OutputLocation = builder.s3OutputLocation;
        this.kmsKeyId = builder.kmsKeyId;
        this.presetDeploymentType = builder.presetDeploymentType;
        this.presetDeploymentConfig = builder.presetDeploymentConfig;
    }

    /**
     * <p>
     * The Amazon Simple Storage (S3) bucker URI.
     * </p>
     * 
     * @return The Amazon Simple Storage (S3) bucker URI.
     */
    public final String s3OutputLocation() {
        return s3OutputLocation;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker
     * uses the default KMS key for Amazon S3 for your role's account.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses
     *         to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon
     *         SageMaker uses the default KMS key for Amazon S3 for your role's account.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT
     * Greengrass Version 2 components.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #presetDeploymentType} will return {@link EdgePresetDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #presetDeploymentTypeAsString}.
     * </p>
     * 
     * @return The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT
     *         Greengrass Version 2 components.
     * @see EdgePresetDeploymentType
     */
    public final EdgePresetDeploymentType presetDeploymentType() {
        return EdgePresetDeploymentType.fromValue(presetDeploymentType);
    }

    /**
     * <p>
     * The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT
     * Greengrass Version 2 components.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #presetDeploymentType} will return {@link EdgePresetDeploymentType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #presetDeploymentTypeAsString}.
     * </p>
     * 
     * @return The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT
     *         Greengrass Version 2 components.
     * @see EdgePresetDeploymentType
     */
    public final String presetDeploymentTypeAsString() {
        return presetDeploymentType;
    }

    /**
     * <p>
     * The configuration used to create deployment artifacts. Specify configuration options with a JSON string. The
     * available configuration options for each type are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified, the default name
     * generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager packaging job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ComponentDescription</code> (optional) - Description of the component.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ComponentVersion</code> (optional) - The version of the component.
     * </p>
     * <note>
     * <p>
     * Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a<i>
     * major.minor.patch</i> number system. For example, version 1.0.0 represents the first major release for a
     * component. For more information, see the <a href="https://semver.org/">semantic version specification</a>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>PlatformOS</code> (optional) - The name of the operating system for the platform. Supported platforms
     * include Windows and Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform.
     * </p>
     * <p>
     * Supported architectures Windows include: Windows32_x86, Windows64_x64.
     * </p>
     * <p>
     * Supported architectures for Linux include: Linux x86_64, Linux ARMV8.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The configuration used to create deployment artifacts. Specify configuration options with a JSON string.
     *         The available configuration options for each type are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified, the
     *         default name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager
     *         packaging job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ComponentDescription</code> (optional) - Description of the component.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ComponentVersion</code> (optional) - The version of the component.
     *         </p>
     *         <note>
     *         <p>
     *         Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a<i>
     *         major.minor.patch</i> number system. For example, version 1.0.0 represents the first major release for a
     *         component. For more information, see the <a href="https://semver.org/">semantic version
     *         specification</a>.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <code>PlatformOS</code> (optional) - The name of the operating system for the platform. Supported
     *         platforms include Windows and Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform.
     *         </p>
     *         <p>
     *         Supported architectures Windows include: Windows32_x86, Windows64_x64.
     *         </p>
     *         <p>
     *         Supported architectures for Linux include: Linux x86_64, Linux ARMV8.
     *         </p>
     *         </li>
     */
    public final String presetDeploymentConfig() {
        return presetDeploymentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(presetDeploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(presetDeploymentConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeOutputConfig)) {
            return false;
        }
        EdgeOutputConfig other = (EdgeOutputConfig) obj;
        return Objects.equals(s3OutputLocation(), other.s3OutputLocation()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(presetDeploymentTypeAsString(), other.presetDeploymentTypeAsString())
                && Objects.equals(presetDeploymentConfig(), other.presetDeploymentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeOutputConfig").add("S3OutputLocation", s3OutputLocation()).add("KmsKeyId", kmsKeyId())
                .add("PresetDeploymentType", presetDeploymentTypeAsString())
                .add("PresetDeploymentConfig", presetDeploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3OutputLocation":
            return Optional.ofNullable(clazz.cast(s3OutputLocation()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PresetDeploymentType":
            return Optional.ofNullable(clazz.cast(presetDeploymentTypeAsString()));
        case "PresetDeploymentConfig":
            return Optional.ofNullable(clazz.cast(presetDeploymentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgeOutputConfig, T> g) {
        return obj -> g.apply((EdgeOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeOutputConfig> {
        /**
         * <p>
         * The Amazon Simple Storage (S3) bucker URI.
         * </p>
         * 
         * @param s3OutputLocation
         *        The Amazon Simple Storage (S3) bucker URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputLocation(String s3OutputLocation);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
         * encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker
         * uses the default KMS key for Amazon S3 for your role's account.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker
         *        uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID,
         *        Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT
         * Greengrass Version 2 components.
         * </p>
         * 
         * @param presetDeploymentType
         *        The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services
         *        IoT Greengrass Version 2 components.
         * @see EdgePresetDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePresetDeploymentType
         */
        Builder presetDeploymentType(String presetDeploymentType);

        /**
         * <p>
         * The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT
         * Greengrass Version 2 components.
         * </p>
         * 
         * @param presetDeploymentType
         *        The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services
         *        IoT Greengrass Version 2 components.
         * @see EdgePresetDeploymentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdgePresetDeploymentType
         */
        Builder presetDeploymentType(EdgePresetDeploymentType presetDeploymentType);

        /**
         * <p>
         * The configuration used to create deployment artifacts. Specify configuration options with a JSON string. The
         * available configuration options for each type are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified, the default
         * name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager packaging job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ComponentDescription</code> (optional) - Description of the component.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ComponentVersion</code> (optional) - The version of the component.
         * </p>
         * <note>
         * <p>
         * Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a<i>
         * major.minor.patch</i> number system. For example, version 1.0.0 represents the first major release for a
         * component. For more information, see the <a href="https://semver.org/">semantic version specification</a>.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>PlatformOS</code> (optional) - The name of the operating system for the platform. Supported platforms
         * include Windows and Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform.
         * </p>
         * <p>
         * Supported architectures Windows include: Windows32_x86, Windows64_x64.
         * </p>
         * <p>
         * Supported architectures for Linux include: Linux x86_64, Linux ARMV8.
         * </p>
         * </li>
         * </ul>
         * 
         * @param presetDeploymentConfig
         *        The configuration used to create deployment artifacts. Specify configuration options with a JSON
         *        string. The available configuration options for each type are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified, the
         *        default name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager
         *        packaging job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ComponentDescription</code> (optional) - Description of the component.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ComponentVersion</code> (optional) - The version of the component.
         *        </p>
         *        <note>
         *        <p>
         *        Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow
         *        a<i> major.minor.patch</i> number system. For example, version 1.0.0 represents the first major
         *        release for a component. For more information, see the <a href="https://semver.org/">semantic version
         *        specification</a>.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>PlatformOS</code> (optional) - The name of the operating system for the platform. Supported
         *        platforms include Windows and Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform.
         *        </p>
         *        <p>
         *        Supported architectures Windows include: Windows32_x86, Windows64_x64.
         *        </p>
         *        <p>
         *        Supported architectures for Linux include: Linux x86_64, Linux ARMV8.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presetDeploymentConfig(String presetDeploymentConfig);
    }

    static final class BuilderImpl implements Builder {
        private String s3OutputLocation;

        private String kmsKeyId;

        private String presetDeploymentType;

        private String presetDeploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeOutputConfig model) {
            s3OutputLocation(model.s3OutputLocation);
            kmsKeyId(model.kmsKeyId);
            presetDeploymentType(model.presetDeploymentType);
            presetDeploymentConfig(model.presetDeploymentConfig);
        }

        public final String getS3OutputLocation() {
            return s3OutputLocation;
        }

        public final void setS3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
        }

        @Override
        public final Builder s3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPresetDeploymentType() {
            return presetDeploymentType;
        }

        public final void setPresetDeploymentType(String presetDeploymentType) {
            this.presetDeploymentType = presetDeploymentType;
        }

        @Override
        public final Builder presetDeploymentType(String presetDeploymentType) {
            this.presetDeploymentType = presetDeploymentType;
            return this;
        }

        @Override
        public final Builder presetDeploymentType(EdgePresetDeploymentType presetDeploymentType) {
            this.presetDeploymentType(presetDeploymentType == null ? null : presetDeploymentType.toString());
            return this;
        }

        public final String getPresetDeploymentConfig() {
            return presetDeploymentConfig;
        }

        public final void setPresetDeploymentConfig(String presetDeploymentConfig) {
            this.presetDeploymentConfig = presetDeploymentConfig;
        }

        @Override
        public final Builder presetDeploymentConfig(String presetDeploymentConfig) {
            this.presetDeploymentConfig = presetDeploymentConfig;
            return this;
        }

        @Override
        public EdgeOutputConfig build() {
            return new EdgeOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
