/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ContinuousParameterRangesCopier {
    static List<ContinuousParameterRange> copy(Collection<? extends ContinuousParameterRange> continuousParameterRangesParam) {
        List<ContinuousParameterRange> list;
        if (continuousParameterRangesParam == null || continuousParameterRangesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ContinuousParameterRange> modifiableList = new ArrayList<>();
            continuousParameterRangesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ContinuousParameterRange> copyFromBuilder(
            Collection<? extends ContinuousParameterRange.Builder> continuousParameterRangesParam) {
        List<ContinuousParameterRange> list;
        if (continuousParameterRangesParam == null || continuousParameterRangesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ContinuousParameterRange> modifiableList = new ArrayList<>();
            continuousParameterRangesParam.forEach(entry -> {
                ContinuousParameterRange member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ContinuousParameterRange.Builder> copyToBuilder(
            Collection<? extends ContinuousParameterRange> continuousParameterRangesParam) {
        List<ContinuousParameterRange.Builder> list;
        if (continuousParameterRangesParam == null || continuousParameterRangesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ContinuousParameterRange.Builder> modifiableList = new ArrayList<>();
            continuousParameterRangesParam.forEach(entry -> {
                ContinuousParameterRange.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
