/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores resolved attributes specific to the problem type of an AutoML job V2.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLProblemTypeResolvedAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLProblemTypeResolvedAttributes.Builder, AutoMLProblemTypeResolvedAttributes> {
    private static final SdkField<TabularResolvedAttributes> TABULAR_RESOLVED_ATTRIBUTES_FIELD = SdkField
            .<TabularResolvedAttributes> builder(MarshallingType.SDK_POJO).memberName("TabularResolvedAttributes")
            .getter(getter(AutoMLProblemTypeResolvedAttributes::tabularResolvedAttributes))
            .setter(setter(Builder::tabularResolvedAttributes)).constructor(TabularResolvedAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TabularResolvedAttributes").build())
            .build();

    private static final SdkField<TextGenerationResolvedAttributes> TEXT_GENERATION_RESOLVED_ATTRIBUTES_FIELD = SdkField
            .<TextGenerationResolvedAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("TextGenerationResolvedAttributes")
            .getter(getter(AutoMLProblemTypeResolvedAttributes::textGenerationResolvedAttributes))
            .setter(setter(Builder::textGenerationResolvedAttributes))
            .constructor(TextGenerationResolvedAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextGenerationResolvedAttributes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TABULAR_RESOLVED_ATTRIBUTES_FIELD, TEXT_GENERATION_RESOLVED_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final TabularResolvedAttributes tabularResolvedAttributes;

    private final TextGenerationResolvedAttributes textGenerationResolvedAttributes;

    private final Type type;

    private AutoMLProblemTypeResolvedAttributes(BuilderImpl builder) {
        this.tabularResolvedAttributes = builder.tabularResolvedAttributes;
        this.textGenerationResolvedAttributes = builder.textGenerationResolvedAttributes;
        this.type = builder.type;
    }

    /**
     * <p>
     * The resolved attributes for the tabular problem type.
     * </p>
     * 
     * @return The resolved attributes for the tabular problem type.
     */
    public final TabularResolvedAttributes tabularResolvedAttributes() {
        return tabularResolvedAttributes;
    }

    /**
     * <p>
     * The resolved attributes for the text generation problem type.
     * </p>
     * 
     * @return The resolved attributes for the text generation problem type.
     */
    public final TextGenerationResolvedAttributes textGenerationResolvedAttributes() {
        return textGenerationResolvedAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tabularResolvedAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(textGenerationResolvedAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLProblemTypeResolvedAttributes)) {
            return false;
        }
        AutoMLProblemTypeResolvedAttributes other = (AutoMLProblemTypeResolvedAttributes) obj;
        return Objects.equals(tabularResolvedAttributes(), other.tabularResolvedAttributes())
                && Objects.equals(textGenerationResolvedAttributes(), other.textGenerationResolvedAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLProblemTypeResolvedAttributes")
                .add("TabularResolvedAttributes", tabularResolvedAttributes())
                .add("TextGenerationResolvedAttributes", textGenerationResolvedAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TabularResolvedAttributes":
            return Optional.ofNullable(clazz.cast(tabularResolvedAttributes()));
        case "TextGenerationResolvedAttributes":
            return Optional.ofNullable(clazz.cast(textGenerationResolvedAttributes()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #tabularResolvedAttributes()} initialized to the given value.
     *
     * <p>
     * The resolved attributes for the tabular problem type.
     * </p>
     * 
     * @param tabularResolvedAttributes
     *        The resolved attributes for the tabular problem type.
     */
    public static AutoMLProblemTypeResolvedAttributes fromTabularResolvedAttributes(
            TabularResolvedAttributes tabularResolvedAttributes) {
        return builder().tabularResolvedAttributes(tabularResolvedAttributes).build();
    }

    /**
     * Create an instance of this class with {@link #tabularResolvedAttributes()} initialized to the given value.
     *
     * <p>
     * The resolved attributes for the tabular problem type.
     * </p>
     * 
     * @param tabularResolvedAttributes
     *        The resolved attributes for the tabular problem type.
     */
    public static AutoMLProblemTypeResolvedAttributes fromTabularResolvedAttributes(
            Consumer<TabularResolvedAttributes.Builder> tabularResolvedAttributes) {
        TabularResolvedAttributes.Builder builder = TabularResolvedAttributes.builder();
        tabularResolvedAttributes.accept(builder);
        return fromTabularResolvedAttributes(builder.build());
    }

    /**
     * Create an instance of this class with {@link #textGenerationResolvedAttributes()} initialized to the given value.
     *
     * <p>
     * The resolved attributes for the text generation problem type.
     * </p>
     * 
     * @param textGenerationResolvedAttributes
     *        The resolved attributes for the text generation problem type.
     */
    public static AutoMLProblemTypeResolvedAttributes fromTextGenerationResolvedAttributes(
            TextGenerationResolvedAttributes textGenerationResolvedAttributes) {
        return builder().textGenerationResolvedAttributes(textGenerationResolvedAttributes).build();
    }

    /**
     * Create an instance of this class with {@link #textGenerationResolvedAttributes()} initialized to the given value.
     *
     * <p>
     * The resolved attributes for the text generation problem type.
     * </p>
     * 
     * @param textGenerationResolvedAttributes
     *        The resolved attributes for the text generation problem type.
     */
    public static AutoMLProblemTypeResolvedAttributes fromTextGenerationResolvedAttributes(
            Consumer<TextGenerationResolvedAttributes.Builder> textGenerationResolvedAttributes) {
        TextGenerationResolvedAttributes.Builder builder = TextGenerationResolvedAttributes.builder();
        textGenerationResolvedAttributes.accept(builder);
        return fromTextGenerationResolvedAttributes(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLProblemTypeResolvedAttributes, T> g) {
        return obj -> g.apply((AutoMLProblemTypeResolvedAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLProblemTypeResolvedAttributes> {
        /**
         * <p>
         * The resolved attributes for the tabular problem type.
         * </p>
         * 
         * @param tabularResolvedAttributes
         *        The resolved attributes for the tabular problem type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tabularResolvedAttributes(TabularResolvedAttributes tabularResolvedAttributes);

        /**
         * <p>
         * The resolved attributes for the tabular problem type.
         * </p>
         * This is a convenience method that creates an instance of the {@link TabularResolvedAttributes.Builder}
         * avoiding the need to create one manually via {@link TabularResolvedAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TabularResolvedAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #tabularResolvedAttributes(TabularResolvedAttributes)}.
         * 
         * @param tabularResolvedAttributes
         *        a consumer that will call methods on {@link TabularResolvedAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tabularResolvedAttributes(TabularResolvedAttributes)
         */
        default Builder tabularResolvedAttributes(Consumer<TabularResolvedAttributes.Builder> tabularResolvedAttributes) {
            return tabularResolvedAttributes(TabularResolvedAttributes.builder().applyMutation(tabularResolvedAttributes).build());
        }

        /**
         * <p>
         * The resolved attributes for the text generation problem type.
         * </p>
         * 
         * @param textGenerationResolvedAttributes
         *        The resolved attributes for the text generation problem type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textGenerationResolvedAttributes(TextGenerationResolvedAttributes textGenerationResolvedAttributes);

        /**
         * <p>
         * The resolved attributes for the text generation problem type.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextGenerationResolvedAttributes.Builder}
         * avoiding the need to create one manually via {@link TextGenerationResolvedAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextGenerationResolvedAttributes.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #textGenerationResolvedAttributes(TextGenerationResolvedAttributes)}.
         * 
         * @param textGenerationResolvedAttributes
         *        a consumer that will call methods on {@link TextGenerationResolvedAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textGenerationResolvedAttributes(TextGenerationResolvedAttributes)
         */
        default Builder textGenerationResolvedAttributes(
                Consumer<TextGenerationResolvedAttributes.Builder> textGenerationResolvedAttributes) {
            return textGenerationResolvedAttributes(TextGenerationResolvedAttributes.builder()
                    .applyMutation(textGenerationResolvedAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TabularResolvedAttributes tabularResolvedAttributes;

        private TextGenerationResolvedAttributes textGenerationResolvedAttributes;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLProblemTypeResolvedAttributes model) {
            tabularResolvedAttributes(model.tabularResolvedAttributes);
            textGenerationResolvedAttributes(model.textGenerationResolvedAttributes);
        }

        public final TabularResolvedAttributes.Builder getTabularResolvedAttributes() {
            return tabularResolvedAttributes != null ? tabularResolvedAttributes.toBuilder() : null;
        }

        public final void setTabularResolvedAttributes(TabularResolvedAttributes.BuilderImpl tabularResolvedAttributes) {
            Object oldValue = this.tabularResolvedAttributes;
            this.tabularResolvedAttributes = tabularResolvedAttributes != null ? tabularResolvedAttributes.build() : null;
            handleUnionValueChange(Type.TABULAR_RESOLVED_ATTRIBUTES, oldValue, this.tabularResolvedAttributes);
        }

        @Override
        public final Builder tabularResolvedAttributes(TabularResolvedAttributes tabularResolvedAttributes) {
            Object oldValue = this.tabularResolvedAttributes;
            this.tabularResolvedAttributes = tabularResolvedAttributes;
            handleUnionValueChange(Type.TABULAR_RESOLVED_ATTRIBUTES, oldValue, this.tabularResolvedAttributes);
            return this;
        }

        public final TextGenerationResolvedAttributes.Builder getTextGenerationResolvedAttributes() {
            return textGenerationResolvedAttributes != null ? textGenerationResolvedAttributes.toBuilder() : null;
        }

        public final void setTextGenerationResolvedAttributes(
                TextGenerationResolvedAttributes.BuilderImpl textGenerationResolvedAttributes) {
            Object oldValue = this.textGenerationResolvedAttributes;
            this.textGenerationResolvedAttributes = textGenerationResolvedAttributes != null ? textGenerationResolvedAttributes
                    .build() : null;
            handleUnionValueChange(Type.TEXT_GENERATION_RESOLVED_ATTRIBUTES, oldValue, this.textGenerationResolvedAttributes);
        }

        @Override
        public final Builder textGenerationResolvedAttributes(TextGenerationResolvedAttributes textGenerationResolvedAttributes) {
            Object oldValue = this.textGenerationResolvedAttributes;
            this.textGenerationResolvedAttributes = textGenerationResolvedAttributes;
            handleUnionValueChange(Type.TEXT_GENERATION_RESOLVED_ATTRIBUTES, oldValue, this.textGenerationResolvedAttributes);
            return this;
        }

        @Override
        public AutoMLProblemTypeResolvedAttributes build() {
            return new AutoMLProblemTypeResolvedAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutoMLProblemTypeResolvedAttributes#type()
     */
    public enum Type {
        TABULAR_RESOLVED_ATTRIBUTES,

        TEXT_GENERATION_RESOLVED_ATTRIBUTES,

        UNKNOWN_TO_SDK_VERSION
    }
}
