/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSource;
import software.amazon.awssdk.services.sagemaker.model.ChannelSpecification;
import software.amazon.awssdk.services.sagemaker.model.ChannelSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterSpecification;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjective;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjectivesCopier;
import software.amazon.awssdk.services.sagemaker.model.MetricDefinition;
import software.amazon.awssdk.services.sagemaker.model.MetricDefinitionListCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingInstanceType;
import software.amazon.awssdk.services.sagemaker.model.TrainingInstanceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingSpecification> {
    private static final SdkField<String> TRAINING_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingImage").getter(TrainingSpecification.getter(TrainingSpecification::trainingImage)).setter(TrainingSpecification.setter(Builder::trainingImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingImage").build()}).build();
    private static final SdkField<String> TRAINING_IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingImageDigest").getter(TrainingSpecification.getter(TrainingSpecification::trainingImageDigest)).setter(TrainingSpecification.setter(Builder::trainingImageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingImageDigest").build()}).build();
    private static final SdkField<List<HyperParameterSpecification>> SUPPORTED_HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedHyperParameters").getter(TrainingSpecification.getter(TrainingSpecification::supportedHyperParameters)).setter(TrainingSpecification.setter(Builder::supportedHyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedHyperParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HyperParameterSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_TRAINING_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedTrainingInstanceTypes").getter(TrainingSpecification.getter(TrainingSpecification::supportedTrainingInstanceTypesAsStrings)).setter(TrainingSpecification.setter(Builder::supportedTrainingInstanceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTrainingInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_DISTRIBUTED_TRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsDistributedTraining").getter(TrainingSpecification.getter(TrainingSpecification::supportsDistributedTraining)).setter(TrainingSpecification.setter(Builder::supportsDistributedTraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsDistributedTraining").build()}).build();
    private static final SdkField<List<MetricDefinition>> METRIC_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDefinitions").getter(TrainingSpecification.getter(TrainingSpecification::metricDefinitions)).setter(TrainingSpecification.setter(Builder::metricDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ChannelSpecification>> TRAINING_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrainingChannels").getter(TrainingSpecification.getter(TrainingSpecification::trainingChannels)).setter(TrainingSpecification.setter(Builder::trainingChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingChannels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HyperParameterTuningJobObjective>> SUPPORTED_TUNING_JOB_OBJECTIVE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedTuningJobObjectiveMetrics").getter(TrainingSpecification.getter(TrainingSpecification::supportedTuningJobObjectiveMetrics)).setter(TrainingSpecification.setter(Builder::supportedTuningJobObjectiveMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTuningJobObjectiveMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HyperParameterTuningJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AdditionalS3DataSource> ADDITIONAL_S3_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalS3DataSource").getter(TrainingSpecification.getter(TrainingSpecification::additionalS3DataSource)).setter(TrainingSpecification.setter(Builder::additionalS3DataSource)).constructor(AdditionalS3DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalS3DataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_IMAGE_FIELD, TRAINING_IMAGE_DIGEST_FIELD, SUPPORTED_HYPER_PARAMETERS_FIELD, SUPPORTED_TRAINING_INSTANCE_TYPES_FIELD, SUPPORTS_DISTRIBUTED_TRAINING_FIELD, METRIC_DEFINITIONS_FIELD, TRAINING_CHANNELS_FIELD, SUPPORTED_TUNING_JOB_OBJECTIVE_METRICS_FIELD, ADDITIONAL_S3_DATA_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trainingImage;
    private final String trainingImageDigest;
    private final List<HyperParameterSpecification> supportedHyperParameters;
    private final List<String> supportedTrainingInstanceTypes;
    private final Boolean supportsDistributedTraining;
    private final List<MetricDefinition> metricDefinitions;
    private final List<ChannelSpecification> trainingChannels;
    private final List<HyperParameterTuningJobObjective> supportedTuningJobObjectiveMetrics;
    private final AdditionalS3DataSource additionalS3DataSource;

    private TrainingSpecification(BuilderImpl builder) {
        this.trainingImage = builder.trainingImage;
        this.trainingImageDigest = builder.trainingImageDigest;
        this.supportedHyperParameters = builder.supportedHyperParameters;
        this.supportedTrainingInstanceTypes = builder.supportedTrainingInstanceTypes;
        this.supportsDistributedTraining = builder.supportsDistributedTraining;
        this.metricDefinitions = builder.metricDefinitions;
        this.trainingChannels = builder.trainingChannels;
        this.supportedTuningJobObjectiveMetrics = builder.supportedTuningJobObjectiveMetrics;
        this.additionalS3DataSource = builder.additionalS3DataSource;
    }

    public final String trainingImage() {
        return this.trainingImage;
    }

    public final String trainingImageDigest() {
        return this.trainingImageDigest;
    }

    public final boolean hasSupportedHyperParameters() {
        return this.supportedHyperParameters != null && !(this.supportedHyperParameters instanceof SdkAutoConstructList);
    }

    public final List<HyperParameterSpecification> supportedHyperParameters() {
        return this.supportedHyperParameters;
    }

    public final List<TrainingInstanceType> supportedTrainingInstanceTypes() {
        return TrainingInstanceTypesCopier.copyStringToEnum(this.supportedTrainingInstanceTypes);
    }

    public final boolean hasSupportedTrainingInstanceTypes() {
        return this.supportedTrainingInstanceTypes != null && !(this.supportedTrainingInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedTrainingInstanceTypesAsStrings() {
        return this.supportedTrainingInstanceTypes;
    }

    public final Boolean supportsDistributedTraining() {
        return this.supportsDistributedTraining;
    }

    public final boolean hasMetricDefinitions() {
        return this.metricDefinitions != null && !(this.metricDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MetricDefinition> metricDefinitions() {
        return this.metricDefinitions;
    }

    public final boolean hasTrainingChannels() {
        return this.trainingChannels != null && !(this.trainingChannels instanceof SdkAutoConstructList);
    }

    public final List<ChannelSpecification> trainingChannels() {
        return this.trainingChannels;
    }

    public final boolean hasSupportedTuningJobObjectiveMetrics() {
        return this.supportedTuningJobObjectiveMetrics != null && !(this.supportedTuningJobObjectiveMetrics instanceof SdkAutoConstructList);
    }

    public final List<HyperParameterTuningJobObjective> supportedTuningJobObjectiveMetrics() {
        return this.supportedTuningJobObjectiveMetrics;
    }

    public final AdditionalS3DataSource additionalS3DataSource() {
        return this.additionalS3DataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingImageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedHyperParameters() ? this.supportedHyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedTrainingInstanceTypes() ? this.supportedTrainingInstanceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsDistributedTraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDefinitions() ? this.metricDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingChannels() ? this.trainingChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedTuningJobObjectiveMetrics() ? this.supportedTuningJobObjectiveMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalS3DataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingSpecification)) {
            return false;
        }
        TrainingSpecification other = (TrainingSpecification)obj;
        return Objects.equals(this.trainingImage(), other.trainingImage()) && Objects.equals(this.trainingImageDigest(), other.trainingImageDigest()) && this.hasSupportedHyperParameters() == other.hasSupportedHyperParameters() && Objects.equals(this.supportedHyperParameters(), other.supportedHyperParameters()) && this.hasSupportedTrainingInstanceTypes() == other.hasSupportedTrainingInstanceTypes() && Objects.equals(this.supportedTrainingInstanceTypesAsStrings(), other.supportedTrainingInstanceTypesAsStrings()) && Objects.equals(this.supportsDistributedTraining(), other.supportsDistributedTraining()) && this.hasMetricDefinitions() == other.hasMetricDefinitions() && Objects.equals(this.metricDefinitions(), other.metricDefinitions()) && this.hasTrainingChannels() == other.hasTrainingChannels() && Objects.equals(this.trainingChannels(), other.trainingChannels()) && this.hasSupportedTuningJobObjectiveMetrics() == other.hasSupportedTuningJobObjectiveMetrics() && Objects.equals(this.supportedTuningJobObjectiveMetrics(), other.supportedTuningJobObjectiveMetrics()) && Objects.equals(this.additionalS3DataSource(), other.additionalS3DataSource());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingSpecification").add("TrainingImage", (Object)this.trainingImage()).add("TrainingImageDigest", (Object)this.trainingImageDigest()).add("SupportedHyperParameters", this.hasSupportedHyperParameters() ? this.supportedHyperParameters() : null).add("SupportedTrainingInstanceTypes", this.hasSupportedTrainingInstanceTypes() ? this.supportedTrainingInstanceTypesAsStrings() : null).add("SupportsDistributedTraining", (Object)this.supportsDistributedTraining()).add("MetricDefinitions", this.hasMetricDefinitions() ? this.metricDefinitions() : null).add("TrainingChannels", this.hasTrainingChannels() ? this.trainingChannels() : null).add("SupportedTuningJobObjectiveMetrics", this.hasSupportedTuningJobObjectiveMetrics() ? this.supportedTuningJobObjectiveMetrics() : null).add("AdditionalS3DataSource", (Object)this.additionalS3DataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingImage": {
                return Optional.ofNullable(clazz.cast(this.trainingImage()));
            }
            case "TrainingImageDigest": {
                return Optional.ofNullable(clazz.cast(this.trainingImageDigest()));
            }
            case "SupportedHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.supportedHyperParameters()));
            }
            case "SupportedTrainingInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedTrainingInstanceTypesAsStrings()));
            }
            case "SupportsDistributedTraining": {
                return Optional.ofNullable(clazz.cast(this.supportsDistributedTraining()));
            }
            case "MetricDefinitions": {
                return Optional.ofNullable(clazz.cast(this.metricDefinitions()));
            }
            case "TrainingChannels": {
                return Optional.ofNullable(clazz.cast(this.trainingChannels()));
            }
            case "SupportedTuningJobObjectiveMetrics": {
                return Optional.ofNullable(clazz.cast(this.supportedTuningJobObjectiveMetrics()));
            }
            case "AdditionalS3DataSource": {
                return Optional.ofNullable(clazz.cast(this.additionalS3DataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingSpecification, T> g) {
        return obj -> g.apply((TrainingSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingImage;
        private String trainingImageDigest;
        private List<HyperParameterSpecification> supportedHyperParameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedTrainingInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsDistributedTraining;
        private List<MetricDefinition> metricDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<ChannelSpecification> trainingChannels = DefaultSdkAutoConstructList.getInstance();
        private List<HyperParameterTuningJobObjective> supportedTuningJobObjectiveMetrics = DefaultSdkAutoConstructList.getInstance();
        private AdditionalS3DataSource additionalS3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingSpecification model) {
            this.trainingImage(model.trainingImage);
            this.trainingImageDigest(model.trainingImageDigest);
            this.supportedHyperParameters(model.supportedHyperParameters);
            this.supportedTrainingInstanceTypesWithStrings(model.supportedTrainingInstanceTypes);
            this.supportsDistributedTraining(model.supportsDistributedTraining);
            this.metricDefinitions(model.metricDefinitions);
            this.trainingChannels(model.trainingChannels);
            this.supportedTuningJobObjectiveMetrics(model.supportedTuningJobObjectiveMetrics);
            this.additionalS3DataSource(model.additionalS3DataSource);
        }

        public final String getTrainingImage() {
            return this.trainingImage;
        }

        public final void setTrainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
        }

        @Override
        public final Builder trainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
            return this;
        }

        public final String getTrainingImageDigest() {
            return this.trainingImageDigest;
        }

        public final void setTrainingImageDigest(String trainingImageDigest) {
            this.trainingImageDigest = trainingImageDigest;
        }

        @Override
        public final Builder trainingImageDigest(String trainingImageDigest) {
            this.trainingImageDigest = trainingImageDigest;
            return this;
        }

        public final List<HyperParameterSpecification.Builder> getSupportedHyperParameters() {
            List<HyperParameterSpecification.Builder> result = HyperParameterSpecificationsCopier.copyToBuilder(this.supportedHyperParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedHyperParameters(Collection<HyperParameterSpecification.BuilderImpl> supportedHyperParameters) {
            this.supportedHyperParameters = HyperParameterSpecificationsCopier.copyFromBuilder(supportedHyperParameters);
        }

        @Override
        public final Builder supportedHyperParameters(Collection<HyperParameterSpecification> supportedHyperParameters) {
            this.supportedHyperParameters = HyperParameterSpecificationsCopier.copy(supportedHyperParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedHyperParameters(HyperParameterSpecification ... supportedHyperParameters) {
            this.supportedHyperParameters(Arrays.asList(supportedHyperParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedHyperParameters(Consumer<HyperParameterSpecification.Builder> ... supportedHyperParameters) {
            this.supportedHyperParameters(Stream.of(supportedHyperParameters).map(c -> (HyperParameterSpecification)((HyperParameterSpecification.Builder)HyperParameterSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedTrainingInstanceTypes() {
            if (this.supportedTrainingInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedTrainingInstanceTypes;
        }

        public final void setSupportedTrainingInstanceTypes(Collection<String> supportedTrainingInstanceTypes) {
            this.supportedTrainingInstanceTypes = TrainingInstanceTypesCopier.copy(supportedTrainingInstanceTypes);
        }

        @Override
        public final Builder supportedTrainingInstanceTypesWithStrings(Collection<String> supportedTrainingInstanceTypes) {
            this.supportedTrainingInstanceTypes = TrainingInstanceTypesCopier.copy(supportedTrainingInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTrainingInstanceTypesWithStrings(String ... supportedTrainingInstanceTypes) {
            this.supportedTrainingInstanceTypesWithStrings(Arrays.asList(supportedTrainingInstanceTypes));
            return this;
        }

        @Override
        public final Builder supportedTrainingInstanceTypes(Collection<TrainingInstanceType> supportedTrainingInstanceTypes) {
            this.supportedTrainingInstanceTypes = TrainingInstanceTypesCopier.copyEnumToString(supportedTrainingInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTrainingInstanceTypes(TrainingInstanceType ... supportedTrainingInstanceTypes) {
            this.supportedTrainingInstanceTypes(Arrays.asList(supportedTrainingInstanceTypes));
            return this;
        }

        public final Boolean getSupportsDistributedTraining() {
            return this.supportsDistributedTraining;
        }

        public final void setSupportsDistributedTraining(Boolean supportsDistributedTraining) {
            this.supportsDistributedTraining = supportsDistributedTraining;
        }

        @Override
        public final Builder supportsDistributedTraining(Boolean supportsDistributedTraining) {
            this.supportsDistributedTraining = supportsDistributedTraining;
            return this;
        }

        public final List<MetricDefinition.Builder> getMetricDefinitions() {
            List<MetricDefinition.Builder> result = MetricDefinitionListCopier.copyToBuilder(this.metricDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDefinitions(Collection<MetricDefinition.BuilderImpl> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionListCopier.copyFromBuilder(metricDefinitions);
        }

        @Override
        public final Builder metricDefinitions(Collection<MetricDefinition> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionListCopier.copy(metricDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(MetricDefinition ... metricDefinitions) {
            this.metricDefinitions(Arrays.asList(metricDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... metricDefinitions) {
            this.metricDefinitions(Stream.of(metricDefinitions).map(c -> (MetricDefinition)((MetricDefinition.Builder)MetricDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ChannelSpecification.Builder> getTrainingChannels() {
            List<ChannelSpecification.Builder> result = ChannelSpecificationsCopier.copyToBuilder(this.trainingChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingChannels(Collection<ChannelSpecification.BuilderImpl> trainingChannels) {
            this.trainingChannels = ChannelSpecificationsCopier.copyFromBuilder(trainingChannels);
        }

        @Override
        public final Builder trainingChannels(Collection<ChannelSpecification> trainingChannels) {
            this.trainingChannels = ChannelSpecificationsCopier.copy(trainingChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingChannels(ChannelSpecification ... trainingChannels) {
            this.trainingChannels(Arrays.asList(trainingChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingChannels(Consumer<ChannelSpecification.Builder> ... trainingChannels) {
            this.trainingChannels(Stream.of(trainingChannels).map(c -> (ChannelSpecification)((ChannelSpecification.Builder)ChannelSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HyperParameterTuningJobObjective.Builder> getSupportedTuningJobObjectiveMetrics() {
            List<HyperParameterTuningJobObjective.Builder> result = HyperParameterTuningJobObjectivesCopier.copyToBuilder(this.supportedTuningJobObjectiveMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedTuningJobObjectiveMetrics(Collection<HyperParameterTuningJobObjective.BuilderImpl> supportedTuningJobObjectiveMetrics) {
            this.supportedTuningJobObjectiveMetrics = HyperParameterTuningJobObjectivesCopier.copyFromBuilder(supportedTuningJobObjectiveMetrics);
        }

        @Override
        public final Builder supportedTuningJobObjectiveMetrics(Collection<HyperParameterTuningJobObjective> supportedTuningJobObjectiveMetrics) {
            this.supportedTuningJobObjectiveMetrics = HyperParameterTuningJobObjectivesCopier.copy(supportedTuningJobObjectiveMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTuningJobObjectiveMetrics(HyperParameterTuningJobObjective ... supportedTuningJobObjectiveMetrics) {
            this.supportedTuningJobObjectiveMetrics(Arrays.asList(supportedTuningJobObjectiveMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTuningJobObjectiveMetrics(Consumer<HyperParameterTuningJobObjective.Builder> ... supportedTuningJobObjectiveMetrics) {
            this.supportedTuningJobObjectiveMetrics(Stream.of(supportedTuningJobObjectiveMetrics).map(c -> (HyperParameterTuningJobObjective)((HyperParameterTuningJobObjective.Builder)HyperParameterTuningJobObjective.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AdditionalS3DataSource.Builder getAdditionalS3DataSource() {
            return this.additionalS3DataSource != null ? this.additionalS3DataSource.toBuilder() : null;
        }

        public final void setAdditionalS3DataSource(AdditionalS3DataSource.BuilderImpl additionalS3DataSource) {
            this.additionalS3DataSource = additionalS3DataSource != null ? additionalS3DataSource.build() : null;
        }

        @Override
        public final Builder additionalS3DataSource(AdditionalS3DataSource additionalS3DataSource) {
            this.additionalS3DataSource = additionalS3DataSource;
            return this;
        }

        public TrainingSpecification build() {
            return new TrainingSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingSpecification> {
        public Builder trainingImage(String var1);

        public Builder trainingImageDigest(String var1);

        public Builder supportedHyperParameters(Collection<HyperParameterSpecification> var1);

        public Builder supportedHyperParameters(HyperParameterSpecification ... var1);

        public Builder supportedHyperParameters(Consumer<HyperParameterSpecification.Builder> ... var1);

        public Builder supportedTrainingInstanceTypesWithStrings(Collection<String> var1);

        public Builder supportedTrainingInstanceTypesWithStrings(String ... var1);

        public Builder supportedTrainingInstanceTypes(Collection<TrainingInstanceType> var1);

        public Builder supportedTrainingInstanceTypes(TrainingInstanceType ... var1);

        public Builder supportsDistributedTraining(Boolean var1);

        public Builder metricDefinitions(Collection<MetricDefinition> var1);

        public Builder metricDefinitions(MetricDefinition ... var1);

        public Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... var1);

        public Builder trainingChannels(Collection<ChannelSpecification> var1);

        public Builder trainingChannels(ChannelSpecification ... var1);

        public Builder trainingChannels(Consumer<ChannelSpecification.Builder> ... var1);

        public Builder supportedTuningJobObjectiveMetrics(Collection<HyperParameterTuningJobObjective> var1);

        public Builder supportedTuningJobObjectiveMetrics(HyperParameterTuningJobObjective ... var1);

        public Builder supportedTuningJobObjectiveMetrics(Consumer<HyperParameterTuningJobObjective.Builder> ... var1);

        public Builder additionalS3DataSource(AdditionalS3DataSource var1);

        default public Builder additionalS3DataSource(Consumer<AdditionalS3DataSource.Builder> additionalS3DataSource) {
            return this.additionalS3DataSource((AdditionalS3DataSource)((AdditionalS3DataSource.Builder)AdditionalS3DataSource.builder().applyMutation(additionalS3DataSource)).build());
        }
    }
}

