/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary;

public class ListMonitoringAlertsIterable
implements SdkIterable<ListMonitoringAlertsResponse> {
    private final SageMakerClient client;
    private final ListMonitoringAlertsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMonitoringAlertsIterable(SageMakerClient client, ListMonitoringAlertsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMonitoringAlertsResponseFetcher();
    }

    public Iterator<ListMonitoringAlertsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitoringAlertSummary> monitoringAlertSummaries() {
        Function<ListMonitoringAlertsResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoringAlertSummaries() != null) {
                return response.monitoringAlertSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMonitoringAlertsResponseFetcher
    implements SyncPageFetcher<ListMonitoringAlertsResponse> {
        private ListMonitoringAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoringAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMonitoringAlertsResponse nextPage(ListMonitoringAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoringAlertsIterable.this.client.listMonitoringAlerts(ListMonitoringAlertsIterable.this.firstRequest);
            }
            return ListMonitoringAlertsIterable.this.client.listMonitoringAlerts((ListMonitoringAlertsRequest)((Object)ListMonitoringAlertsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

