/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria;
import software.amazon.awssdk.services.sagemaker.model.ForecastQuantilesCopier;
import software.amazon.awssdk.services.sagemaker.model.TimeSeriesConfig;
import software.amazon.awssdk.services.sagemaker.model.TimeSeriesTransformations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSeriesForecastingJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSeriesForecastingJobConfig> {
    private static final SdkField<String> FEATURE_SPECIFICATION_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureSpecificationS3Uri").getter(TimeSeriesForecastingJobConfig.getter(TimeSeriesForecastingJobConfig::featureSpecificationS3Uri)).setter(TimeSeriesForecastingJobConfig.setter(Builder::featureSpecificationS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureSpecificationS3Uri").build()}).build();
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CompletionCriteria").getter(TimeSeriesForecastingJobConfig.getter(TimeSeriesForecastingJobConfig::completionCriteria)).setter(TimeSeriesForecastingJobConfig.setter(Builder::completionCriteria)).constructor(AutoMLJobCompletionCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build()}).build();
    private static final SdkField<String> FORECAST_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastFrequency").getter(TimeSeriesForecastingJobConfig.getter(TimeSeriesForecastingJobConfig::forecastFrequency)).setter(TimeSeriesForecastingJobConfig.setter(Builder::forecastFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastFrequency").build()}).build();
    private static final SdkField<Integer> FORECAST_HORIZON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ForecastHorizon").getter(TimeSeriesForecastingJobConfig.getter(TimeSeriesForecastingJobConfig::forecastHorizon)).setter(TimeSeriesForecastingJobConfig.setter(Builder::forecastHorizon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastHorizon").build()}).build();
    private static final SdkField<List<String>> FORECAST_QUANTILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastQuantiles").getter(TimeSeriesForecastingJobConfig.getter(TimeSeriesForecastingJobConfig::forecastQuantiles)).setter(TimeSeriesForecastingJobConfig.setter(Builder::forecastQuantiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastQuantiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimeSeriesTransformations> TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Transformations").getter(TimeSeriesForecastingJobConfig.getter(TimeSeriesForecastingJobConfig::transformations)).setter(TimeSeriesForecastingJobConfig.setter(Builder::transformations)).constructor(TimeSeriesTransformations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transformations").build()}).build();
    private static final SdkField<TimeSeriesConfig> TIME_SERIES_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSeriesConfig").getter(TimeSeriesForecastingJobConfig.getter(TimeSeriesForecastingJobConfig::timeSeriesConfig)).setter(TimeSeriesForecastingJobConfig.setter(Builder::timeSeriesConfig)).constructor(TimeSeriesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_SPECIFICATION_S3_URI_FIELD, COMPLETION_CRITERIA_FIELD, FORECAST_FREQUENCY_FIELD, FORECAST_HORIZON_FIELD, FORECAST_QUANTILES_FIELD, TRANSFORMATIONS_FIELD, TIME_SERIES_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String featureSpecificationS3Uri;
    private final AutoMLJobCompletionCriteria completionCriteria;
    private final String forecastFrequency;
    private final Integer forecastHorizon;
    private final List<String> forecastQuantiles;
    private final TimeSeriesTransformations transformations;
    private final TimeSeriesConfig timeSeriesConfig;

    private TimeSeriesForecastingJobConfig(BuilderImpl builder) {
        this.featureSpecificationS3Uri = builder.featureSpecificationS3Uri;
        this.completionCriteria = builder.completionCriteria;
        this.forecastFrequency = builder.forecastFrequency;
        this.forecastHorizon = builder.forecastHorizon;
        this.forecastQuantiles = builder.forecastQuantiles;
        this.transformations = builder.transformations;
        this.timeSeriesConfig = builder.timeSeriesConfig;
    }

    public final String featureSpecificationS3Uri() {
        return this.featureSpecificationS3Uri;
    }

    public final AutoMLJobCompletionCriteria completionCriteria() {
        return this.completionCriteria;
    }

    public final String forecastFrequency() {
        return this.forecastFrequency;
    }

    public final Integer forecastHorizon() {
        return this.forecastHorizon;
    }

    public final boolean hasForecastQuantiles() {
        return this.forecastQuantiles != null && !(this.forecastQuantiles instanceof SdkAutoConstructList);
    }

    public final List<String> forecastQuantiles() {
        return this.forecastQuantiles;
    }

    public final TimeSeriesTransformations transformations() {
        return this.transformations;
    }

    public final TimeSeriesConfig timeSeriesConfig() {
        return this.timeSeriesConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureSpecificationS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastHorizon());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastQuantiles() ? this.forecastQuantiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transformations());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesForecastingJobConfig)) {
            return false;
        }
        TimeSeriesForecastingJobConfig other = (TimeSeriesForecastingJobConfig)obj;
        return Objects.equals(this.featureSpecificationS3Uri(), other.featureSpecificationS3Uri()) && Objects.equals(this.completionCriteria(), other.completionCriteria()) && Objects.equals(this.forecastFrequency(), other.forecastFrequency()) && Objects.equals(this.forecastHorizon(), other.forecastHorizon()) && this.hasForecastQuantiles() == other.hasForecastQuantiles() && Objects.equals(this.forecastQuantiles(), other.forecastQuantiles()) && Objects.equals(this.transformations(), other.transformations()) && Objects.equals(this.timeSeriesConfig(), other.timeSeriesConfig());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSeriesForecastingJobConfig").add("FeatureSpecificationS3Uri", (Object)this.featureSpecificationS3Uri()).add("CompletionCriteria", (Object)this.completionCriteria()).add("ForecastFrequency", (Object)this.forecastFrequency()).add("ForecastHorizon", (Object)this.forecastHorizon()).add("ForecastQuantiles", this.hasForecastQuantiles() ? this.forecastQuantiles() : null).add("Transformations", (Object)this.transformations()).add("TimeSeriesConfig", (Object)this.timeSeriesConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureSpecificationS3Uri": {
                return Optional.ofNullable(clazz.cast(this.featureSpecificationS3Uri()));
            }
            case "CompletionCriteria": {
                return Optional.ofNullable(clazz.cast(this.completionCriteria()));
            }
            case "ForecastFrequency": {
                return Optional.ofNullable(clazz.cast(this.forecastFrequency()));
            }
            case "ForecastHorizon": {
                return Optional.ofNullable(clazz.cast(this.forecastHorizon()));
            }
            case "ForecastQuantiles": {
                return Optional.ofNullable(clazz.cast(this.forecastQuantiles()));
            }
            case "Transformations": {
                return Optional.ofNullable(clazz.cast(this.transformations()));
            }
            case "TimeSeriesConfig": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesForecastingJobConfig, T> g) {
        return obj -> g.apply((TimeSeriesForecastingJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featureSpecificationS3Uri;
        private AutoMLJobCompletionCriteria completionCriteria;
        private String forecastFrequency;
        private Integer forecastHorizon;
        private List<String> forecastQuantiles = DefaultSdkAutoConstructList.getInstance();
        private TimeSeriesTransformations transformations;
        private TimeSeriesConfig timeSeriesConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesForecastingJobConfig model) {
            this.featureSpecificationS3Uri(model.featureSpecificationS3Uri);
            this.completionCriteria(model.completionCriteria);
            this.forecastFrequency(model.forecastFrequency);
            this.forecastHorizon(model.forecastHorizon);
            this.forecastQuantiles(model.forecastQuantiles);
            this.transformations(model.transformations);
            this.timeSeriesConfig(model.timeSeriesConfig);
        }

        public final String getFeatureSpecificationS3Uri() {
            return this.featureSpecificationS3Uri;
        }

        public final void setFeatureSpecificationS3Uri(String featureSpecificationS3Uri) {
            this.featureSpecificationS3Uri = featureSpecificationS3Uri;
        }

        @Override
        public final Builder featureSpecificationS3Uri(String featureSpecificationS3Uri) {
            this.featureSpecificationS3Uri = featureSpecificationS3Uri;
            return this;
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return this.completionCriteria != null ? this.completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final String getForecastFrequency() {
            return this.forecastFrequency;
        }

        public final void setForecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
        }

        @Override
        public final Builder forecastFrequency(String forecastFrequency) {
            this.forecastFrequency = forecastFrequency;
            return this;
        }

        public final Integer getForecastHorizon() {
            return this.forecastHorizon;
        }

        public final void setForecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
        }

        @Override
        public final Builder forecastHorizon(Integer forecastHorizon) {
            this.forecastHorizon = forecastHorizon;
            return this;
        }

        public final Collection<String> getForecastQuantiles() {
            if (this.forecastQuantiles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.forecastQuantiles;
        }

        public final void setForecastQuantiles(Collection<String> forecastQuantiles) {
            this.forecastQuantiles = ForecastQuantilesCopier.copy(forecastQuantiles);
        }

        @Override
        public final Builder forecastQuantiles(Collection<String> forecastQuantiles) {
            this.forecastQuantiles = ForecastQuantilesCopier.copy(forecastQuantiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastQuantiles(String ... forecastQuantiles) {
            this.forecastQuantiles(Arrays.asList(forecastQuantiles));
            return this;
        }

        public final TimeSeriesTransformations.Builder getTransformations() {
            return this.transformations != null ? this.transformations.toBuilder() : null;
        }

        public final void setTransformations(TimeSeriesTransformations.BuilderImpl transformations) {
            this.transformations = transformations != null ? transformations.build() : null;
        }

        @Override
        public final Builder transformations(TimeSeriesTransformations transformations) {
            this.transformations = transformations;
            return this;
        }

        public final TimeSeriesConfig.Builder getTimeSeriesConfig() {
            return this.timeSeriesConfig != null ? this.timeSeriesConfig.toBuilder() : null;
        }

        public final void setTimeSeriesConfig(TimeSeriesConfig.BuilderImpl timeSeriesConfig) {
            this.timeSeriesConfig = timeSeriesConfig != null ? timeSeriesConfig.build() : null;
        }

        @Override
        public final Builder timeSeriesConfig(TimeSeriesConfig timeSeriesConfig) {
            this.timeSeriesConfig = timeSeriesConfig;
            return this;
        }

        public TimeSeriesForecastingJobConfig build() {
            return new TimeSeriesForecastingJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSeriesForecastingJobConfig> {
        public Builder featureSpecificationS3Uri(String var1);

        public Builder completionCriteria(AutoMLJobCompletionCriteria var1);

        default public Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return this.completionCriteria((AutoMLJobCompletionCriteria)((AutoMLJobCompletionCriteria.Builder)AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria)).build());
        }

        public Builder forecastFrequency(String var1);

        public Builder forecastHorizon(Integer var1);

        public Builder forecastQuantiles(Collection<String> var1);

        public Builder forecastQuantiles(String ... var1);

        public Builder transformations(TimeSeriesTransformations var1);

        default public Builder transformations(Consumer<TimeSeriesTransformations.Builder> transformations) {
            return this.transformations((TimeSeriesTransformations)((TimeSeriesTransformations.Builder)TimeSeriesTransformations.builder().applyMutation(transformations)).build());
        }

        public Builder timeSeriesConfig(TimeSeriesConfig var1);

        default public Builder timeSeriesConfig(Consumer<TimeSeriesConfig.Builder> timeSeriesConfig) {
            return this.timeSeriesConfig((TimeSeriesConfig)((TimeSeriesConfig.Builder)TimeSeriesConfig.builder().applyMutation(timeSeriesConfig)).build());
        }
    }
}

