/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailureHandlingPolicy {
    ROLLBACK_ON_FAILURE("ROLLBACK_ON_FAILURE"),
    DO_NOTHING("DO_NOTHING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailureHandlingPolicy> VALUE_MAP;
    private final String value;

    private FailureHandlingPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailureHandlingPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailureHandlingPolicy> knownValues() {
        EnumSet<FailureHandlingPolicy> knownValues = EnumSet.allOf(FailureHandlingPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailureHandlingPolicy.class, FailureHandlingPolicy::toString);
    }
}

