/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ContextSummary;
import software.amazon.awssdk.services.sagemaker.model.ListContextsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListContextsResponse;

public class ListContextsPublisher
implements SdkPublisher<ListContextsResponse> {
    private final SageMakerAsyncClient client;
    private final ListContextsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContextsPublisher(SageMakerAsyncClient client, ListContextsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContextsPublisher(SageMakerAsyncClient client, ListContextsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContextsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContextsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContextSummary> contextSummaries() {
        Function<ListContextsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contextSummaries() != null) {
                return response.contextSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContextsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContextsResponseFetcher
    implements AsyncPageFetcher<ListContextsResponse> {
        private ListContextsResponseFetcher() {
        }

        public boolean hasNextPage(ListContextsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContextsResponse> nextPage(ListContextsResponse previousPage) {
            if (previousPage == null) {
                return ListContextsPublisher.this.client.listContexts(ListContextsPublisher.this.firstRequest);
            }
            return ListContextsPublisher.this.client.listContexts((ListContextsRequest)((Object)ListContextsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

