/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleConfigSummary;

public class ListNotebookInstanceLifecycleConfigsPublisher
implements SdkPublisher<ListNotebookInstanceLifecycleConfigsResponse> {
    private final SageMakerAsyncClient client;
    private final ListNotebookInstanceLifecycleConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotebookInstanceLifecycleConfigsPublisher(SageMakerAsyncClient client, ListNotebookInstanceLifecycleConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotebookInstanceLifecycleConfigsPublisher(SageMakerAsyncClient client, ListNotebookInstanceLifecycleConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotebookInstanceLifecycleConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotebookInstanceLifecycleConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs() {
        Function<ListNotebookInstanceLifecycleConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notebookInstanceLifecycleConfigs() != null) {
                return response.notebookInstanceLifecycleConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNotebookInstanceLifecycleConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNotebookInstanceLifecycleConfigsResponseFetcher
    implements AsyncPageFetcher<ListNotebookInstanceLifecycleConfigsResponse> {
        private ListNotebookInstanceLifecycleConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotebookInstanceLifecycleConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNotebookInstanceLifecycleConfigsResponse> nextPage(ListNotebookInstanceLifecycleConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListNotebookInstanceLifecycleConfigsPublisher.this.client.listNotebookInstanceLifecycleConfigs(ListNotebookInstanceLifecycleConfigsPublisher.this.firstRequest);
            }
            return ListNotebookInstanceLifecycleConfigsPublisher.this.client.listNotebookInstanceLifecycleConfigs((ListNotebookInstanceLifecycleConfigsRequest)((Object)ListNotebookInstanceLifecycleConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

