/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ProjectSummary;
import software.amazon.awssdk.services.sagemaker.model.ProjectSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProjectsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListProjectsResponse> {
    private static final SdkField<List<ProjectSummary>> PROJECT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProjectSummaryList").getter(ListProjectsResponse.getter(ListProjectsResponse::projectSummaryList)).setter(ListProjectsResponse.setter(Builder::projectSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProjectsResponse.getter(ListProjectsResponse::nextToken)).setter(ListProjectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ProjectSummary> projectSummaryList;
    private final String nextToken;

    private ListProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projectSummaryList = builder.projectSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProjectSummaryList() {
        return this.projectSummaryList != null && !(this.projectSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ProjectSummary> projectSummaryList() {
        return this.projectSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectSummaryList() ? this.projectSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResponse)) {
            return false;
        }
        ListProjectsResponse other = (ListProjectsResponse)((Object)obj);
        return this.hasProjectSummaryList() == other.hasProjectSummaryList() && Objects.equals(this.projectSummaryList(), other.projectSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProjectsResponse").add("ProjectSummaryList", this.hasProjectSummaryList() ? this.projectSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectSummaryList": {
                return Optional.ofNullable(clazz.cast(this.projectSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProjectsResponse, T> g) {
        return obj -> g.apply((ListProjectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ProjectSummary> projectSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsResponse model) {
            super(model);
            this.projectSummaryList(model.projectSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<ProjectSummary.Builder> getProjectSummaryList() {
            List<ProjectSummary.Builder> result = ProjectSummaryListCopier.copyToBuilder(this.projectSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectSummaryList(Collection<ProjectSummary.BuilderImpl> projectSummaryList) {
            this.projectSummaryList = ProjectSummaryListCopier.copyFromBuilder(projectSummaryList);
        }

        @Override
        @Transient
        public final Builder projectSummaryList(Collection<ProjectSummary> projectSummaryList) {
            this.projectSummaryList = ProjectSummaryListCopier.copy(projectSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder projectSummaryList(ProjectSummary ... projectSummaryList) {
            this.projectSummaryList(Arrays.asList(projectSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder projectSummaryList(Consumer<ProjectSummary.Builder> ... projectSummaryList) {
            this.projectSummaryList(Stream.of(projectSummaryList).map(c -> (ProjectSummary)((ProjectSummary.Builder)ProjectSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProjectsResponse build() {
            return new ListProjectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProjectsResponse> {
        public Builder projectSummaryList(Collection<ProjectSummary> var1);

        public Builder projectSummaryList(ProjectSummary ... var1);

        public Builder projectSummaryList(Consumer<ProjectSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

