/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLabelingJobsForWorkteamRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListLabelingJobsForWorkteamRequest> {
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkteamArn").getter(ListLabelingJobsForWorkteamRequest.getter(ListLabelingJobsForWorkteamRequest::workteamArn)).setter(ListLabelingJobsForWorkteamRequest.setter(Builder::workteamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListLabelingJobsForWorkteamRequest.getter(ListLabelingJobsForWorkteamRequest::maxResults)).setter(ListLabelingJobsForWorkteamRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLabelingJobsForWorkteamRequest.getter(ListLabelingJobsForWorkteamRequest::nextToken)).setter(ListLabelingJobsForWorkteamRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeAfter").getter(ListLabelingJobsForWorkteamRequest.getter(ListLabelingJobsForWorkteamRequest::creationTimeAfter)).setter(ListLabelingJobsForWorkteamRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeBefore").getter(ListLabelingJobsForWorkteamRequest.getter(ListLabelingJobsForWorkteamRequest::creationTimeBefore)).setter(ListLabelingJobsForWorkteamRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<String> JOB_REFERENCE_CODE_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobReferenceCodeContains").getter(ListLabelingJobsForWorkteamRequest.getter(ListLabelingJobsForWorkteamRequest::jobReferenceCodeContains)).setter(ListLabelingJobsForWorkteamRequest.setter(Builder::jobReferenceCodeContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobReferenceCodeContains").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListLabelingJobsForWorkteamRequest.getter(ListLabelingJobsForWorkteamRequest::sortByAsString)).setter(ListLabelingJobsForWorkteamRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListLabelingJobsForWorkteamRequest.getter(ListLabelingJobsForWorkteamRequest::sortOrderAsString)).setter(ListLabelingJobsForWorkteamRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, JOB_REFERENCE_CODE_CONTAINS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private final String workteamArn;
    private final Integer maxResults;
    private final String nextToken;
    private final Instant creationTimeAfter;
    private final Instant creationTimeBefore;
    private final String jobReferenceCodeContains;
    private final String sortBy;
    private final String sortOrder;

    private ListLabelingJobsForWorkteamRequest(BuilderImpl builder) {
        super(builder);
        this.workteamArn = builder.workteamArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.jobReferenceCodeContains = builder.jobReferenceCodeContains;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final String workteamArn() {
        return this.workteamArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final String jobReferenceCodeContains() {
        return this.jobReferenceCodeContains;
    }

    public final ListLabelingJobsForWorkteamSortByOptions sortBy() {
        return ListLabelingJobsForWorkteamSortByOptions.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobReferenceCodeContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelingJobsForWorkteamRequest)) {
            return false;
        }
        ListLabelingJobsForWorkteamRequest other = (ListLabelingJobsForWorkteamRequest)((Object)obj);
        return Objects.equals(this.workteamArn(), other.workteamArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.jobReferenceCodeContains(), other.jobReferenceCodeContains()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListLabelingJobsForWorkteamRequest").add("WorkteamArn", (Object)this.workteamArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("JobReferenceCodeContains", (Object)this.jobReferenceCodeContains()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkteamArn": {
                return Optional.ofNullable(clazz.cast(this.workteamArn()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "JobReferenceCodeContains": {
                return Optional.ofNullable(clazz.cast(this.jobReferenceCodeContains()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLabelingJobsForWorkteamRequest, T> g) {
        return obj -> g.apply((ListLabelingJobsForWorkteamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String workteamArn;
        private Integer maxResults;
        private String nextToken;
        private Instant creationTimeAfter;
        private Instant creationTimeBefore;
        private String jobReferenceCodeContains;
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelingJobsForWorkteamRequest model) {
            super(model);
            this.workteamArn(model.workteamArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.creationTimeAfter(model.creationTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
            this.jobReferenceCodeContains(model.jobReferenceCodeContains);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final String getWorkteamArn() {
            return this.workteamArn;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        @Override
        @Transient
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        @Transient
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        @Transient
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final String getJobReferenceCodeContains() {
            return this.jobReferenceCodeContains;
        }

        public final void setJobReferenceCodeContains(String jobReferenceCodeContains) {
            this.jobReferenceCodeContains = jobReferenceCodeContains;
        }

        @Override
        @Transient
        public final Builder jobReferenceCodeContains(String jobReferenceCodeContains) {
            this.jobReferenceCodeContains = jobReferenceCodeContains;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        @Transient
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        @Transient
        public final Builder sortBy(ListLabelingJobsForWorkteamSortByOptions sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        @Transient
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        @Transient
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLabelingJobsForWorkteamRequest build() {
            return new ListLabelingJobsForWorkteamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLabelingJobsForWorkteamRequest> {
        public Builder workteamArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder jobReferenceCodeContains(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ListLabelingJobsForWorkteamSortByOptions var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

