/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FlowDefinitionOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus;
import software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConfig;
import software.amazon.awssdk.services.sagemaker.model.HumanLoopConfig;
import software.amazon.awssdk.services.sagemaker.model.HumanLoopRequestSource;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFlowDefinitionResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeFlowDefinitionResponse> {
    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowDefinitionArn").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::flowDefinitionArn)).setter(DescribeFlowDefinitionResponse.setter(Builder::flowDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()}).build();
    private static final SdkField<String> FLOW_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowDefinitionName").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::flowDefinitionName)).setter(DescribeFlowDefinitionResponse.setter(Builder::flowDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionName").build()}).build();
    private static final SdkField<String> FLOW_DEFINITION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowDefinitionStatus").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::flowDefinitionStatusAsString)).setter(DescribeFlowDefinitionResponse.setter(Builder::flowDefinitionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::creationTime)).setter(DescribeFlowDefinitionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<HumanLoopRequestSource> HUMAN_LOOP_REQUEST_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopRequestSource").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::humanLoopRequestSource)).setter(DescribeFlowDefinitionResponse.setter(Builder::humanLoopRequestSource)).constructor(HumanLoopRequestSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopRequestSource").build()}).build();
    private static final SdkField<HumanLoopActivationConfig> HUMAN_LOOP_ACTIVATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopActivationConfig").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::humanLoopActivationConfig)).setter(DescribeFlowDefinitionResponse.setter(Builder::humanLoopActivationConfig)).constructor(HumanLoopActivationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationConfig").build()}).build();
    private static final SdkField<HumanLoopConfig> HUMAN_LOOP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopConfig").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::humanLoopConfig)).setter(DescribeFlowDefinitionResponse.setter(Builder::humanLoopConfig)).constructor(HumanLoopConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopConfig").build()}).build();
    private static final SdkField<FlowDefinitionOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::outputConfig)).setter(DescribeFlowDefinitionResponse.setter(Builder::outputConfig)).constructor(FlowDefinitionOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::roleArn)).setter(DescribeFlowDefinitionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeFlowDefinitionResponse.getter(DescribeFlowDefinitionResponse::failureReason)).setter(DescribeFlowDefinitionResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_ARN_FIELD, FLOW_DEFINITION_NAME_FIELD, FLOW_DEFINITION_STATUS_FIELD, CREATION_TIME_FIELD, HUMAN_LOOP_REQUEST_SOURCE_FIELD, HUMAN_LOOP_ACTIVATION_CONFIG_FIELD, HUMAN_LOOP_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, ROLE_ARN_FIELD, FAILURE_REASON_FIELD));
    private final String flowDefinitionArn;
    private final String flowDefinitionName;
    private final String flowDefinitionStatus;
    private final Instant creationTime;
    private final HumanLoopRequestSource humanLoopRequestSource;
    private final HumanLoopActivationConfig humanLoopActivationConfig;
    private final HumanLoopConfig humanLoopConfig;
    private final FlowDefinitionOutputConfig outputConfig;
    private final String roleArn;
    private final String failureReason;

    private DescribeFlowDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.flowDefinitionName = builder.flowDefinitionName;
        this.flowDefinitionStatus = builder.flowDefinitionStatus;
        this.creationTime = builder.creationTime;
        this.humanLoopRequestSource = builder.humanLoopRequestSource;
        this.humanLoopActivationConfig = builder.humanLoopActivationConfig;
        this.humanLoopConfig = builder.humanLoopConfig;
        this.outputConfig = builder.outputConfig;
        this.roleArn = builder.roleArn;
        this.failureReason = builder.failureReason;
    }

    public final String flowDefinitionArn() {
        return this.flowDefinitionArn;
    }

    public final String flowDefinitionName() {
        return this.flowDefinitionName;
    }

    public final FlowDefinitionStatus flowDefinitionStatus() {
        return FlowDefinitionStatus.fromValue(this.flowDefinitionStatus);
    }

    public final String flowDefinitionStatusAsString() {
        return this.flowDefinitionStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final HumanLoopRequestSource humanLoopRequestSource() {
        return this.humanLoopRequestSource;
    }

    public final HumanLoopActivationConfig humanLoopActivationConfig() {
        return this.humanLoopActivationConfig;
    }

    public final HumanLoopConfig humanLoopConfig() {
        return this.humanLoopConfig;
    }

    public final FlowDefinitionOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopRequestSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopActivationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowDefinitionResponse)) {
            return false;
        }
        DescribeFlowDefinitionResponse other = (DescribeFlowDefinitionResponse)((Object)obj);
        return Objects.equals(this.flowDefinitionArn(), other.flowDefinitionArn()) && Objects.equals(this.flowDefinitionName(), other.flowDefinitionName()) && Objects.equals(this.flowDefinitionStatusAsString(), other.flowDefinitionStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.humanLoopRequestSource(), other.humanLoopRequestSource()) && Objects.equals(this.humanLoopActivationConfig(), other.humanLoopActivationConfig()) && Objects.equals(this.humanLoopConfig(), other.humanLoopConfig()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFlowDefinitionResponse").add("FlowDefinitionArn", (Object)this.flowDefinitionArn()).add("FlowDefinitionName", (Object)this.flowDefinitionName()).add("FlowDefinitionStatus", (Object)this.flowDefinitionStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("HumanLoopRequestSource", (Object)this.humanLoopRequestSource()).add("HumanLoopActivationConfig", (Object)this.humanLoopActivationConfig()).add("HumanLoopConfig", (Object)this.humanLoopConfig()).add("OutputConfig", (Object)this.outputConfig()).add("RoleArn", (Object)this.roleArn()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionArn()));
            }
            case "FlowDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionName()));
            }
            case "FlowDefinitionStatus": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "HumanLoopRequestSource": {
                return Optional.ofNullable(clazz.cast(this.humanLoopRequestSource()));
            }
            case "HumanLoopActivationConfig": {
                return Optional.ofNullable(clazz.cast(this.humanLoopActivationConfig()));
            }
            case "HumanLoopConfig": {
                return Optional.ofNullable(clazz.cast(this.humanLoopConfig()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeFlowDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String flowDefinitionArn;
        private String flowDefinitionName;
        private String flowDefinitionStatus;
        private Instant creationTime;
        private HumanLoopRequestSource humanLoopRequestSource;
        private HumanLoopActivationConfig humanLoopActivationConfig;
        private HumanLoopConfig humanLoopConfig;
        private FlowDefinitionOutputConfig outputConfig;
        private String roleArn;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowDefinitionResponse model) {
            super(model);
            this.flowDefinitionArn(model.flowDefinitionArn);
            this.flowDefinitionName(model.flowDefinitionName);
            this.flowDefinitionStatus(model.flowDefinitionStatus);
            this.creationTime(model.creationTime);
            this.humanLoopRequestSource(model.humanLoopRequestSource);
            this.humanLoopActivationConfig(model.humanLoopActivationConfig);
            this.humanLoopConfig(model.humanLoopConfig);
            this.outputConfig(model.outputConfig);
            this.roleArn(model.roleArn);
            this.failureReason(model.failureReason);
        }

        public final String getFlowDefinitionArn() {
            return this.flowDefinitionArn;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        @Override
        @Transient
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final String getFlowDefinitionName() {
            return this.flowDefinitionName;
        }

        public final void setFlowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
        }

        @Override
        @Transient
        public final Builder flowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
            return this;
        }

        public final String getFlowDefinitionStatus() {
            return this.flowDefinitionStatus;
        }

        public final void setFlowDefinitionStatus(String flowDefinitionStatus) {
            this.flowDefinitionStatus = flowDefinitionStatus;
        }

        @Override
        @Transient
        public final Builder flowDefinitionStatus(String flowDefinitionStatus) {
            this.flowDefinitionStatus = flowDefinitionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder flowDefinitionStatus(FlowDefinitionStatus flowDefinitionStatus) {
            this.flowDefinitionStatus(flowDefinitionStatus == null ? null : flowDefinitionStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final HumanLoopRequestSource.Builder getHumanLoopRequestSource() {
            return this.humanLoopRequestSource != null ? this.humanLoopRequestSource.toBuilder() : null;
        }

        public final void setHumanLoopRequestSource(HumanLoopRequestSource.BuilderImpl humanLoopRequestSource) {
            this.humanLoopRequestSource = humanLoopRequestSource != null ? humanLoopRequestSource.build() : null;
        }

        @Override
        @Transient
        public final Builder humanLoopRequestSource(HumanLoopRequestSource humanLoopRequestSource) {
            this.humanLoopRequestSource = humanLoopRequestSource;
            return this;
        }

        public final HumanLoopActivationConfig.Builder getHumanLoopActivationConfig() {
            return this.humanLoopActivationConfig != null ? this.humanLoopActivationConfig.toBuilder() : null;
        }

        public final void setHumanLoopActivationConfig(HumanLoopActivationConfig.BuilderImpl humanLoopActivationConfig) {
            this.humanLoopActivationConfig = humanLoopActivationConfig != null ? humanLoopActivationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder humanLoopActivationConfig(HumanLoopActivationConfig humanLoopActivationConfig) {
            this.humanLoopActivationConfig = humanLoopActivationConfig;
            return this;
        }

        public final HumanLoopConfig.Builder getHumanLoopConfig() {
            return this.humanLoopConfig != null ? this.humanLoopConfig.toBuilder() : null;
        }

        public final void setHumanLoopConfig(HumanLoopConfig.BuilderImpl humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig != null ? humanLoopConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder humanLoopConfig(HumanLoopConfig humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig;
            return this;
        }

        public final FlowDefinitionOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(FlowDefinitionOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputConfig(FlowDefinitionOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public DescribeFlowDefinitionResponse build() {
            return new DescribeFlowDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFlowDefinitionResponse> {
        public Builder flowDefinitionArn(String var1);

        public Builder flowDefinitionName(String var1);

        public Builder flowDefinitionStatus(String var1);

        public Builder flowDefinitionStatus(FlowDefinitionStatus var1);

        public Builder creationTime(Instant var1);

        public Builder humanLoopRequestSource(HumanLoopRequestSource var1);

        default public Builder humanLoopRequestSource(Consumer<HumanLoopRequestSource.Builder> humanLoopRequestSource) {
            return this.humanLoopRequestSource((HumanLoopRequestSource)((HumanLoopRequestSource.Builder)HumanLoopRequestSource.builder().applyMutation(humanLoopRequestSource)).build());
        }

        public Builder humanLoopActivationConfig(HumanLoopActivationConfig var1);

        default public Builder humanLoopActivationConfig(Consumer<HumanLoopActivationConfig.Builder> humanLoopActivationConfig) {
            return this.humanLoopActivationConfig((HumanLoopActivationConfig)((HumanLoopActivationConfig.Builder)HumanLoopActivationConfig.builder().applyMutation(humanLoopActivationConfig)).build());
        }

        public Builder humanLoopConfig(HumanLoopConfig var1);

        default public Builder humanLoopConfig(Consumer<HumanLoopConfig.Builder> humanLoopConfig) {
            return this.humanLoopConfig((HumanLoopConfig)((HumanLoopConfig.Builder)HumanLoopConfig.builder().applyMutation(humanLoopConfig)).build());
        }

        public Builder outputConfig(FlowDefinitionOutputConfig var1);

        default public Builder outputConfig(Consumer<FlowDefinitionOutputConfig.Builder> outputConfig) {
            return this.outputConfig((FlowDefinitionOutputConfig)((FlowDefinitionOutputConfig.Builder)FlowDefinitionOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder failureReason(String var1);
    }
}

