/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ActionSource;
import software.amazon.awssdk.services.sagemaker.model.ActionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionSummary> {
    private static final SdkField<String> ACTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionArn").getter(ActionSummary.getter(ActionSummary::actionArn)).setter(ActionSummary.setter(Builder::actionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionArn").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionName").getter(ActionSummary.getter(ActionSummary::actionName)).setter(ActionSummary.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()}).build();
    private static final SdkField<ActionSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(ActionSummary.getter(ActionSummary::source)).setter(ActionSummary.setter(Builder::source)).constructor(ActionSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(ActionSummary.getter(ActionSummary::actionType)).setter(ActionSummary.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ActionSummary.getter(ActionSummary::statusAsString)).setter(ActionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ActionSummary.getter(ActionSummary::creationTime)).setter(ActionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ActionSummary.getter(ActionSummary::lastModifiedTime)).setter(ActionSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ARN_FIELD, ACTION_NAME_FIELD, SOURCE_FIELD, ACTION_TYPE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionArn;
    private final String actionName;
    private final ActionSource source;
    private final String actionType;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private ActionSummary(BuilderImpl builder) {
        this.actionArn = builder.actionArn;
        this.actionName = builder.actionName;
        this.source = builder.source;
        this.actionType = builder.actionType;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String actionArn() {
        return this.actionArn;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final ActionSource source() {
        return this.source;
    }

    public final String actionType() {
        return this.actionType;
    }

    public final ActionStatus status() {
        return ActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionSummary)) {
            return false;
        }
        ActionSummary other = (ActionSummary)obj;
        return Objects.equals(this.actionArn(), other.actionArn()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.actionType(), other.actionType()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ActionSummary").add("ActionArn", (Object)this.actionArn()).add("ActionName", (Object)this.actionName()).add("Source", (Object)this.source()).add("ActionType", (Object)this.actionType()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionArn": {
                return Optional.ofNullable(clazz.cast(this.actionArn()));
            }
            case "ActionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionType()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionSummary, T> g) {
        return obj -> g.apply((ActionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionArn;
        private String actionName;
        private ActionSource source;
        private String actionType;
        private String status;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionSummary model) {
            this.actionArn(model.actionArn);
            this.actionName(model.actionName);
            this.source(model.source);
            this.actionType(model.actionType);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getActionArn() {
            return this.actionArn;
        }

        public final void setActionArn(String actionArn) {
            this.actionArn = actionArn;
        }

        @Override
        @Transient
        public final Builder actionArn(String actionArn) {
            this.actionArn = actionArn;
            return this;
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        @Transient
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final ActionSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ActionSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(ActionSource source) {
            this.source = source;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        @Transient
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public ActionSummary build() {
            return new ActionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionSummary> {
        public Builder actionArn(String var1);

        public Builder actionName(String var1);

        public Builder source(ActionSource var1);

        default public Builder source(Consumer<ActionSource.Builder> source) {
            return this.source((ActionSource)((ActionSource.Builder)ActionSource.builder().applyMutation(source)).build());
        }

        public Builder actionType(String var1);

        public Builder status(String var1);

        public Builder status(ActionStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

