/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSource;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrialComponentSimpleSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrialComponentSimpleSummary> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialComponentName").getter(TrialComponentSimpleSummary.getter(TrialComponentSimpleSummary::trialComponentName)).setter(TrialComponentSimpleSummary.setter(Builder::trialComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build()}).build();
    private static final SdkField<String> TRIAL_COMPONENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialComponentArn").getter(TrialComponentSimpleSummary.getter(TrialComponentSimpleSummary::trialComponentArn)).setter(TrialComponentSimpleSummary.setter(Builder::trialComponentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentArn").build()}).build();
    private static final SdkField<TrialComponentSource> TRIAL_COMPONENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrialComponentSource").getter(TrialComponentSimpleSummary.getter(TrialComponentSimpleSummary::trialComponentSource)).setter(TrialComponentSimpleSummary.setter(Builder::trialComponentSource)).constructor(TrialComponentSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentSource").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TrialComponentSimpleSummary.getter(TrialComponentSimpleSummary::creationTime)).setter(TrialComponentSimpleSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(TrialComponentSimpleSummary.getter(TrialComponentSimpleSummary::createdBy)).setter(TrialComponentSimpleSummary.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD, TRIAL_COMPONENT_ARN_FIELD, TRIAL_COMPONENT_SOURCE_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trialComponentName;
    private final String trialComponentArn;
    private final TrialComponentSource trialComponentSource;
    private final Instant creationTime;
    private final UserContext createdBy;

    private TrialComponentSimpleSummary(BuilderImpl builder) {
        this.trialComponentName = builder.trialComponentName;
        this.trialComponentArn = builder.trialComponentArn;
        this.trialComponentSource = builder.trialComponentSource;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
    }

    public final String trialComponentName() {
        return this.trialComponentName;
    }

    public final String trialComponentArn() {
        return this.trialComponentArn;
    }

    public final TrialComponentSource trialComponentSource() {
        return this.trialComponentSource;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentSimpleSummary)) {
            return false;
        }
        TrialComponentSimpleSummary other = (TrialComponentSimpleSummary)obj;
        return Objects.equals(this.trialComponentName(), other.trialComponentName()) && Objects.equals(this.trialComponentArn(), other.trialComponentArn()) && Objects.equals(this.trialComponentSource(), other.trialComponentSource()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public final String toString() {
        return ToString.builder((String)"TrialComponentSimpleSummary").add("TrialComponentName", (Object)this.trialComponentName()).add("TrialComponentArn", (Object)this.trialComponentArn()).add("TrialComponentSource", (Object)this.trialComponentSource()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialComponentName": {
                return Optional.ofNullable(clazz.cast(this.trialComponentName()));
            }
            case "TrialComponentArn": {
                return Optional.ofNullable(clazz.cast(this.trialComponentArn()));
            }
            case "TrialComponentSource": {
                return Optional.ofNullable(clazz.cast(this.trialComponentSource()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentSimpleSummary, T> g) {
        return obj -> g.apply((TrialComponentSimpleSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trialComponentName;
        private String trialComponentArn;
        private TrialComponentSource trialComponentSource;
        private Instant creationTime;
        private UserContext createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentSimpleSummary model) {
            this.trialComponentName(model.trialComponentName);
            this.trialComponentArn(model.trialComponentArn);
            this.trialComponentSource(model.trialComponentSource);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
        }

        public final String getTrialComponentName() {
            return this.trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final String getTrialComponentArn() {
            return this.trialComponentArn;
        }

        @Override
        public final Builder trialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
            return this;
        }

        public final void setTrialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
        }

        public final TrialComponentSource.Builder getTrialComponentSource() {
            return this.trialComponentSource != null ? this.trialComponentSource.toBuilder() : null;
        }

        @Override
        public final Builder trialComponentSource(TrialComponentSource trialComponentSource) {
            this.trialComponentSource = trialComponentSource;
            return this;
        }

        public final void setTrialComponentSource(TrialComponentSource.BuilderImpl trialComponentSource) {
            this.trialComponentSource = trialComponentSource != null ? trialComponentSource.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public TrialComponentSimpleSummary build() {
            return new TrialComponentSimpleSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrialComponentSimpleSummary> {
        public Builder trialComponentName(String var1);

        public Builder trialComponentArn(String var1);

        public Builder trialComponentSource(TrialComponentSource var1);

        default public Builder trialComponentSource(Consumer<TrialComponentSource.Builder> trialComponentSource) {
            return this.trialComponentSource((TrialComponentSource)((TrialComponentSource.Builder)TrialComponentSource.builder().applyMutation(trialComponentSource)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }
    }
}

