/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MonitoringType {
    DATA_QUALITY("DataQuality"),
    MODEL_QUALITY("ModelQuality"),
    MODEL_BIAS("ModelBias"),
    MODEL_EXPLAINABILITY("ModelExplainability"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MonitoringType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitoringType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MonitoringType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitoringType> knownValues() {
        return Stream.of(MonitoringType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

