/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLSortOrder;
import software.amazon.awssdk.services.sagemaker.model.CandidateSortBy;
import software.amazon.awssdk.services.sagemaker.model.CandidateStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCandidatesForAutoMlJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListCandidatesForAutoMlJobRequest> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobName").getter(ListCandidatesForAutoMlJobRequest.getter(ListCandidatesForAutoMlJobRequest::autoMLJobName)).setter(ListCandidatesForAutoMlJobRequest.setter(Builder::autoMLJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()}).build();
    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusEquals").getter(ListCandidatesForAutoMlJobRequest.getter(ListCandidatesForAutoMlJobRequest::statusEqualsAsString)).setter(ListCandidatesForAutoMlJobRequest.setter(Builder::statusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()}).build();
    private static final SdkField<String> CANDIDATE_NAME_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CandidateNameEquals").getter(ListCandidatesForAutoMlJobRequest.getter(ListCandidatesForAutoMlJobRequest::candidateNameEquals)).setter(ListCandidatesForAutoMlJobRequest.setter(Builder::candidateNameEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateNameEquals").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListCandidatesForAutoMlJobRequest.getter(ListCandidatesForAutoMlJobRequest::sortOrderAsString)).setter(ListCandidatesForAutoMlJobRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListCandidatesForAutoMlJobRequest.getter(ListCandidatesForAutoMlJobRequest::sortByAsString)).setter(ListCandidatesForAutoMlJobRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCandidatesForAutoMlJobRequest.getter(ListCandidatesForAutoMlJobRequest::maxResults)).setter(ListCandidatesForAutoMlJobRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCandidatesForAutoMlJobRequest.getter(ListCandidatesForAutoMlJobRequest::nextToken)).setter(ListCandidatesForAutoMlJobRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD, STATUS_EQUALS_FIELD, CANDIDATE_NAME_EQUALS_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String autoMLJobName;
    private final String statusEquals;
    private final String candidateNameEquals;
    private final String sortOrder;
    private final String sortBy;
    private final Integer maxResults;
    private final String nextToken;

    private ListCandidatesForAutoMlJobRequest(BuilderImpl builder) {
        super(builder);
        this.autoMLJobName = builder.autoMLJobName;
        this.statusEquals = builder.statusEquals;
        this.candidateNameEquals = builder.candidateNameEquals;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String autoMLJobName() {
        return this.autoMLJobName;
    }

    public final CandidateStatus statusEquals() {
        return CandidateStatus.fromValue(this.statusEquals);
    }

    public final String statusEqualsAsString() {
        return this.statusEquals;
    }

    public final String candidateNameEquals() {
        return this.candidateNameEquals;
    }

    public final AutoMLSortOrder sortOrder() {
        return AutoMLSortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final CandidateSortBy sortBy() {
        return CandidateSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.candidateNameEquals());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCandidatesForAutoMlJobRequest)) {
            return false;
        }
        ListCandidatesForAutoMlJobRequest other = (ListCandidatesForAutoMlJobRequest)((Object)obj);
        return Objects.equals(this.autoMLJobName(), other.autoMLJobName()) && Objects.equals(this.statusEqualsAsString(), other.statusEqualsAsString()) && Objects.equals(this.candidateNameEquals(), other.candidateNameEquals()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCandidatesForAutoMlJobRequest").add("AutoMLJobName", (Object)this.autoMLJobName()).add("StatusEquals", (Object)this.statusEqualsAsString()).add("CandidateNameEquals", (Object)this.candidateNameEquals()).add("SortOrder", (Object)this.sortOrderAsString()).add("SortBy", (Object)this.sortByAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMLJobName": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobName()));
            }
            case "StatusEquals": {
                return Optional.ofNullable(clazz.cast(this.statusEqualsAsString()));
            }
            case "CandidateNameEquals": {
                return Optional.ofNullable(clazz.cast(this.candidateNameEquals()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCandidatesForAutoMlJobRequest, T> g) {
        return obj -> g.apply((ListCandidatesForAutoMlJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String autoMLJobName;
        private String statusEquals;
        private String candidateNameEquals;
        private String sortOrder;
        private String sortBy;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCandidatesForAutoMlJobRequest model) {
            super(model);
            this.autoMLJobName(model.autoMLJobName);
            this.statusEquals(model.statusEquals);
            this.candidateNameEquals(model.candidateNameEquals);
            this.sortOrder(model.sortOrder);
            this.sortBy(model.sortBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAutoMLJobName() {
            return this.autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        public final String getStatusEquals() {
            return this.statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(CandidateStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        public final String getCandidateNameEquals() {
            return this.candidateNameEquals;
        }

        @Override
        public final Builder candidateNameEquals(String candidateNameEquals) {
            this.candidateNameEquals = candidateNameEquals;
            return this;
        }

        public final void setCandidateNameEquals(String candidateNameEquals) {
            this.candidateNameEquals = candidateNameEquals;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(AutoMLSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(CandidateSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCandidatesForAutoMlJobRequest build() {
            return new ListCandidatesForAutoMlJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCandidatesForAutoMlJobRequest> {
        public Builder autoMLJobName(String var1);

        public Builder statusEquals(String var1);

        public Builder statusEquals(CandidateStatus var1);

        public Builder candidateNameEquals(String var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(AutoMLSortOrder var1);

        public Builder sortBy(String var1);

        public Builder sortBy(CandidateSortBy var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

