/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobStoppingConditions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobStoppingConditions> {
    private static final SdkField<Integer> MAX_HUMAN_LABELED_OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxHumanLabeledObjectCount").getter(LabelingJobStoppingConditions.getter(LabelingJobStoppingConditions::maxHumanLabeledObjectCount)).setter(LabelingJobStoppingConditions.setter(Builder::maxHumanLabeledObjectCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHumanLabeledObjectCount").build()}).build();
    private static final SdkField<Integer> MAX_PERCENTAGE_OF_INPUT_DATASET_LABELED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxPercentageOfInputDatasetLabeled").getter(LabelingJobStoppingConditions.getter(LabelingJobStoppingConditions::maxPercentageOfInputDatasetLabeled)).setter(LabelingJobStoppingConditions.setter(Builder::maxPercentageOfInputDatasetLabeled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPercentageOfInputDatasetLabeled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_HUMAN_LABELED_OBJECT_COUNT_FIELD, MAX_PERCENTAGE_OF_INPUT_DATASET_LABELED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxHumanLabeledObjectCount;
    private final Integer maxPercentageOfInputDatasetLabeled;

    private LabelingJobStoppingConditions(BuilderImpl builder) {
        this.maxHumanLabeledObjectCount = builder.maxHumanLabeledObjectCount;
        this.maxPercentageOfInputDatasetLabeled = builder.maxPercentageOfInputDatasetLabeled;
    }

    public final Integer maxHumanLabeledObjectCount() {
        return this.maxHumanLabeledObjectCount;
    }

    public final Integer maxPercentageOfInputDatasetLabeled() {
        return this.maxPercentageOfInputDatasetLabeled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxHumanLabeledObjectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPercentageOfInputDatasetLabeled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobStoppingConditions)) {
            return false;
        }
        LabelingJobStoppingConditions other = (LabelingJobStoppingConditions)obj;
        return Objects.equals(this.maxHumanLabeledObjectCount(), other.maxHumanLabeledObjectCount()) && Objects.equals(this.maxPercentageOfInputDatasetLabeled(), other.maxPercentageOfInputDatasetLabeled());
    }

    public final String toString() {
        return ToString.builder((String)"LabelingJobStoppingConditions").add("MaxHumanLabeledObjectCount", (Object)this.maxHumanLabeledObjectCount()).add("MaxPercentageOfInputDatasetLabeled", (Object)this.maxPercentageOfInputDatasetLabeled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxHumanLabeledObjectCount": {
                return Optional.ofNullable(clazz.cast(this.maxHumanLabeledObjectCount()));
            }
            case "MaxPercentageOfInputDatasetLabeled": {
                return Optional.ofNullable(clazz.cast(this.maxPercentageOfInputDatasetLabeled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobStoppingConditions, T> g) {
        return obj -> g.apply((LabelingJobStoppingConditions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxHumanLabeledObjectCount;
        private Integer maxPercentageOfInputDatasetLabeled;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobStoppingConditions model) {
            this.maxHumanLabeledObjectCount(model.maxHumanLabeledObjectCount);
            this.maxPercentageOfInputDatasetLabeled(model.maxPercentageOfInputDatasetLabeled);
        }

        public final Integer getMaxHumanLabeledObjectCount() {
            return this.maxHumanLabeledObjectCount;
        }

        @Override
        public final Builder maxHumanLabeledObjectCount(Integer maxHumanLabeledObjectCount) {
            this.maxHumanLabeledObjectCount = maxHumanLabeledObjectCount;
            return this;
        }

        public final void setMaxHumanLabeledObjectCount(Integer maxHumanLabeledObjectCount) {
            this.maxHumanLabeledObjectCount = maxHumanLabeledObjectCount;
        }

        public final Integer getMaxPercentageOfInputDatasetLabeled() {
            return this.maxPercentageOfInputDatasetLabeled;
        }

        @Override
        public final Builder maxPercentageOfInputDatasetLabeled(Integer maxPercentageOfInputDatasetLabeled) {
            this.maxPercentageOfInputDatasetLabeled = maxPercentageOfInputDatasetLabeled;
            return this;
        }

        public final void setMaxPercentageOfInputDatasetLabeled(Integer maxPercentageOfInputDatasetLabeled) {
            this.maxPercentageOfInputDatasetLabeled = maxPercentageOfInputDatasetLabeled;
        }

        public LabelingJobStoppingConditions build() {
            return new LabelingJobStoppingConditions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobStoppingConditions> {
        public Builder maxHumanLabeledObjectCount(Integer var1);

        public Builder maxPercentageOfInputDatasetLabeled(Integer var1);
    }
}

