/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AnnotationConsolidationConfig;
import software.amazon.awssdk.services.sagemaker.model.PublicWorkforceTaskPrice;
import software.amazon.awssdk.services.sagemaker.model.TaskKeywordsCopier;
import software.amazon.awssdk.services.sagemaker.model.UiConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HumanTaskConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HumanTaskConfig> {
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkteamArn").getter(HumanTaskConfig.getter(HumanTaskConfig::workteamArn)).setter(HumanTaskConfig.setter(Builder::workteamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()}).build();
    private static final SdkField<UiConfig> UI_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UiConfig").getter(HumanTaskConfig.getter(HumanTaskConfig::uiConfig)).setter(HumanTaskConfig.setter(Builder::uiConfig)).constructor(UiConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiConfig").build()}).build();
    private static final SdkField<String> PRE_HUMAN_TASK_LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreHumanTaskLambdaArn").getter(HumanTaskConfig.getter(HumanTaskConfig::preHumanTaskLambdaArn)).setter(HumanTaskConfig.setter(Builder::preHumanTaskLambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreHumanTaskLambdaArn").build()}).build();
    private static final SdkField<List<String>> TASK_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskKeywords").getter(HumanTaskConfig.getter(HumanTaskConfig::taskKeywords)).setter(HumanTaskConfig.setter(Builder::taskKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskTitle").getter(HumanTaskConfig.getter(HumanTaskConfig::taskTitle)).setter(HumanTaskConfig.setter(Builder::taskTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTitle").build()}).build();
    private static final SdkField<String> TASK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskDescription").getter(HumanTaskConfig.getter(HumanTaskConfig::taskDescription)).setter(HumanTaskConfig.setter(Builder::taskDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDescription").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfHumanWorkersPerDataObject").getter(HumanTaskConfig.getter(HumanTaskConfig::numberOfHumanWorkersPerDataObject)).setter(HumanTaskConfig.setter(Builder::numberOfHumanWorkersPerDataObject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfHumanWorkersPerDataObject").build()}).build();
    private static final SdkField<Integer> TASK_TIME_LIMIT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TaskTimeLimitInSeconds").getter(HumanTaskConfig.getter(HumanTaskConfig::taskTimeLimitInSeconds)).setter(HumanTaskConfig.setter(Builder::taskTimeLimitInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTimeLimitInSeconds").build()}).build();
    private static final SdkField<Integer> TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TaskAvailabilityLifetimeInSeconds").getter(HumanTaskConfig.getter(HumanTaskConfig::taskAvailabilityLifetimeInSeconds)).setter(HumanTaskConfig.setter(Builder::taskAvailabilityLifetimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskAvailabilityLifetimeInSeconds").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_TASK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentTaskCount").getter(HumanTaskConfig.getter(HumanTaskConfig::maxConcurrentTaskCount)).setter(HumanTaskConfig.setter(Builder::maxConcurrentTaskCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentTaskCount").build()}).build();
    private static final SdkField<AnnotationConsolidationConfig> ANNOTATION_CONSOLIDATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnnotationConsolidationConfig").getter(HumanTaskConfig.getter(HumanTaskConfig::annotationConsolidationConfig)).setter(HumanTaskConfig.setter(Builder::annotationConsolidationConfig)).constructor(AnnotationConsolidationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationConsolidationConfig").build()}).build();
    private static final SdkField<PublicWorkforceTaskPrice> PUBLIC_WORKFORCE_TASK_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicWorkforceTaskPrice").getter(HumanTaskConfig.getter(HumanTaskConfig::publicWorkforceTaskPrice)).setter(HumanTaskConfig.setter(Builder::publicWorkforceTaskPrice)).constructor(PublicWorkforceTaskPrice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicWorkforceTaskPrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_ARN_FIELD, UI_CONFIG_FIELD, PRE_HUMAN_TASK_LAMBDA_ARN_FIELD, TASK_KEYWORDS_FIELD, TASK_TITLE_FIELD, TASK_DESCRIPTION_FIELD, NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD, TASK_TIME_LIMIT_IN_SECONDS_FIELD, TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD, MAX_CONCURRENT_TASK_COUNT_FIELD, ANNOTATION_CONSOLIDATION_CONFIG_FIELD, PUBLIC_WORKFORCE_TASK_PRICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workteamArn;
    private final UiConfig uiConfig;
    private final String preHumanTaskLambdaArn;
    private final List<String> taskKeywords;
    private final String taskTitle;
    private final String taskDescription;
    private final Integer numberOfHumanWorkersPerDataObject;
    private final Integer taskTimeLimitInSeconds;
    private final Integer taskAvailabilityLifetimeInSeconds;
    private final Integer maxConcurrentTaskCount;
    private final AnnotationConsolidationConfig annotationConsolidationConfig;
    private final PublicWorkforceTaskPrice publicWorkforceTaskPrice;

    private HumanTaskConfig(BuilderImpl builder) {
        this.workteamArn = builder.workteamArn;
        this.uiConfig = builder.uiConfig;
        this.preHumanTaskLambdaArn = builder.preHumanTaskLambdaArn;
        this.taskKeywords = builder.taskKeywords;
        this.taskTitle = builder.taskTitle;
        this.taskDescription = builder.taskDescription;
        this.numberOfHumanWorkersPerDataObject = builder.numberOfHumanWorkersPerDataObject;
        this.taskTimeLimitInSeconds = builder.taskTimeLimitInSeconds;
        this.taskAvailabilityLifetimeInSeconds = builder.taskAvailabilityLifetimeInSeconds;
        this.maxConcurrentTaskCount = builder.maxConcurrentTaskCount;
        this.annotationConsolidationConfig = builder.annotationConsolidationConfig;
        this.publicWorkforceTaskPrice = builder.publicWorkforceTaskPrice;
    }

    public final String workteamArn() {
        return this.workteamArn;
    }

    public final UiConfig uiConfig() {
        return this.uiConfig;
    }

    public final String preHumanTaskLambdaArn() {
        return this.preHumanTaskLambdaArn;
    }

    public final boolean hasTaskKeywords() {
        return this.taskKeywords != null && !(this.taskKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> taskKeywords() {
        return this.taskKeywords;
    }

    public final String taskTitle() {
        return this.taskTitle;
    }

    public final String taskDescription() {
        return this.taskDescription;
    }

    public final Integer numberOfHumanWorkersPerDataObject() {
        return this.numberOfHumanWorkersPerDataObject;
    }

    public final Integer taskTimeLimitInSeconds() {
        return this.taskTimeLimitInSeconds;
    }

    public final Integer taskAvailabilityLifetimeInSeconds() {
        return this.taskAvailabilityLifetimeInSeconds;
    }

    public final Integer maxConcurrentTaskCount() {
        return this.maxConcurrentTaskCount;
    }

    public final AnnotationConsolidationConfig annotationConsolidationConfig() {
        return this.annotationConsolidationConfig;
    }

    public final PublicWorkforceTaskPrice publicWorkforceTaskPrice() {
        return this.publicWorkforceTaskPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.uiConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.preHumanTaskLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskKeywords() ? this.taskKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfHumanWorkersPerDataObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTimeLimitInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskAvailabilityLifetimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotationConsolidationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicWorkforceTaskPrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanTaskConfig)) {
            return false;
        }
        HumanTaskConfig other = (HumanTaskConfig)obj;
        return Objects.equals(this.workteamArn(), other.workteamArn()) && Objects.equals(this.uiConfig(), other.uiConfig()) && Objects.equals(this.preHumanTaskLambdaArn(), other.preHumanTaskLambdaArn()) && this.hasTaskKeywords() == other.hasTaskKeywords() && Objects.equals(this.taskKeywords(), other.taskKeywords()) && Objects.equals(this.taskTitle(), other.taskTitle()) && Objects.equals(this.taskDescription(), other.taskDescription()) && Objects.equals(this.numberOfHumanWorkersPerDataObject(), other.numberOfHumanWorkersPerDataObject()) && Objects.equals(this.taskTimeLimitInSeconds(), other.taskTimeLimitInSeconds()) && Objects.equals(this.taskAvailabilityLifetimeInSeconds(), other.taskAvailabilityLifetimeInSeconds()) && Objects.equals(this.maxConcurrentTaskCount(), other.maxConcurrentTaskCount()) && Objects.equals(this.annotationConsolidationConfig(), other.annotationConsolidationConfig()) && Objects.equals(this.publicWorkforceTaskPrice(), other.publicWorkforceTaskPrice());
    }

    public final String toString() {
        return ToString.builder((String)"HumanTaskConfig").add("WorkteamArn", (Object)this.workteamArn()).add("UiConfig", (Object)this.uiConfig()).add("PreHumanTaskLambdaArn", (Object)this.preHumanTaskLambdaArn()).add("TaskKeywords", this.hasTaskKeywords() ? this.taskKeywords() : null).add("TaskTitle", (Object)this.taskTitle()).add("TaskDescription", (Object)this.taskDescription()).add("NumberOfHumanWorkersPerDataObject", (Object)this.numberOfHumanWorkersPerDataObject()).add("TaskTimeLimitInSeconds", (Object)this.taskTimeLimitInSeconds()).add("TaskAvailabilityLifetimeInSeconds", (Object)this.taskAvailabilityLifetimeInSeconds()).add("MaxConcurrentTaskCount", (Object)this.maxConcurrentTaskCount()).add("AnnotationConsolidationConfig", (Object)this.annotationConsolidationConfig()).add("PublicWorkforceTaskPrice", (Object)this.publicWorkforceTaskPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkteamArn": {
                return Optional.ofNullable(clazz.cast(this.workteamArn()));
            }
            case "UiConfig": {
                return Optional.ofNullable(clazz.cast(this.uiConfig()));
            }
            case "PreHumanTaskLambdaArn": {
                return Optional.ofNullable(clazz.cast(this.preHumanTaskLambdaArn()));
            }
            case "TaskKeywords": {
                return Optional.ofNullable(clazz.cast(this.taskKeywords()));
            }
            case "TaskTitle": {
                return Optional.ofNullable(clazz.cast(this.taskTitle()));
            }
            case "TaskDescription": {
                return Optional.ofNullable(clazz.cast(this.taskDescription()));
            }
            case "NumberOfHumanWorkersPerDataObject": {
                return Optional.ofNullable(clazz.cast(this.numberOfHumanWorkersPerDataObject()));
            }
            case "TaskTimeLimitInSeconds": {
                return Optional.ofNullable(clazz.cast(this.taskTimeLimitInSeconds()));
            }
            case "TaskAvailabilityLifetimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.taskAvailabilityLifetimeInSeconds()));
            }
            case "MaxConcurrentTaskCount": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentTaskCount()));
            }
            case "AnnotationConsolidationConfig": {
                return Optional.ofNullable(clazz.cast(this.annotationConsolidationConfig()));
            }
            case "PublicWorkforceTaskPrice": {
                return Optional.ofNullable(clazz.cast(this.publicWorkforceTaskPrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanTaskConfig, T> g) {
        return obj -> g.apply((HumanTaskConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workteamArn;
        private UiConfig uiConfig;
        private String preHumanTaskLambdaArn;
        private List<String> taskKeywords = DefaultSdkAutoConstructList.getInstance();
        private String taskTitle;
        private String taskDescription;
        private Integer numberOfHumanWorkersPerDataObject;
        private Integer taskTimeLimitInSeconds;
        private Integer taskAvailabilityLifetimeInSeconds;
        private Integer maxConcurrentTaskCount;
        private AnnotationConsolidationConfig annotationConsolidationConfig;
        private PublicWorkforceTaskPrice publicWorkforceTaskPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanTaskConfig model) {
            this.workteamArn(model.workteamArn);
            this.uiConfig(model.uiConfig);
            this.preHumanTaskLambdaArn(model.preHumanTaskLambdaArn);
            this.taskKeywords(model.taskKeywords);
            this.taskTitle(model.taskTitle);
            this.taskDescription(model.taskDescription);
            this.numberOfHumanWorkersPerDataObject(model.numberOfHumanWorkersPerDataObject);
            this.taskTimeLimitInSeconds(model.taskTimeLimitInSeconds);
            this.taskAvailabilityLifetimeInSeconds(model.taskAvailabilityLifetimeInSeconds);
            this.maxConcurrentTaskCount(model.maxConcurrentTaskCount);
            this.annotationConsolidationConfig(model.annotationConsolidationConfig);
            this.publicWorkforceTaskPrice(model.publicWorkforceTaskPrice);
        }

        public final String getWorkteamArn() {
            return this.workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        public final UiConfig.Builder getUiConfig() {
            return this.uiConfig != null ? this.uiConfig.toBuilder() : null;
        }

        @Override
        public final Builder uiConfig(UiConfig uiConfig) {
            this.uiConfig = uiConfig;
            return this;
        }

        public final void setUiConfig(UiConfig.BuilderImpl uiConfig) {
            this.uiConfig = uiConfig != null ? uiConfig.build() : null;
        }

        public final String getPreHumanTaskLambdaArn() {
            return this.preHumanTaskLambdaArn;
        }

        @Override
        public final Builder preHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
            return this;
        }

        public final void setPreHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
        }

        public final Collection<String> getTaskKeywords() {
            if (this.taskKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskKeywords;
        }

        @Override
        public final Builder taskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = TaskKeywordsCopier.copy(taskKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskKeywords(String ... taskKeywords) {
            this.taskKeywords(Arrays.asList(taskKeywords));
            return this;
        }

        public final void setTaskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = TaskKeywordsCopier.copy(taskKeywords);
        }

        public final String getTaskTitle() {
            return this.taskTitle;
        }

        @Override
        public final Builder taskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
            return this;
        }

        public final void setTaskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
        }

        public final String getTaskDescription() {
            return this.taskDescription;
        }

        @Override
        public final Builder taskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
            return this;
        }

        public final void setTaskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
        }

        public final Integer getNumberOfHumanWorkersPerDataObject() {
            return this.numberOfHumanWorkersPerDataObject;
        }

        @Override
        public final Builder numberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
            return this;
        }

        public final void setNumberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
        }

        public final Integer getTaskTimeLimitInSeconds() {
            return this.taskTimeLimitInSeconds;
        }

        @Override
        public final Builder taskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
            return this;
        }

        public final void setTaskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
        }

        public final Integer getTaskAvailabilityLifetimeInSeconds() {
            return this.taskAvailabilityLifetimeInSeconds;
        }

        @Override
        public final Builder taskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
            return this;
        }

        public final void setTaskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
        }

        public final Integer getMaxConcurrentTaskCount() {
            return this.maxConcurrentTaskCount;
        }

        @Override
        public final Builder maxConcurrentTaskCount(Integer maxConcurrentTaskCount) {
            this.maxConcurrentTaskCount = maxConcurrentTaskCount;
            return this;
        }

        public final void setMaxConcurrentTaskCount(Integer maxConcurrentTaskCount) {
            this.maxConcurrentTaskCount = maxConcurrentTaskCount;
        }

        public final AnnotationConsolidationConfig.Builder getAnnotationConsolidationConfig() {
            return this.annotationConsolidationConfig != null ? this.annotationConsolidationConfig.toBuilder() : null;
        }

        @Override
        public final Builder annotationConsolidationConfig(AnnotationConsolidationConfig annotationConsolidationConfig) {
            this.annotationConsolidationConfig = annotationConsolidationConfig;
            return this;
        }

        public final void setAnnotationConsolidationConfig(AnnotationConsolidationConfig.BuilderImpl annotationConsolidationConfig) {
            this.annotationConsolidationConfig = annotationConsolidationConfig != null ? annotationConsolidationConfig.build() : null;
        }

        public final PublicWorkforceTaskPrice.Builder getPublicWorkforceTaskPrice() {
            return this.publicWorkforceTaskPrice != null ? this.publicWorkforceTaskPrice.toBuilder() : null;
        }

        @Override
        public final Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice;
            return this;
        }

        public final void setPublicWorkforceTaskPrice(PublicWorkforceTaskPrice.BuilderImpl publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice != null ? publicWorkforceTaskPrice.build() : null;
        }

        public HumanTaskConfig build() {
            return new HumanTaskConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HumanTaskConfig> {
        public Builder workteamArn(String var1);

        public Builder uiConfig(UiConfig var1);

        default public Builder uiConfig(Consumer<UiConfig.Builder> uiConfig) {
            return this.uiConfig((UiConfig)((UiConfig.Builder)UiConfig.builder().applyMutation(uiConfig)).build());
        }

        public Builder preHumanTaskLambdaArn(String var1);

        public Builder taskKeywords(Collection<String> var1);

        public Builder taskKeywords(String ... var1);

        public Builder taskTitle(String var1);

        public Builder taskDescription(String var1);

        public Builder numberOfHumanWorkersPerDataObject(Integer var1);

        public Builder taskTimeLimitInSeconds(Integer var1);

        public Builder taskAvailabilityLifetimeInSeconds(Integer var1);

        public Builder maxConcurrentTaskCount(Integer var1);

        public Builder annotationConsolidationConfig(AnnotationConsolidationConfig var1);

        default public Builder annotationConsolidationConfig(Consumer<AnnotationConsolidationConfig.Builder> annotationConsolidationConfig) {
            return this.annotationConsolidationConfig((AnnotationConsolidationConfig)((AnnotationConsolidationConfig.Builder)AnnotationConsolidationConfig.builder().applyMutation(annotationConsolidationConfig)).build());
        }

        public Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice var1);

        default public Builder publicWorkforceTaskPrice(Consumer<PublicWorkforceTaskPrice.Builder> publicWorkforceTaskPrice) {
            return this.publicWorkforceTaskPrice((PublicWorkforceTaskPrice)((PublicWorkforceTaskPrice.Builder)PublicWorkforceTaskPrice.builder().applyMutation(publicWorkforceTaskPrice)).build());
        }
    }
}

