/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EndpointStatus {
    OUT_OF_SERVICE("OutOfService"),
    CREATING("Creating"),
    UPDATING("Updating"),
    SYSTEM_UPDATING("SystemUpdating"),
    ROLLING_BACK("RollingBack"),
    IN_SERVICE("InService"),
    DELETING("Deleting"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EndpointStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EndpointStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointStatus> knownValues() {
        return Stream.of(EndpointStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

