/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelPackageGroupResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeModelPackageGroupResponse> {
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupName").getter(DescribeModelPackageGroupResponse.getter(DescribeModelPackageGroupResponse::modelPackageGroupName)).setter(DescribeModelPackageGroupResponse.setter(Builder::modelPackageGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupArn").getter(DescribeModelPackageGroupResponse.getter(DescribeModelPackageGroupResponse::modelPackageGroupArn)).setter(DescribeModelPackageGroupResponse.setter(Builder::modelPackageGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupArn").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupDescription").getter(DescribeModelPackageGroupResponse.getter(DescribeModelPackageGroupResponse::modelPackageGroupDescription)).setter(DescribeModelPackageGroupResponse.setter(Builder::modelPackageGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeModelPackageGroupResponse.getter(DescribeModelPackageGroupResponse::creationTime)).setter(DescribeModelPackageGroupResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribeModelPackageGroupResponse.getter(DescribeModelPackageGroupResponse::createdBy)).setter(DescribeModelPackageGroupResponse.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageGroupStatus").getter(DescribeModelPackageGroupResponse.getter(DescribeModelPackageGroupResponse::modelPackageGroupStatusAsString)).setter(DescribeModelPackageGroupResponse.setter(Builder::modelPackageGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_GROUP_ARN_FIELD, MODEL_PACKAGE_GROUP_DESCRIPTION_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, MODEL_PACKAGE_GROUP_STATUS_FIELD));
    private final String modelPackageGroupName;
    private final String modelPackageGroupArn;
    private final String modelPackageGroupDescription;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final String modelPackageGroupStatus;

    private DescribeModelPackageGroupResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageGroupArn = builder.modelPackageGroupArn;
        this.modelPackageGroupDescription = builder.modelPackageGroupDescription;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.modelPackageGroupStatus = builder.modelPackageGroupStatus;
    }

    public final String modelPackageGroupName() {
        return this.modelPackageGroupName;
    }

    public final String modelPackageGroupArn() {
        return this.modelPackageGroupArn;
    }

    public final String modelPackageGroupDescription() {
        return this.modelPackageGroupDescription;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final ModelPackageGroupStatus modelPackageGroupStatus() {
        return ModelPackageGroupStatus.fromValue(this.modelPackageGroupStatus);
    }

    public final String modelPackageGroupStatusAsString() {
        return this.modelPackageGroupStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageGroupStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelPackageGroupResponse)) {
            return false;
        }
        DescribeModelPackageGroupResponse other = (DescribeModelPackageGroupResponse)((Object)obj);
        return Objects.equals(this.modelPackageGroupName(), other.modelPackageGroupName()) && Objects.equals(this.modelPackageGroupArn(), other.modelPackageGroupArn()) && Objects.equals(this.modelPackageGroupDescription(), other.modelPackageGroupDescription()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.modelPackageGroupStatusAsString(), other.modelPackageGroupStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeModelPackageGroupResponse").add("ModelPackageGroupName", (Object)this.modelPackageGroupName()).add("ModelPackageGroupArn", (Object)this.modelPackageGroupArn()).add("ModelPackageGroupDescription", (Object)this.modelPackageGroupDescription()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("ModelPackageGroupStatus", (Object)this.modelPackageGroupStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageGroupName": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupName()));
            }
            case "ModelPackageGroupArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupArn()));
            }
            case "ModelPackageGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupDescription()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "ModelPackageGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.modelPackageGroupStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelPackageGroupResponse, T> g) {
        return obj -> g.apply((DescribeModelPackageGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String modelPackageGroupName;
        private String modelPackageGroupArn;
        private String modelPackageGroupDescription;
        private Instant creationTime;
        private UserContext createdBy;
        private String modelPackageGroupStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelPackageGroupResponse model) {
            super(model);
            this.modelPackageGroupName(model.modelPackageGroupName);
            this.modelPackageGroupArn(model.modelPackageGroupArn);
            this.modelPackageGroupDescription(model.modelPackageGroupDescription);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.modelPackageGroupStatus(model.modelPackageGroupStatus);
        }

        public final String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        public final String getModelPackageGroupArn() {
            return this.modelPackageGroupArn;
        }

        @Override
        public final Builder modelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
            return this;
        }

        public final void setModelPackageGroupArn(String modelPackageGroupArn) {
            this.modelPackageGroupArn = modelPackageGroupArn;
        }

        public final String getModelPackageGroupDescription() {
            return this.modelPackageGroupDescription;
        }

        @Override
        public final Builder modelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
            return this;
        }

        public final void setModelPackageGroupDescription(String modelPackageGroupDescription) {
            this.modelPackageGroupDescription = modelPackageGroupDescription;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final String getModelPackageGroupStatus() {
            return this.modelPackageGroupStatus;
        }

        @Override
        public final Builder modelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
            return this;
        }

        @Override
        public final Builder modelPackageGroupStatus(ModelPackageGroupStatus modelPackageGroupStatus) {
            this.modelPackageGroupStatus(modelPackageGroupStatus == null ? null : modelPackageGroupStatus.toString());
            return this;
        }

        public final void setModelPackageGroupStatus(String modelPackageGroupStatus) {
            this.modelPackageGroupStatus = modelPackageGroupStatus;
        }

        @Override
        public DescribeModelPackageGroupResponse build() {
            return new DescribeModelPackageGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelPackageGroupResponse> {
        public Builder modelPackageGroupName(String var1);

        public Builder modelPackageGroupArn(String var1);

        public Builder modelPackageGroupDescription(String var1);

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder modelPackageGroupStatus(String var1);

        public Builder modelPackageGroupStatus(ModelPackageGroupStatus var1);
    }
}

