/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details for the Outpost object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Outpost implements SdkPojo, Serializable, ToCopyableBuilder<Outpost.Builder, Outpost> {
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn").getter(getter(Outpost::outpostArn)).setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()).build();

    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostId").getter(getter(Outpost::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(Outpost::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<Long> CAPACITY_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CapacityInBytes").getter(getter(Outpost::capacityInBytes)).setter(setter(Builder::capacityInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityInBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ARN_FIELD,
            OUTPOST_ID_FIELD, OWNER_ID_FIELD, CAPACITY_IN_BYTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outpostArn;

    private final String outpostId;

    private final String ownerId;

    private final Long capacityInBytes;

    private Outpost(BuilderImpl builder) {
        this.outpostArn = builder.outpostArn;
        this.outpostId = builder.outpostId;
        this.ownerId = builder.ownerId;
        this.capacityInBytes = builder.capacityInBytes;
    }

    /**
     * <p>
     * Specifies the unique Amazon Resource Name (ARN) for the outpost.
     * </p>
     * 
     * @return Specifies the unique Amazon Resource Name (ARN) for the outpost.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * Specifies the unique identifier for the outpost.
     * </p>
     * 
     * @return Specifies the unique identifier for the outpost.
     */
    public final String outpostId() {
        return outpostId;
    }

    /**
     * <p>
     * Returns the Amazon Web Services account ID of the outpost owner. Useful for comparing owned versus shared
     * outposts.
     * </p>
     * 
     * @return Returns the Amazon Web Services account ID of the outpost owner. Useful for comparing owned versus shared
     *         outposts.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The Amazon S3 capacity of the outpost in bytes.
     * </p>
     * 
     * @return The Amazon S3 capacity of the outpost in bytes.
     */
    public final Long capacityInBytes() {
        return capacityInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Outpost)) {
            return false;
        }
        Outpost other = (Outpost) obj;
        return Objects.equals(outpostArn(), other.outpostArn()) && Objects.equals(outpostId(), other.outpostId())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(capacityInBytes(), other.capacityInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Outpost").add("OutpostArn", outpostArn()).add("OutpostId", outpostId())
                .add("OwnerId", ownerId()).add("CapacityInBytes", capacityInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "CapacityInBytes":
            return Optional.ofNullable(clazz.cast(capacityInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Outpost, T> g) {
        return obj -> g.apply((Outpost) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Outpost> {
        /**
         * <p>
         * Specifies the unique Amazon Resource Name (ARN) for the outpost.
         * </p>
         * 
         * @param outpostArn
         *        Specifies the unique Amazon Resource Name (ARN) for the outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * Specifies the unique identifier for the outpost.
         * </p>
         * 
         * @param outpostId
         *        Specifies the unique identifier for the outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * <p>
         * Returns the Amazon Web Services account ID of the outpost owner. Useful for comparing owned versus shared
         * outposts.
         * </p>
         * 
         * @param ownerId
         *        Returns the Amazon Web Services account ID of the outpost owner. Useful for comparing owned versus
         *        shared outposts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The Amazon S3 capacity of the outpost in bytes.
         * </p>
         * 
         * @param capacityInBytes
         *        The Amazon S3 capacity of the outpost in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityInBytes(Long capacityInBytes);
    }

    static final class BuilderImpl implements Builder {
        private String outpostArn;

        private String outpostId;

        private String ownerId;

        private Long capacityInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(Outpost model) {
            outpostArn(model.outpostArn);
            outpostId(model.outpostId);
            ownerId(model.ownerId);
            capacityInBytes(model.capacityInBytes);
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final Long getCapacityInBytes() {
            return capacityInBytes;
        }

        public final void setCapacityInBytes(Long capacityInBytes) {
            this.capacityInBytes = capacityInBytes;
        }

        @Override
        public final Builder capacityInBytes(Long capacityInBytes) {
            this.capacityInBytes = capacityInBytes;
            return this;
        }

        @Override
        public Outpost build() {
            return new Outpost(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
