/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3outposts.S3OutpostsClient;
import software.amazon.awssdk.services.s3outposts.model.Endpoint;
import software.amazon.awssdk.services.s3outposts.model.ListSharedEndpointsRequest;
import software.amazon.awssdk.services.s3outposts.model.ListSharedEndpointsResponse;

public class ListSharedEndpointsIterable
implements SdkIterable<ListSharedEndpointsResponse> {
    private final S3OutpostsClient client;
    private final ListSharedEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSharedEndpointsIterable(S3OutpostsClient client, ListSharedEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSharedEndpointsResponseFetcher();
    }

    public Iterator<ListSharedEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Endpoint> endpoints() {
        Function<ListSharedEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSharedEndpointsResponseFetcher
    implements SyncPageFetcher<ListSharedEndpointsResponse> {
        private ListSharedEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListSharedEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSharedEndpointsResponse nextPage(ListSharedEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListSharedEndpointsIterable.this.client.listSharedEndpoints(ListSharedEndpointsIterable.this.firstRequest);
            }
            return ListSharedEndpointsIterable.this.client.listSharedEndpoints((ListSharedEndpointsRequest)((Object)ListSharedEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

