/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3outposts;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3outposts.DefaultS3OutpostsAsyncClient;
import software.amazon.awssdk.services.s3outposts.DefaultS3OutpostsBaseClientBuilder;
import software.amazon.awssdk.services.s3outposts.S3OutpostsAsyncClient;
import software.amazon.awssdk.services.s3outposts.S3OutpostsAsyncClientBuilder;
import software.amazon.awssdk.services.s3outposts.S3OutpostsServiceClientConfiguration;
import software.amazon.awssdk.services.s3outposts.endpoints.S3OutpostsEndpointProvider;

@SdkInternalApi
final class DefaultS3OutpostsAsyncClientBuilder
extends DefaultS3OutpostsBaseClientBuilder<S3OutpostsAsyncClientBuilder, S3OutpostsAsyncClient>
implements S3OutpostsAsyncClientBuilder {
    DefaultS3OutpostsAsyncClientBuilder() {
    }

    @Override
    public DefaultS3OutpostsAsyncClientBuilder endpointProvider(S3OutpostsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final S3OutpostsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultS3OutpostsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        S3OutpostsServiceClientConfiguration serviceClientConfiguration = S3OutpostsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultS3OutpostsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

