/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRumMetricDefinitionRequest extends RumRequest implements
        ToCopyableBuilder<UpdateRumMetricDefinitionRequest.Builder, UpdateRumMetricDefinitionRequest> {
    private static final SdkField<String> APP_MONITOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppMonitorName").getter(getter(UpdateRumMetricDefinitionRequest::appMonitorName))
            .setter(setter(Builder::appMonitorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AppMonitorName").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(UpdateRumMetricDefinitionRequest::destinationAsString))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(UpdateRumMetricDefinitionRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()).build();

    private static final SdkField<MetricDefinitionRequest> METRIC_DEFINITION_FIELD = SdkField
            .<MetricDefinitionRequest> builder(MarshallingType.SDK_POJO).memberName("MetricDefinition")
            .getter(getter(UpdateRumMetricDefinitionRequest::metricDefinition)).setter(setter(Builder::metricDefinition))
            .constructor(MetricDefinitionRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinition").build()).build();

    private static final SdkField<String> METRIC_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricDefinitionId").getter(getter(UpdateRumMetricDefinitionRequest::metricDefinitionId))
            .setter(setter(Builder::metricDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_NAME_FIELD,
            DESTINATION_FIELD, DESTINATION_ARN_FIELD, METRIC_DEFINITION_FIELD, METRIC_DEFINITION_ID_FIELD));

    private final String appMonitorName;

    private final String destination;

    private final String destinationArn;

    private final MetricDefinitionRequest metricDefinition;

    private final String metricDefinitionId;

    private UpdateRumMetricDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorName = builder.appMonitorName;
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.metricDefinition = builder.metricDefinition;
        this.metricDefinitionId = builder.metricDefinitionId;
    }

    /**
     * <p>
     * The name of the CloudWatch RUM app monitor that sends these metrics.
     * </p>
     * 
     * @return The name of the CloudWatch RUM app monitor that sends these metrics.
     */
    public final String appMonitorName() {
        return appMonitorName;
    }

    /**
     * <p>
     * The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>. If
     * you specify <code>Evidently</code>, you must also specify the ARN of the CloudWatchEvidently experiment that will
     * receive the metrics and an IAM role that has permission to write to the experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     *         <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     *         CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write
     *         to the experiment.
     * @see MetricDestination
     */
    public final MetricDestination destination() {
        return MetricDestination.fromValue(destination);
    }

    /**
     * <p>
     * The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>. If
     * you specify <code>Evidently</code>, you must also specify the ARN of the CloudWatchEvidently experiment that will
     * receive the metrics and an IAM role that has permission to write to the experiment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destination} will
     * return {@link MetricDestination#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #destinationAsString}.
     * </p>
     * 
     * @return The destination to send the metrics to. Valid values are <code>CloudWatch</code> and
     *         <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
     *         CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to write
     *         to the experiment.
     * @see MetricDestination
     */
    public final String destinationAsString() {
        return destination;
    }

    /**
     * <p>
     * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code> is
     * <code>CloudWatch</code>, do not use this parameter.
     * </p>
     * <p>
     * This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have
     * already defined this experiment as a valid destination. For more information, see <a
     * href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html"
     * >PutRumMetricsDestination</a>.
     * </p>
     * 
     * @return This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
     *         <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter.</p>
     *         <p>
     *         This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must
     *         have already defined this experiment as a valid destination. For more information, see <a
     *         href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html"
     *         >PutRumMetricsDestination</a>.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * A structure that contains the new definition that you want to use for this metric.
     * </p>
     * 
     * @return A structure that contains the new definition that you want to use for this metric.
     */
    public final MetricDefinitionRequest metricDefinition() {
        return metricDefinition;
    }

    /**
     * <p>
     * The ID of the metric definition to update.
     * </p>
     * 
     * @return The ID of the metric definition to update.
     */
    public final String metricDefinitionId() {
        return metricDefinitionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(metricDefinitionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRumMetricDefinitionRequest)) {
            return false;
        }
        UpdateRumMetricDefinitionRequest other = (UpdateRumMetricDefinitionRequest) obj;
        return Objects.equals(appMonitorName(), other.appMonitorName())
                && Objects.equals(destinationAsString(), other.destinationAsString())
                && Objects.equals(destinationArn(), other.destinationArn())
                && Objects.equals(metricDefinition(), other.metricDefinition())
                && Objects.equals(metricDefinitionId(), other.metricDefinitionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRumMetricDefinitionRequest").add("AppMonitorName", appMonitorName())
                .add("Destination", destinationAsString()).add("DestinationArn", destinationArn())
                .add("MetricDefinition", metricDefinition()).add("MetricDefinitionId", metricDefinitionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppMonitorName":
            return Optional.ofNullable(clazz.cast(appMonitorName()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destinationAsString()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "MetricDefinition":
            return Optional.ofNullable(clazz.cast(metricDefinition()));
        case "MetricDefinitionId":
            return Optional.ofNullable(clazz.cast(metricDefinitionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRumMetricDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateRumMetricDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RumRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRumMetricDefinitionRequest> {
        /**
         * <p>
         * The name of the CloudWatch RUM app monitor that sends these metrics.
         * </p>
         * 
         * @param appMonitorName
         *        The name of the CloudWatch RUM app monitor that sends these metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appMonitorName(String appMonitorName);

        /**
         * <p>
         * The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>.
         * If you specify <code>Evidently</code>, you must also specify the ARN of the CloudWatchEvidently experiment
         * that will receive the metrics and an IAM role that has permission to write to the experiment.
         * </p>
         * 
         * @param destination
         *        The destination to send the metrics to. Valid values are <code>CloudWatch</code> and
         *        <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
         *        CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to
         *        write to the experiment.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(String destination);

        /**
         * <p>
         * The destination to send the metrics to. Valid values are <code>CloudWatch</code> and <code>Evidently</code>.
         * If you specify <code>Evidently</code>, you must also specify the ARN of the CloudWatchEvidently experiment
         * that will receive the metrics and an IAM role that has permission to write to the experiment.
         * </p>
         * 
         * @param destination
         *        The destination to send the metrics to. Valid values are <code>CloudWatch</code> and
         *        <code>Evidently</code>. If you specify <code>Evidently</code>, you must also specify the ARN of the
         *        CloudWatchEvidently experiment that will receive the metrics and an IAM role that has permission to
         *        write to the experiment.
         * @see MetricDestination
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricDestination
         */
        Builder destination(MetricDestination destination);

        /**
         * <p>
         * This parameter is required if <code>Destination</code> is <code>Evidently</code>. If <code>Destination</code>
         * is <code>CloudWatch</code>, do not use this parameter.
         * </p>
         * <p>
         * This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must have
         * already defined this experiment as a valid destination. For more information, see <a
         * href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html"
         * >PutRumMetricsDestination</a>.
         * </p>
         * 
         * @param destinationArn
         *        This parameter is required if <code>Destination</code> is <code>Evidently</code>. If
         *        <code>Destination</code> is <code>CloudWatch</code>, do not use this parameter.</p>
         *        <p>
         *        This parameter specifies the ARN of the Evidently experiment that is to receive the metrics. You must
         *        have already defined this experiment as a valid destination. For more information, see <a href=
         *        "https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_PutRumMetricsDestination.html"
         *        >PutRumMetricsDestination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * A structure that contains the new definition that you want to use for this metric.
         * </p>
         * 
         * @param metricDefinition
         *        A structure that contains the new definition that you want to use for this metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinition(MetricDefinitionRequest metricDefinition);

        /**
         * <p>
         * A structure that contains the new definition that you want to use for this metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricDefinitionRequest.Builder} avoiding
         * the need to create one manually via {@link MetricDefinitionRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricDefinitionRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #metricDefinition(MetricDefinitionRequest)}.
         * 
         * @param metricDefinition
         *        a consumer that will call methods on {@link MetricDefinitionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDefinition(MetricDefinitionRequest)
         */
        default Builder metricDefinition(Consumer<MetricDefinitionRequest.Builder> metricDefinition) {
            return metricDefinition(MetricDefinitionRequest.builder().applyMutation(metricDefinition).build());
        }

        /**
         * <p>
         * The ID of the metric definition to update.
         * </p>
         * 
         * @param metricDefinitionId
         *        The ID of the metric definition to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinitionId(String metricDefinitionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RumRequest.BuilderImpl implements Builder {
        private String appMonitorName;

        private String destination;

        private String destinationArn;

        private MetricDefinitionRequest metricDefinition;

        private String metricDefinitionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRumMetricDefinitionRequest model) {
            super(model);
            appMonitorName(model.appMonitorName);
            destination(model.destination);
            destinationArn(model.destinationArn);
            metricDefinition(model.metricDefinition);
            metricDefinitionId(model.metricDefinitionId);
        }

        public final String getAppMonitorName() {
            return appMonitorName;
        }

        public final void setAppMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
        }

        @Override
        public final Builder appMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final MetricDefinitionRequest.Builder getMetricDefinition() {
            return metricDefinition != null ? metricDefinition.toBuilder() : null;
        }

        public final void setMetricDefinition(MetricDefinitionRequest.BuilderImpl metricDefinition) {
            this.metricDefinition = metricDefinition != null ? metricDefinition.build() : null;
        }

        @Override
        public final Builder metricDefinition(MetricDefinitionRequest metricDefinition) {
            this.metricDefinition = metricDefinition;
            return this;
        }

        public final String getMetricDefinitionId() {
            return metricDefinitionId;
        }

        public final void setMetricDefinitionId(String metricDefinitionId) {
            this.metricDefinitionId = metricDefinitionId;
        }

        @Override
        public final Builder metricDefinitionId(String metricDefinitionId) {
            this.metricDefinitionId = metricDefinitionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRumMetricDefinitionRequest build() {
            return new UpdateRumMetricDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
