/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallRulesRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<ListFirewallRulesRequest.Builder, ListFirewallRulesRequest> {
    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallRuleGroupId").getter(getter(ListFirewallRulesRequest::firewallRuleGroupId))
            .setter(setter(Builder::firewallRuleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build())
            .build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(ListFirewallRulesRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(ListFirewallRulesRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListFirewallRulesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFirewallRulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULE_GROUP_ID_FIELD,
            PRIORITY_FIELD, ACTION_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String firewallRuleGroupId;

    private final Integer priority;

    private final String action;

    private final Integer maxResults;

    private final String nextToken;

    private ListFirewallRulesRequest(BuilderImpl builder) {
        super(builder);
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.priority = builder.priority;
        this.action = builder.action;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the firewall rule group that you want to retrieve the rules for.
     * </p>
     * 
     * @return The unique identifier of the firewall rule group that you want to retrieve the rules for.
     */
    public final String firewallRuleGroupId() {
        return firewallRuleGroupId;
    }

    /**
     * <p>
     * Optional additional filter for the rules to retrieve.
     * </p>
     * <p>
     * The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the rules
     * in a rule group by order of priority, starting from the lowest setting.
     * </p>
     * 
     * @return Optional additional filter for the rules to retrieve.</p>
     *         <p>
     *         The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the
     *         rules in a rule group by order of priority, starting from the lowest setting.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * Optional additional filter for the rules to retrieve.
     * </p>
     * <p>
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain
     * list:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW</code> - Permit the request to go through.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the
     * rule's <code>BlockResponse</code> setting.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Optional additional filter for the rules to retrieve.</p>
     *         <p>
     *         The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's
     *         domain list:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW</code> - Permit the request to go through.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided
     *         in the rule's <code>BlockResponse</code> setting.
     *         </p>
     *         </li>
     * @see Action
     */
    public final Action action() {
        return Action.fromValue(action);
    }

    /**
     * <p>
     * Optional additional filter for the rules to retrieve.
     * </p>
     * <p>
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain
     * list:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALLOW</code> - Permit the request to go through.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the
     * rule's <code>BlockResponse</code> setting.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Optional additional filter for the rules to retrieve.</p>
     *         <p>
     *         The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's
     *         domain list:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALLOW</code> - Permit the request to go through.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided
     *         in the rule's <code>BlockResponse</code> setting.
     *         </p>
     *         </li>
     * @see Action
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The maximum number of objects that you want Resolver to return for this request. If more objects are available,
     * in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get
     * the next batch of objects.
     * </p>
     * <p>
     * If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects.
     * </p>
     * 
     * @return The maximum number of objects that you want Resolver to return for this request. If more objects are
     *         available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a
     *         subsequent call to get the next batch of objects.</p>
     *         <p>
     *         If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * For the first call to this list request, omit this value.
     * </p>
     * <p>
     * When you request a list of objects, Resolver returns at most the number of objects specified in
     * <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code>
     * value in the response. To retrieve the next batch of objects, use the token that was returned for the prior
     * request in your next request.
     * </p>
     * 
     * @return For the first call to this list request, omit this value.</p>
     *         <p>
     *         When you request a list of objects, Resolver returns at most the number of objects specified in
     *         <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that
     *         was returned for the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallRulesRequest)) {
            return false;
        }
        ListFirewallRulesRequest other = (ListFirewallRulesRequest) obj;
        return Objects.equals(firewallRuleGroupId(), other.firewallRuleGroupId()) && Objects.equals(priority(), other.priority())
                && Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFirewallRulesRequest").add("FirewallRuleGroupId", firewallRuleGroupId())
                .add("Priority", priority()).add("Action", actionAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallRuleGroupId":
            return Optional.ofNullable(clazz.cast(firewallRuleGroupId()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallRulesRequest, T> g) {
        return obj -> g.apply((ListFirewallRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFirewallRulesRequest> {
        /**
         * <p>
         * The unique identifier of the firewall rule group that you want to retrieve the rules for.
         * </p>
         * 
         * @param firewallRuleGroupId
         *        The unique identifier of the firewall rule group that you want to retrieve the rules for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupId(String firewallRuleGroupId);

        /**
         * <p>
         * Optional additional filter for the rules to retrieve.
         * </p>
         * <p>
         * The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the
         * rules in a rule group by order of priority, starting from the lowest setting.
         * </p>
         * 
         * @param priority
         *        Optional additional filter for the rules to retrieve.</p>
         *        <p>
         *        The setting that determines the processing order of the rules in a rule group. DNS Firewall processes
         *        the rules in a rule group by order of priority, starting from the lowest setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Optional additional filter for the rules to retrieve.
         * </p>
         * <p>
         * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's
         * domain list:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW</code> - Permit the request to go through.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in
         * the rule's <code>BlockResponse</code> setting.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        Optional additional filter for the rules to retrieve.</p>
         *        <p>
         *        The action that DNS Firewall should take on a DNS query when it matches one of the domains in the
         *        rule's domain list:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW</code> - Permit the request to go through.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are
         *        provided in the rule's <code>BlockResponse</code> setting.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * <p>
         * Optional additional filter for the rules to retrieve.
         * </p>
         * <p>
         * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's
         * domain list:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALLOW</code> - Permit the request to go through.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in
         * the rule's <code>BlockResponse</code> setting.
         * </p>
         * </li>
         * </ul>
         * 
         * @param action
         *        Optional additional filter for the rules to retrieve.</p>
         *        <p>
         *        The action that DNS Firewall should take on a DNS query when it matches one of the domains in the
         *        rule's domain list:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALLOW</code> - Permit the request to go through.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALERT</code> - Permit the request to go through but send an alert to the logs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are
         *        provided in the rule's <code>BlockResponse</code> setting.
         *        </p>
         *        </li>
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * <p>
         * The maximum number of objects that you want Resolver to return for this request. If more objects are
         * available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent
         * call to get the next batch of objects.
         * </p>
         * <p>
         * If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects that you want Resolver to return for this request. If more objects are
         *        available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a
         *        subsequent call to get the next batch of objects.</p>
         *        <p>
         *        If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * For the first call to this list request, omit this value.
         * </p>
         * <p>
         * When you request a list of objects, Resolver returns at most the number of objects specified in
         * <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was
         * returned for the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        For the first call to this list request, omit this value.</p>
         *        <p>
         *        When you request a list of objects, Resolver returns at most the number of objects specified in
         *        <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        that was returned for the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String firewallRuleGroupId;

        private Integer priority;

        private String action;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallRulesRequest model) {
            super(model);
            firewallRuleGroupId(model.firewallRuleGroupId);
            priority(model.priority);
            action(model.action);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getFirewallRuleGroupId() {
            return firewallRuleGroupId;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        @Override
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFirewallRulesRequest build() {
            return new ListFirewallRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
