/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig;

public class ListResolverDnssecConfigsPublisher
implements SdkPublisher<ListResolverDnssecConfigsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListResolverDnssecConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolverDnssecConfigsPublisher(Route53ResolverAsyncClient client, ListResolverDnssecConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolverDnssecConfigsPublisher(Route53ResolverAsyncClient client, ListResolverDnssecConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolverDnssecConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolverDnssecConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResolverDnssecConfig> resolverDnssecConfigs() {
        Function<ListResolverDnssecConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverDnssecConfigs() != null) {
                return response.resolverDnssecConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResolverDnssecConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResolverDnssecConfigsResponseFetcher
    implements AsyncPageFetcher<ListResolverDnssecConfigsResponse> {
        private ListResolverDnssecConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverDnssecConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolverDnssecConfigsResponse> nextPage(ListResolverDnssecConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverDnssecConfigsPublisher.this.client.listResolverDnssecConfigs(ListResolverDnssecConfigsPublisher.this.firstRequest);
            }
            return ListResolverDnssecConfigsPublisher.this.client.listResolverDnssecConfigs((ListResolverDnssecConfigsRequest)((Object)ListResolverDnssecConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

